/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.repository.language;

import com.google.gson.Gson;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.config.Configuration;
import org.sonar.scanner.http.DefaultScannerWsClient;
import org.sonar.scanner.repository.language.Language;
import org.sonar.scanner.repository.language.LanguagesLoader;
import org.sonar.scanner.repository.language.SupportedLanguageDto;
import org.sonarqube.ws.client.GetRequest;

public class DefaultLanguagesLoader
implements LanguagesLoader {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLanguagesLoader.class);
    private static final String LANGUAGES_WS_URL = "/api/languages/list";
    private static final Map<String, String> PROPERTY_FRAGMENT_MAP = Map.of("js", "javascript", "ts", "typescript", "py", "python", "web", "html");
    private final DefaultScannerWsClient wsClient;
    private final Configuration properties;

    public DefaultLanguagesLoader(DefaultScannerWsClient wsClient, Configuration properties) {
        this.wsClient = wsClient;
        this.properties = properties;
    }

    @Override
    public Map<String, Language> load() {
        LanguagesWSResponse response;
        GetRequest getRequest = new GetRequest(LANGUAGES_WS_URL);
        try (Reader reader = this.wsClient.call(getRequest).contentReader();){
            response = new Gson().fromJson(reader, LanguagesWSResponse.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to parse response of /api/languages/list", e);
        }
        return response.languages.stream().map(this::populateFileSuffixesAndPatterns).collect(Collectors.toMap(Language::key, Function.identity()));
    }

    private Language populateFileSuffixesAndPatterns(SupportedLanguageDto lang) {
        lang.setFileSuffixes(this.getFileSuffixes(lang.getKey()));
        lang.setFilenamePatterns(this.getFilenamePatterns(lang.getKey()));
        if (lang.filenamePatterns() == null && lang.getFileSuffixes() == null) {
            LOG.debug("Language '{}' cannot be detected as it has neither suffixes nor patterns.", (Object)lang.getName());
        }
        return new Language(lang);
    }

    private String[] getFileSuffixes(String languageKey) {
        return this.getPropertyForLanguage("sonar.%s.file.suffixes", languageKey);
    }

    private String[] getFilenamePatterns(String languageKey) {
        return this.getPropertyForLanguage("sonar.%s.file.patterns", languageKey);
    }

    private String[] getPropertyForLanguage(String propertyPattern, String languageKey) {
        String propName = String.format(propertyPattern, PROPERTY_FRAGMENT_MAP.getOrDefault(languageKey, languageKey));
        return this.properties.getStringArray(propName);
    }

    private static class LanguagesWSResponse {
        List<SupportedLanguageDto> languages;

        private LanguagesWSResponse() {
        }
    }
}

