/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.repository.featureflags;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.sonar.scanner.http.ScannerWsClient;
import org.sonar.scanner.repository.featureflags.FeatureFlagsLoader;
import org.sonarqube.ws.client.GetRequest;

public class DefaultFeatureFlagsLoader
implements FeatureFlagsLoader {
    private static final String FEATURE_FLAGS_WS_URL = "/api/features/list";
    private final ScannerWsClient wsClient;

    public DefaultFeatureFlagsLoader(ScannerWsClient wsClient) {
        this.wsClient = wsClient;
    }

    @Override
    public Set<String> load() {
        List jsonResponse;
        GetRequest getRequest = new GetRequest(FEATURE_FLAGS_WS_URL);
        try (Reader reader = this.wsClient.call(getRequest).contentReader();){
            jsonResponse = (List)new Gson().fromJson(reader, new TypeToken<ArrayList<String>>(){}.getType());
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to load feature flags", e);
        }
        return Set.copyOf(jsonResponse);
    }
}

