/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.repository;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.utils.Preconditions;

public class TelemetryCache {
    private static final Logger LOG = LoggerFactory.getLogger(TelemetryCache.class);
    private static final int MAX_ENTRIES = 1000;
    private final Map<String, String> telemetryEntries = new HashMap<String, String>();

    public TelemetryCache put(String key, String value) {
        Preconditions.checkArgument(key != null, "Key of the telemetry entry must not be null");
        Preconditions.checkArgument(value != null, "Value of the telemetry entry must not be null");
        if (this.telemetryEntries.size() < 1000 || this.telemetryEntries.containsKey(key)) {
            this.telemetryEntries.put(key, value);
        } else {
            LOG.warn("Telemetry cache is full, dropping telemetry metric '{}'", (Object)key);
        }
        return this;
    }

    public Map<String, String> getAll() {
        return this.telemetryEntries;
    }
}

