/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.repository;

import java.io.IOException;
import java.io.InputStream;
import org.sonar.api.impl.utils.ScannerUtils;
import org.sonar.scanner.http.DefaultScannerWsClient;
import org.sonar.scanner.repository.NewCodePeriodLoader;
import org.sonarqube.ws.NewCodePeriods;
import org.sonarqube.ws.client.GetRequest;
import org.sonarqube.ws.client.HttpException;

public class DefaultNewCodePeriodLoader
implements NewCodePeriodLoader {
    private static final String WS_URL = "/api/new_code_periods/show.protobuf";
    private final DefaultScannerWsClient wsClient;

    public DefaultNewCodePeriodLoader(DefaultScannerWsClient wsClient) {
        this.wsClient = wsClient;
    }

    @Override
    public NewCodePeriods.ShowWSResponse load(String projectKey, String branchName) {
        String url = "/api/new_code_periods/show.protobuf?project=" + ScannerUtils.encodeForUrl(projectKey) + "&branch=" + ScannerUtils.encodeForUrl(branchName);
        try {
            return this.call(url);
        }
        catch (IOException | HttpException e) {
            throw new IllegalStateException("Failed to get the New Code definition: " + e.getMessage(), e);
        }
    }

    private NewCodePeriods.ShowWSResponse call(String url) throws IOException {
        GetRequest getRequest = new GetRequest(url);
        try (InputStream is = this.wsClient.call(getRequest).contentStream();){
            NewCodePeriods.ShowWSResponse showWSResponse = NewCodePeriods.ShowWSResponse.parseFrom(is);
            return showWSResponse;
        }
    }
}

