/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.report;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import okhttp3.HttpUrl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.Startable;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.platform.Server;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.TempFolder;
import org.sonar.api.utils.ZipUtils;
import org.sonar.core.util.FileUtils;
import org.sonar.scanner.bootstrap.GlobalAnalysisMode;
import org.sonar.scanner.ci.CiConfiguration;
import org.sonar.scanner.fs.InputModuleHierarchy;
import org.sonar.scanner.http.DefaultScannerWsClient;
import org.sonar.scanner.protocol.output.FileStructure;
import org.sonar.scanner.protocol.output.ScannerReportReader;
import org.sonar.scanner.protocol.output.ScannerReportWriter;
import org.sonar.scanner.report.AnalysisContextReportPublisher;
import org.sonar.scanner.report.CeTaskReportDataHolder;
import org.sonar.scanner.report.JavaArchitectureInformationProvider;
import org.sonar.scanner.report.ReportPublisherStep;
import org.sonar.scanner.scan.ScanProperties;
import org.sonar.scanner.scan.branch.BranchConfiguration;
import org.sonar.scanner.scan.branch.BranchType;
import org.sonarqube.ws.Ce;
import org.sonarqube.ws.client.HttpException;
import org.sonarqube.ws.client.PostRequest;
import org.sonarqube.ws.client.RequestWithPayload;
import org.sonarqube.ws.client.WsResponse;

public class ReportPublisher
implements Startable {
    private static final Logger LOG = LoggerFactory.getLogger(ReportPublisher.class);
    private static final String CHARACTERISTIC = "characteristic";
    private static final String DASHBOARD = "dashboard";
    private static final String BRANCH = "branch";
    private static final String ID = "id";
    @VisibleForTesting
    static final String SUPPORT_OF_32_BIT_JRE_IS_DEPRECATED_MESSAGE = "You are using a 32 bits JRE. The support of 32 bits JRE is deprecated and a future version of the scanner will remove it completely.";
    private final DefaultScannerWsClient wsClient;
    private final AnalysisContextReportPublisher contextPublisher;
    private final InputModuleHierarchy moduleHierarchy;
    private final GlobalAnalysisMode analysisMode;
    private final TempFolder temp;
    private final ReportPublisherStep[] publishers;
    private final Server server;
    private final BranchConfiguration branchConfiguration;
    private final ScanProperties properties;
    private final CeTaskReportDataHolder ceTaskReportDataHolder;
    private final Path reportDir;
    private final ScannerReportWriter writer;
    private final ScannerReportReader reader;
    private final AnalysisWarnings analysisWarnings;
    private final JavaArchitectureInformationProvider javaArchitectureInformationProvider;
    private final CiConfiguration ciConfiguration;

    public ReportPublisher(ScanProperties properties, DefaultScannerWsClient wsClient, Server server, AnalysisContextReportPublisher contextPublisher, InputModuleHierarchy moduleHierarchy, GlobalAnalysisMode analysisMode, TempFolder temp, ReportPublisherStep[] publishers, BranchConfiguration branchConfiguration, CeTaskReportDataHolder ceTaskReportDataHolder, AnalysisWarnings analysisWarnings, JavaArchitectureInformationProvider javaArchitectureInformationProvider, FileStructure fileStructure, CiConfiguration ciConfiguration) {
        this.wsClient = wsClient;
        this.server = server;
        this.contextPublisher = contextPublisher;
        this.moduleHierarchy = moduleHierarchy;
        this.analysisMode = analysisMode;
        this.temp = temp;
        this.publishers = publishers;
        this.branchConfiguration = branchConfiguration;
        this.properties = properties;
        this.ceTaskReportDataHolder = ceTaskReportDataHolder;
        this.reportDir = fileStructure.root().toPath();
        this.analysisWarnings = analysisWarnings;
        this.javaArchitectureInformationProvider = javaArchitectureInformationProvider;
        this.writer = new ScannerReportWriter(fileStructure);
        this.reader = new ScannerReportReader(fileStructure);
        this.ciConfiguration = ciConfiguration;
    }

    @Override
    public void start() {
        String publicUrl;
        this.contextPublisher.init(this.writer);
        if (!this.analysisMode.isMediumTest() && HttpUrl.parse(publicUrl = this.server.getPublicRootUrl()) == null) {
            throw MessageException.of("Failed to parse public URL set in SonarQube server: " + publicUrl);
        }
    }

    @Override
    public void stop() {
        if (!this.properties.shouldKeepReport()) {
            FileUtils.deleteQuietly(this.reportDir);
        }
    }

    public Path getReportDir() {
        return this.reportDir;
    }

    public ScannerReportWriter getWriter() {
        return this.writer;
    }

    public ScannerReportReader getReader() {
        return this.reader;
    }

    public void execute() {
        this.logDeprecationWarningIf32bitJava();
        File report = this.generateReportFile();
        if (this.properties.shouldKeepReport()) {
            LOG.info("Analysis report generated in {}", (Object)this.reportDir);
        }
        if (!this.analysisMode.isMediumTest()) {
            String taskId = this.upload(report);
            this.prepareAndDumpMetadata(taskId);
        }
        this.logSuccess();
    }

    private void logDeprecationWarningIf32bitJava() {
        if (!this.javaArchitectureInformationProvider.is64bitJavaVersion()) {
            this.analysisWarnings.addUnique(SUPPORT_OF_32_BIT_JRE_IS_DEPRECATED_MESSAGE);
            LOG.warn(SUPPORT_OF_32_BIT_JRE_IS_DEPRECATED_MESSAGE);
        }
    }

    private File generateReportFile() {
        try {
            long startTime = System.currentTimeMillis();
            for (ReportPublisherStep publisher : this.publishers) {
                publisher.publish(this.writer);
            }
            long stopTime = System.currentTimeMillis();
            if (LOG.isInfoEnabled()) {
                LOG.info("Analysis report generated in {}ms, dir size={}", (Object)(stopTime - startTime), (Object)FileUtils.humanReadableByteCountSI(org.apache.commons.io.FileUtils.sizeOfDirectory(this.reportDir.toFile())));
            }
            startTime = System.currentTimeMillis();
            File reportZip = this.temp.newFile("scanner-report", ".zip");
            ZipUtils.zipDir(this.reportDir.toFile(), reportZip);
            stopTime = System.currentTimeMillis();
            if (LOG.isInfoEnabled()) {
                LOG.info("Analysis report compressed in {}ms, zip size={}", (Object)(stopTime - startTime), (Object)FileUtils.humanReadableByteCountSI(org.apache.commons.io.FileUtils.sizeOf(reportZip)));
            }
            return reportZip;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to prepare analysis report", e);
        }
    }

    private void logSuccess() {
        if (this.analysisMode.isMediumTest()) {
            LOG.info("ANALYSIS SUCCESSFUL");
        } else if (!this.properties.shouldWaitForQualityGate()) {
            LOG.info("ANALYSIS SUCCESSFUL, you can find the results at: {}", (Object)this.ceTaskReportDataHolder.getDashboardUrl());
            LOG.info("Note that you will be able to access the updated dashboard once the server has processed the submitted analysis report");
            LOG.info("More about the report processing at {}", (Object)this.ceTaskReportDataHolder.getCeTaskUrl());
        }
    }

    String upload(File report) {
        WsResponse response;
        LOG.debug("Upload report");
        long startTime = System.currentTimeMillis();
        RequestWithPayload.Part filePart = new RequestWithPayload.Part("application/zip", report);
        PostRequest post = (PostRequest)((RequestWithPayload)((RequestWithPayload)((RequestWithPayload)new PostRequest("api/ce/submit").setMediaType("application/x-protobuf")).setParam("projectKey", this.moduleHierarchy.root().key())).setParam("projectName", this.moduleHierarchy.root().getOriginalName())).setPart("report", filePart);
        this.ciConfiguration.getDevOpsPlatformInfo().ifPresent(devOpsPlatformInfo -> {
            post.setParam(CHARACTERISTIC, ReportPublisher.buildCharacteristicParam("devOpsPlatformUrl", devOpsPlatformInfo.getUrl()));
            post.setParam(CHARACTERISTIC, ReportPublisher.buildCharacteristicParam("devOpsPlatformProjectIdentifier", devOpsPlatformInfo.getProjectIdentifier()));
        });
        String branchName = this.branchConfiguration.branchName();
        if (branchName != null) {
            if (this.branchConfiguration.branchType() != BranchType.PULL_REQUEST) {
                post.setParam(CHARACTERISTIC, ReportPublisher.buildCharacteristicParam(BRANCH, branchName));
                post.setParam(CHARACTERISTIC, ReportPublisher.buildCharacteristicParam("branchType", this.branchConfiguration.branchType().name()));
            } else {
                post.setParam(CHARACTERISTIC, ReportPublisher.buildCharacteristicParam("pullRequest", this.branchConfiguration.pullRequestKey()));
            }
        }
        try {
            post.setWriteTimeOutInMs(this.properties.reportPublishTimeout() * 1000);
            response = this.wsClient.call(post);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to upload report: " + e.getMessage(), e);
        }
        try {
            response.failIfNotSuccessful();
        }
        catch (HttpException e) {
            throw MessageException.of(String.format("Server failed to process report. Please check server logs: %s", DefaultScannerWsClient.createErrorMessage(e)));
        }
        try {
            String string;
            block18: {
                InputStream protobuf = response.contentStream();
                try {
                    string = Ce.SubmitResponse.parser().parseFrom(protobuf).getTaskId();
                    if (protobuf == null) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        if (protobuf != null) {
                            try {
                                protobuf.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                protobuf.close();
            }
            return string;
        }
        finally {
            long stopTime = System.currentTimeMillis();
            LOG.info("Analysis report uploaded in {}ms", (Object)(stopTime - startTime));
        }
    }

    private static String buildCharacteristicParam(String characteristic, String value) {
        return characteristic + "=" + value;
    }

    void prepareAndDumpMetadata(String taskId) {
        LinkedHashMap<String, String> metadata = new LinkedHashMap<String, String>();
        metadata.put("projectKey", this.moduleHierarchy.root().key());
        metadata.put("serverUrl", this.server.getPublicRootUrl());
        metadata.put("serverVersion", this.server.getVersion());
        this.properties.branch().ifPresent(branch -> metadata.put(BRANCH, (String)branch));
        URL dashboardUrl = this.buildDashboardUrl(this.server.getPublicRootUrl(), this.moduleHierarchy.root().key());
        metadata.put("dashboardUrl", dashboardUrl.toExternalForm());
        URL taskUrl = HttpUrl.parse(this.server.getPublicRootUrl()).newBuilder().addPathSegment("api").addPathSegment("ce").addPathSegment("task").addQueryParameter(ID, taskId).build().url();
        metadata.put("ceTaskId", taskId);
        metadata.put("ceTaskUrl", taskUrl.toExternalForm());
        this.ceTaskReportDataHolder.init(taskId, taskUrl.toExternalForm(), dashboardUrl.toExternalForm());
        this.dumpMetadata(metadata);
    }

    private URL buildDashboardUrl(String publicUrl, String effectiveKey) {
        HttpUrl httpUrl = HttpUrl.parse(publicUrl);
        if (ReportPublisher.onPullRequest(this.branchConfiguration)) {
            return httpUrl.newBuilder().addPathSegment(DASHBOARD).addEncodedQueryParameter(ID, ReportPublisher.encoded(effectiveKey)).addEncodedQueryParameter("pullRequest", ReportPublisher.encoded(this.branchConfiguration.pullRequestKey())).build().url();
        }
        if (ReportPublisher.onBranch(this.branchConfiguration)) {
            return httpUrl.newBuilder().addPathSegment(DASHBOARD).addEncodedQueryParameter(ID, ReportPublisher.encoded(effectiveKey)).addEncodedQueryParameter(BRANCH, ReportPublisher.encoded(this.branchConfiguration.branchName())).build().url();
        }
        if (ReportPublisher.onMainBranch(this.branchConfiguration)) {
            return httpUrl.newBuilder().addPathSegment(DASHBOARD).addEncodedQueryParameter(ID, ReportPublisher.encoded(effectiveKey)).build().url();
        }
        return httpUrl.newBuilder().build().url();
    }

    private static boolean onPullRequest(BranchConfiguration branchConfiguration) {
        return branchConfiguration.branchName() != null && branchConfiguration.branchType() == BranchType.PULL_REQUEST;
    }

    private static boolean onBranch(BranchConfiguration branchConfiguration) {
        return branchConfiguration.branchName() != null && branchConfiguration.branchType() == BranchType.BRANCH;
    }

    private static boolean onMainBranch(BranchConfiguration branchConfiguration) {
        return branchConfiguration.branchName() == null;
    }

    private static String encoded(@Nullable String queryParameter) {
        if (StringUtils.isBlank(queryParameter)) {
            return "";
        }
        try {
            return URLEncoder.encode(queryParameter, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unable to urlencode " + queryParameter, e);
        }
    }

    private void dumpMetadata(Map<String, String> metadata) {
        Path file = this.properties.metadataFilePath();
        try {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            try (BufferedWriter output = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
                for (Map.Entry<String, String> entry : metadata.entrySet()) {
                    output.write(entry.getKey());
                    output.write("=");
                    output.write(entry.getValue());
                    output.write("\n");
                }
            }
            LOG.debug("Report metadata written to {}", (Object)file);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to dump " + String.valueOf(file), e);
        }
    }
}

