/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.report;

import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.scm.ScmProvider;
import org.sonar.scanner.ProjectInfo;
import org.sonar.scanner.bootstrap.ScannerPlugin;
import org.sonar.scanner.bootstrap.ScannerPluginRepository;
import org.sonar.scanner.cpd.CpdSettings;
import org.sonar.scanner.fs.InputModuleHierarchy;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.scanner.protocol.output.ScannerReportWriter;
import org.sonar.scanner.report.ReportPublisherStep;
import org.sonar.scanner.repository.ReferenceBranchSupplier;
import org.sonar.scanner.rule.QProfile;
import org.sonar.scanner.rule.QualityProfiles;
import org.sonar.scanner.scan.branch.BranchConfiguration;
import org.sonar.scanner.scan.branch.BranchType;
import org.sonar.scanner.scan.filesystem.InputComponentStore;
import org.sonar.scanner.scm.ScmConfiguration;
import org.sonar.scanner.scm.ScmRevision;

public class MetadataPublisher
implements ReportPublisherStep {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataPublisher.class);
    private final QualityProfiles qProfiles;
    private final ProjectInfo projectInfo;
    private final InputModuleHierarchy moduleHierarchy;
    private final CpdSettings cpdSettings;
    private final ScannerPluginRepository pluginRepository;
    private final BranchConfiguration branchConfiguration;
    private final ScmRevision scmRevision;
    private final InputComponentStore componentStore;
    private final ScmConfiguration scmConfiguration;
    private final ReferenceBranchSupplier referenceBranchSupplier;

    public MetadataPublisher(ProjectInfo projectInfo, InputModuleHierarchy moduleHierarchy, QualityProfiles qProfiles, CpdSettings cpdSettings, ScannerPluginRepository pluginRepository, BranchConfiguration branchConfiguration, ScmRevision scmRevision, InputComponentStore componentStore, ScmConfiguration scmConfiguration, ReferenceBranchSupplier referenceBranchSupplier) {
        this.projectInfo = projectInfo;
        this.moduleHierarchy = moduleHierarchy;
        this.qProfiles = qProfiles;
        this.cpdSettings = cpdSettings;
        this.pluginRepository = pluginRepository;
        this.branchConfiguration = branchConfiguration;
        this.scmRevision = scmRevision;
        this.componentStore = componentStore;
        this.scmConfiguration = scmConfiguration;
        this.referenceBranchSupplier = referenceBranchSupplier;
    }

    @Override
    public void publish(ScannerReportWriter writer) {
        String newCodeReferenceBranch;
        DefaultInputModule rootProject = this.moduleHierarchy.root();
        ScannerReport.Metadata.Builder builder = ScannerReport.Metadata.newBuilder().setAnalysisDate(this.projectInfo.getAnalysisDate().getTime()).setProjectKey(rootProject.key()).setCrossProjectDuplicationActivated(this.cpdSettings.isCrossProjectDuplicationEnabled()).setRootComponentRef(rootProject.scannerId());
        this.projectInfo.getProjectVersion().ifPresent(builder::setProjectVersion);
        this.projectInfo.getBuildString().ifPresent(builder::setBuildString);
        if (this.branchConfiguration.branchName() != null) {
            this.addBranchInformation(builder);
        }
        if ((newCodeReferenceBranch = this.referenceBranchSupplier.getFromProperties()) != null) {
            builder.setNewCodeReferenceBranch(newCodeReferenceBranch);
        }
        this.addScmInformation(builder);
        this.addIndexedFileCountsByExtension(builder);
        for (QProfile qProfile : this.qProfiles.findAll()) {
            builder.putQprofilesPerLanguage(qProfile.getLanguage(), ScannerReport.Metadata.QProfile.newBuilder().setKey(qProfile.getKey()).setLanguage(qProfile.getLanguage()).setName(qProfile.getName()).setRulesUpdatedAt(qProfile.getRulesUpdatedAt().getTime()).build());
        }
        for (Map.Entry entry : this.pluginRepository.getPluginsByKey().entrySet()) {
            builder.putPluginsByKey((String)entry.getKey(), ScannerReport.Metadata.Plugin.newBuilder().setKey((String)entry.getKey()).setUpdatedAt(((ScannerPlugin)entry.getValue()).getUpdatedAt()).build());
        }
        this.addRelativePathFromScmRoot(builder);
        writer.writeMetadata(builder.build());
    }

    private void addRelativePathFromScmRoot(ScannerReport.Metadata.Builder builder) {
        ScmProvider scmProvider = this.scmConfiguration.provider();
        if (scmProvider == null) {
            return;
        }
        Path projectBasedir = this.moduleHierarchy.root().getBaseDir();
        try {
            builder.setRelativePathFromScmRoot(MetadataPublisher.toSonarQubePath(scmProvider.relativePathFromScmRoot(projectBasedir)));
        }
        catch (UnsupportedOperationException e) {
            LOG.debug(e.getMessage());
        }
    }

    private void addScmInformation(ScannerReport.Metadata.Builder builder) {
        try {
            this.scmRevision.get().ifPresent(revisionId -> {
                LOG.info("SCM revision ID '{}'", revisionId);
                builder.setScmRevisionId((String)revisionId);
            });
        }
        catch (UnsupportedOperationException e) {
            LOG.debug(e.getMessage());
        }
    }

    private void addIndexedFileCountsByExtension(ScannerReport.Metadata.Builder builder) {
        builder.putAllAnalyzedIndexedFileCountPerType(this.componentStore.getAnalyzedIndexedFileCountPerExtension());
        builder.putAllNotAnalyzedIndexedFileCountPerType(this.componentStore.getNotAnalyzedIndexedFileCountPerExtension());
    }

    private void addBranchInformation(ScannerReport.Metadata.Builder builder) {
        String targetBranchName;
        builder.setBranchName(this.branchConfiguration.branchName());
        ScannerReport.Metadata.BranchType branchType = MetadataPublisher.toProtobufBranchType(this.branchConfiguration.branchType());
        builder.setBranchType(branchType);
        String referenceBranch = this.branchConfiguration.referenceBranchName();
        if (referenceBranch != null) {
            builder.setReferenceBranchName(referenceBranch);
        }
        if ((targetBranchName = this.branchConfiguration.targetBranchName()) != null) {
            builder.setTargetBranchName(targetBranchName);
        }
        if (branchType == ScannerReport.Metadata.BranchType.PULL_REQUEST) {
            builder.setPullRequestKey(this.branchConfiguration.pullRequestKey());
        }
    }

    private static ScannerReport.Metadata.BranchType toProtobufBranchType(BranchType branchType) {
        if (branchType == BranchType.PULL_REQUEST) {
            return ScannerReport.Metadata.BranchType.PULL_REQUEST;
        }
        return ScannerReport.Metadata.BranchType.BRANCH;
    }

    private static String toSonarQubePath(Path path) {
        String pathAsString = path.toString();
        char sonarQubeSeparatorChar = '/';
        if (File.separatorChar != sonarQubeSeparatorChar) {
            return pathAsString.replaceAll(Pattern.quote(File.separator), String.valueOf(sonarQubeSeparatorChar));
        }
        return pathAsString;
    }
}

