/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.report;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import org.sonar.api.batch.scm.ScmProvider;
import org.sonar.scanner.ci.CiConfiguration;
import org.sonar.scanner.config.DefaultConfiguration;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.scanner.protocol.output.ScannerReportWriter;
import org.sonar.scanner.report.ReportPublisherStep;
import org.sonar.scanner.repository.ContextPropertiesCache;
import org.sonar.scanner.scm.ScmConfiguration;

public class ContextPropertiesPublisher
implements ReportPublisherStep {
    private final ContextPropertiesCache cache;
    private final DefaultConfiguration config;
    private final ScmConfiguration scmConfiguration;
    private final CiConfiguration ciConfiguration;

    public ContextPropertiesPublisher(ContextPropertiesCache cache, DefaultConfiguration config, ScmConfiguration scmConfiguration, CiConfiguration ciConfiguration) {
        this.cache = cache;
        this.config = config;
        this.scmConfiguration = scmConfiguration;
        this.ciConfiguration = ciConfiguration;
    }

    @Override
    public void publish(ScannerReportWriter writer) {
        ArrayList<Map.Entry<String, String>> properties = new ArrayList<Map.Entry<String, String>>(this.cache.getAll().entrySet());
        properties.add(this.constructScmInfo());
        properties.add(this.constructCiInfo());
        properties.addAll(this.config.getProperties().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("sonar.analysis.")).toList());
        writer.writeContextProperties(properties.stream().map(e -> ScannerReport.ContextProperty.newBuilder().setKey((String)e.getKey()).setValue((String)e.getValue()).build()).toList());
    }

    private Map.Entry<String, String> constructScmInfo() {
        ScmProvider scmProvider = this.scmConfiguration.provider();
        if (scmProvider != null) {
            return new AbstractMap.SimpleEntry<String, String>("sonar.analysis.detectedscm", scmProvider.key());
        }
        return new AbstractMap.SimpleEntry<String, String>("sonar.analysis.detectedscm", "undetected");
    }

    private Map.Entry<String, String> constructCiInfo() {
        return new AbstractMap.SimpleEntry<String, String>("sonar.analysis.detectedci", this.ciConfiguration.getCiName());
    }
}

