/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.report;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.fs.internal.DefaultInputProject;
import org.sonar.api.batch.scm.ScmProvider;
import org.sonar.api.impl.utils.ScannerUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.scanner.protocol.output.ScannerReportWriter;
import org.sonar.scanner.report.ReportPublisherStep;
import org.sonar.scanner.repository.ReferenceBranchSupplier;
import org.sonar.scanner.scan.branch.BranchConfiguration;
import org.sonar.scanner.scan.filesystem.InputComponentStore;
import org.sonar.scanner.scm.ScmConfiguration;
import org.sonar.scm.git.ChangedFile;
import org.sonar.scm.git.GitScmProvider;

public class ChangedLinesPublisher
implements ReportPublisherStep {
    private static final Logger LOG = Loggers.get(ChangedLinesPublisher.class);
    private static final String LOG_MSG = "SCM writing changed lines";
    private final ScmConfiguration scmConfiguration;
    private final DefaultInputProject project;
    private final InputComponentStore inputComponentStore;
    private final BranchConfiguration branchConfiguration;
    private final ReferenceBranchSupplier referenceBranchSupplier;

    public ChangedLinesPublisher(ScmConfiguration scmConfiguration, DefaultInputProject project, InputComponentStore inputComponentStore, BranchConfiguration branchConfiguration, ReferenceBranchSupplier referenceBranchSupplier) {
        this.scmConfiguration = scmConfiguration;
        this.project = project;
        this.inputComponentStore = inputComponentStore;
        this.branchConfiguration = branchConfiguration;
        this.referenceBranchSupplier = referenceBranchSupplier;
    }

    @Override
    public void publish(ScannerReportWriter writer) {
        Optional<String> targetBranch = this.getTargetBranch();
        if (targetBranch.isPresent()) {
            Profiler profiler = Profiler.create(LOG).startInfo(LOG_MSG);
            int count = this.writeChangedLines(this.scmConfiguration.provider(), writer, targetBranch.get());
            LOG.debug("SCM reported changed lines for {} {} in the branch", (Object)count, (Object)ScannerUtils.pluralize("file", count));
            profiler.stopInfo();
        }
    }

    private Optional<String> getTargetBranch() {
        if (this.scmConfiguration.isDisabled() || this.scmConfiguration.provider() == null) {
            return Optional.empty();
        }
        String targetBranchName = this.branchConfiguration.targetBranchName();
        if (this.branchConfiguration.isPullRequest() && targetBranchName != null) {
            return Optional.of(targetBranchName);
        }
        return Optional.ofNullable(this.referenceBranchSupplier.get());
    }

    private int writeChangedLines(ScmProvider provider, ScannerReportWriter writer, String targetScmBranch) {
        Path rootBaseDir = this.project.getBaseDir();
        Map changedFiles = StreamSupport.stream(this.inputComponentStore.allChangedFilesToPublish().spliterator(), false).collect(Collectors.toMap(DefaultInputFile::path, Function.identity()));
        Map<Path, Set<Integer>> pathSetMap = ChangedLinesPublisher.getBranchChangedLinesByScm(provider, targetScmBranch, rootBaseDir, ChangedLinesPublisher.toChangedFilesByPathMap(changedFiles.values()));
        int count = 0;
        if (pathSetMap == null) {
            return count;
        }
        for (Map.Entry e : changedFiles.entrySet()) {
            DefaultInputFile inputFile = (DefaultInputFile)e.getValue();
            Set<Integer> changedLines = pathSetMap.get(e.getKey());
            if (changedLines == null) {
                if (this.branchConfiguration.isPullRequest()) {
                    LOG.warn("File '{}' was detected as changed but without having changed lines", (Object)e.getKey().toAbsolutePath());
                }
                ChangedLinesPublisher.writeChangedLines(writer, ((DefaultInputFile)e.getValue()).scannerId(), Collections.emptySet());
                continue;
            }
            if (changedLines.size() + 1 == inputFile.lines() && inputFile.lineLength(inputFile.lines()) == 0) {
                changedLines.add(inputFile.lines());
            }
            ++count;
            ChangedLinesPublisher.writeChangedLines(writer, ((DefaultInputFile)e.getValue()).scannerId(), changedLines);
        }
        return count;
    }

    private static void writeChangedLines(ScannerReportWriter writer, int fileRef, Set<Integer> changedLines) {
        ScannerReport.ChangedLines.Builder builder = ScannerReport.ChangedLines.newBuilder();
        builder.addAllLine(changedLines);
        writer.writeComponentChangedLines(fileRef, builder.build());
    }

    @CheckForNull
    private static Map<Path, Set<Integer>> getBranchChangedLinesByScm(ScmProvider scmProvider, String targetScmBranch, Path rootBaseDir, Map<Path, ChangedFile> changedFiles) {
        if (scmProvider instanceof GitScmProvider) {
            GitScmProvider gitScmProvider = (GitScmProvider)scmProvider;
            return gitScmProvider.branchChangedLinesWithFileMovementDetection(targetScmBranch, rootBaseDir, changedFiles);
        }
        return scmProvider.branchChangedLines(targetScmBranch, rootBaseDir, changedFiles.keySet());
    }

    private static Map<Path, ChangedFile> toChangedFilesByPathMap(Collection<DefaultInputFile> files) {
        return files.stream().map(ChangedFile::of).collect(Collectors.toMap(ChangedFile::getAbsolutFilePath, Function.identity()));
    }
}

