/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.report;

import java.util.Objects;

public class CeTaskReportDataHolder {
    private boolean initialized = false;
    private String ceTaskId = null;
    private String ceTaskUrl = null;
    private String dashboardUrl = null;

    public void init(String ceTaskId, String ceTaskUrl, String dashboardUrl) {
        Objects.requireNonNull(ceTaskId, "CE task id must not be null");
        Objects.requireNonNull(ceTaskUrl, "CE task url must not be null");
        Objects.requireNonNull(dashboardUrl, "Dashboard url map must not be null");
        this.ceTaskId = ceTaskId;
        this.ceTaskUrl = ceTaskUrl;
        this.dashboardUrl = dashboardUrl;
        this.initialized = true;
    }

    private void verifyInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Scan report hasn't been published yet");
        }
    }

    public String getCeTaskId() {
        this.verifyInitialized();
        return this.ceTaskId;
    }

    public String getDashboardUrl() {
        this.verifyInitialized();
        return this.dashboardUrl;
    }

    public String getCeTaskUrl() {
        this.verifyInitialized();
        return this.ceTaskUrl;
    }
}

