/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.protocol.output;

import com.google.protobuf.AbstractMessageLite;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.io.FileUtils;
import org.sonar.core.util.ContextException;
import org.sonar.core.util.Protobuf;
import org.sonar.scanner.protocol.output.FileStructure;
import org.sonar.scanner.protocol.output.ScannerReport;

@Immutable
public class ScannerReportWriter {
    private final FileStructure fileStructure;

    public ScannerReportWriter(FileStructure fileStructure) {
        this.fileStructure = fileStructure;
    }

    public FileStructure getFileStructure() {
        return this.fileStructure;
    }

    public boolean hasComponentData(FileStructure.Domain domain, int componentRef) {
        File file = this.fileStructure.fileFor(domain, componentRef);
        return file.exists() && file.isFile();
    }

    public File writeMetadata(ScannerReport.Metadata metadata) {
        Protobuf.write(metadata, this.fileStructure.metadataFile());
        return this.fileStructure.metadataFile();
    }

    public File writeActiveRules(Iterable<ScannerReport.ActiveRule> activeRules) {
        Protobuf.writeStream(activeRules, this.fileStructure.activeRules(), false);
        return this.fileStructure.metadataFile();
    }

    public File writeComponent(ScannerReport.Component component) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.COMPONENT, component.getRef());
        Protobuf.write(component, file);
        return file;
    }

    public File writeComponentIssues(int componentRef, Iterable<ScannerReport.Issue> issues) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.ISSUES, componentRef);
        Protobuf.writeStream(issues, file, false);
        return file;
    }

    public File writeComponentSignificantCode(int componentRef, Iterable<ScannerReport.LineSgnificantCode> lineSignificantCode) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.SGNIFICANT_CODE, componentRef);
        Protobuf.writeStream(lineSignificantCode, file, false);
        return file;
    }

    public void appendComponentIssue(int componentRef, ScannerReport.Issue issue) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.ISSUES, componentRef);
        ScannerReportWriter.appendDelimitedTo(file, issue, "issue");
    }

    public File writeComponentChangedLines(int componentRef, ScannerReport.ChangedLines changedLines) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.CHANGED_LINES, componentRef);
        Protobuf.write(changedLines, file);
        return file;
    }

    public void appendComponentExternalIssue(int componentRef, ScannerReport.ExternalIssue issue) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.EXTERNAL_ISSUES, componentRef);
        ScannerReportWriter.appendDelimitedTo(file, issue, "external issue");
    }

    public void appendAdHocRule(ScannerReport.AdHocRule adHocRule) {
        File file = this.fileStructure.adHocRules();
        ScannerReportWriter.appendDelimitedTo(file, adHocRule, "ad hoc rule");
    }

    public void appendComponentMeasure(int componentRef, ScannerReport.Measure measure) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.MEASURES, componentRef);
        ScannerReportWriter.appendDelimitedTo(file, measure, "measure");
    }

    private static void appendDelimitedTo(File file, AbstractMessageLite<?, ?> msg, String msgName) {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file, true));){
            msg.writeDelimitedTo(out);
        }
        catch (Exception e) {
            throw ContextException.of("Unable to write " + msgName, e).addContext("file", file);
        }
    }

    public File writeComponentChangesets(ScannerReport.Changesets changesets) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.CHANGESETS, changesets.getComponentRef());
        Protobuf.write(changesets, file);
        return file;
    }

    public File writeComponentDuplications(int componentRef, Iterable<ScannerReport.Duplication> duplications) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.DUPLICATIONS, componentRef);
        Protobuf.writeStream(duplications, file, false);
        return file;
    }

    public File writeCpdTextBlocks(int componentRef, Iterable<ScannerReport.CpdTextBlock> blocks) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.CPD_TEXT_BLOCKS, componentRef);
        Protobuf.writeStream(blocks, file, false);
        return file;
    }

    public File writeComponentSymbols(int componentRef, Iterable<ScannerReport.Symbol> symbols) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.SYMBOLS, componentRef);
        Protobuf.writeStream(symbols, file, false);
        return file;
    }

    public File writeComponentSyntaxHighlighting(int componentRef, Iterable<ScannerReport.SyntaxHighlightingRule> syntaxHighlightingRules) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.SYNTAX_HIGHLIGHTINGS, componentRef);
        Protobuf.writeStream(syntaxHighlightingRules, file, false);
        return file;
    }

    public File writeComponentCoverage(int componentRef, Iterable<ScannerReport.LineCoverage> coverageList) {
        File file = this.fileStructure.fileFor(FileStructure.Domain.COVERAGES, componentRef);
        Protobuf.writeStream(coverageList, file, false);
        return file;
    }

    public File writeContextProperties(Iterable<ScannerReport.ContextProperty> properties) {
        File file = this.fileStructure.contextProperties();
        Protobuf.writeStream(properties, file, false);
        return file;
    }

    public File writeAnalysisWarnings(Iterable<ScannerReport.AnalysisWarning> analysisWarnings) {
        File file = this.fileStructure.analysisWarnings();
        Protobuf.writeStream(analysisWarnings, file, false);
        return file;
    }

    public File writeTelemetry(Iterable<ScannerReport.TelemetryEntry> telemetryEntries) {
        File file = this.fileStructure.telemetryEntries();
        Protobuf.writeStream(telemetryEntries, file, false);
        return file;
    }

    public File appendAnalysisData(ScannerReport.AnalysisData analysisData) {
        File file = this.fileStructure.analysisData();
        ScannerReportWriter.appendDelimitedTo(file, analysisData, "analysis data for " + analysisData.getKey());
        return file;
    }

    public File getSourceFile(int componentRef) {
        return this.fileStructure.fileFor(FileStructure.Domain.SOURCE, componentRef);
    }

    public void writeScaFile(File scaFile) {
        File sca = this.fileStructure.scaDir();
        try {
            FileUtils.copyFileToDirectory(scaFile, sca);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Unable to copy sca file '%s' to sca folder", scaFile), e);
        }
    }
}

