/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue.ignore.pattern;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.MessageException;
import org.sonar.scanner.issue.ignore.pattern.AbstractPatternInitializer;
import org.sonar.scanner.issue.ignore.pattern.BlockIssuePattern;

public class IssueExclusionPatternInitializer
extends AbstractPatternInitializer {
    public static final String CONFIG_KEY = "sonar.issue.ignore.multicriteria";
    private List<BlockIssuePattern> blockPatterns;
    private List<String> allFilePatterns;

    public IssueExclusionPatternInitializer(Configuration settings) {
        super(settings);
        this.loadFileContentPatterns();
    }

    @Override
    protected String getMulticriteriaConfigurationKey() {
        return CONFIG_KEY;
    }

    @Override
    public boolean hasConfiguredPatterns() {
        return this.hasFileContentPattern() || this.hasMulticriteriaPatterns();
    }

    private void loadFileContentPatterns() {
        String propPrefix;
        this.blockPatterns = new ArrayList<BlockIssuePattern>();
        for (String id : this.getSettings().getStringArray("sonar.issue.ignore.block")) {
            propPrefix = "sonar.issue.ignore.block." + id + ".";
            String beginBlockRegexp = this.getSettings().get(propPrefix + "beginBlockRegexp").orElse(null);
            if (StringUtils.isBlank(beginBlockRegexp)) {
                throw MessageException.of("Issue exclusions are misconfigured. Start block regexp is mandatory for each entry of 'sonar.issue.ignore.block'");
            }
            String endBlockRegexp = this.getSettings().get(propPrefix + "endBlockRegexp").orElse(null);
            BlockIssuePattern pattern = new BlockIssuePattern(IssueExclusionPatternInitializer.nullToEmpty(beginBlockRegexp), IssueExclusionPatternInitializer.nullToEmpty(endBlockRegexp));
            this.blockPatterns.add(pattern);
        }
        this.blockPatterns = Collections.unmodifiableList(this.blockPatterns);
        this.allFilePatterns = new ArrayList<String>();
        for (String id : this.getSettings().getStringArray("sonar.issue.ignore.allfile")) {
            propPrefix = "sonar.issue.ignore.allfile." + id + ".";
            String allFileRegexp = this.getSettings().get(propPrefix + "fileRegexp").orElse(null);
            if (StringUtils.isBlank(allFileRegexp)) {
                throw MessageException.of("Issue exclusions are misconfigured. Remove blank entries from 'sonar.issue.ignore.allfile'");
            }
            this.allFilePatterns.add(IssueExclusionPatternInitializer.nullToEmpty(allFileRegexp));
        }
        this.allFilePatterns = Collections.unmodifiableList(this.allFilePatterns);
    }

    private static String nullToEmpty(@Nullable String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public List<BlockIssuePattern> getBlockPatterns() {
        return this.blockPatterns;
    }

    public List<String> getAllFilePatterns() {
        return this.allFilePatterns;
    }

    public boolean hasFileContentPattern() {
        return !this.blockPatterns.isEmpty() || !this.allFilePatterns.isEmpty();
    }
}

