/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue.ignore.pattern;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.MessageException;
import org.sonar.scanner.issue.ignore.pattern.IssuePattern;

public abstract class AbstractPatternInitializer {
    private final Configuration settings;
    private List<IssuePattern> multicriteriaPatterns;

    protected AbstractPatternInitializer(Configuration config) {
        this.settings = config;
        this.initPatterns();
    }

    protected Configuration getSettings() {
        return this.settings;
    }

    public List<IssuePattern> getMulticriteriaPatterns() {
        return this.multicriteriaPatterns;
    }

    public boolean hasConfiguredPatterns() {
        return this.hasMulticriteriaPatterns();
    }

    public boolean hasMulticriteriaPatterns() {
        return !this.multicriteriaPatterns.isEmpty();
    }

    protected final void initPatterns() {
        this.multicriteriaPatterns = new ArrayList<IssuePattern>();
        for (String id : this.settings.getStringArray(this.getMulticriteriaConfigurationKey())) {
            String propPrefix = this.getMulticriteriaConfigurationKey() + "." + id + ".";
            String filePathPattern = this.settings.get(propPrefix + "resourceKey").orElse(null);
            if (StringUtils.isBlank(filePathPattern)) {
                throw MessageException.of("Issue exclusions are misconfigured. File pattern is mandatory for each entry of '" + this.getMulticriteriaConfigurationKey() + "'");
            }
            String ruleKeyPattern = this.settings.get(propPrefix + "ruleKey").orElse(null);
            if (StringUtils.isBlank(ruleKeyPattern)) {
                throw MessageException.of("Issue exclusions are misconfigured. Rule key pattern is mandatory for each entry of '" + this.getMulticriteriaConfigurationKey() + "'");
            }
            IssuePattern pattern = new IssuePattern(filePathPattern, ruleKeyPattern);
            this.multicriteriaPatterns.add(pattern);
        }
    }

    protected abstract String getMulticriteriaConfigurationKey();
}

