/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.Strings;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.fs.internal.DefaultInputComponent;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.issue.ExternalIssue;
import org.sonar.api.batch.sensor.issue.Issue;
import org.sonar.api.batch.sensor.issue.IssueLocation;
import org.sonar.api.batch.sensor.issue.MessageFormatting;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.internal.DefaultIssueFlow;
import org.sonar.api.issue.impact.SoftwareQuality;
import org.sonar.api.rules.CleanCodeAttribute;
import org.sonar.api.rules.RuleType;
import org.sonar.scanner.issue.ImpactMapper;
import org.sonar.scanner.issue.IssueFilters;
import org.sonar.scanner.protocol.Constants;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.scanner.report.ReportPublisher;

@ThreadSafe
public class IssuePublisher {
    private static final Set<String> noSonarKeyContains = Set.of("nosonar", "S1291");
    private final ActiveRules activeRules;
    private final IssueFilters filters;
    private final ReportPublisher reportPublisher;

    public IssuePublisher(ActiveRules activeRules, IssueFilters filters, ReportPublisher reportPublisher) {
        this.activeRules = activeRules;
        this.filters = filters;
        this.reportPublisher = reportPublisher;
    }

    public boolean initAndAddIssue(Issue issue) {
        DefaultInputComponent inputComponent = (DefaultInputComponent)issue.primaryLocation().inputComponent();
        if (IssuePublisher.noSonar(inputComponent, issue)) {
            return false;
        }
        ActiveRule activeRule = this.activeRules.find(issue.ruleKey());
        if (activeRule == null) {
            return false;
        }
        ScannerReport.Issue rawIssue = IssuePublisher.createReportIssue(issue, inputComponent.scannerId());
        if (this.filters.accept(inputComponent, rawIssue, activeRule.severity())) {
            this.write(inputComponent.scannerId(), rawIssue);
            return true;
        }
        return false;
    }

    private static boolean noSonar(DefaultInputComponent inputComponent, Issue issue) {
        TextRange textRange = issue.primaryLocation().textRange();
        return inputComponent.isFile() && textRange != null && ((DefaultInputFile)inputComponent).hasNoSonarAt(textRange.start().line()) && noSonarKeyContains.stream().noneMatch(k -> Strings.CI.contains(issue.ruleKey().rule(), (CharSequence)k));
    }

    public void initAndAddExternalIssue(ExternalIssue issue) {
        DefaultInputComponent inputComponent = (DefaultInputComponent)issue.primaryLocation().inputComponent();
        ScannerReport.ExternalIssue rawExternalIssue = IssuePublisher.createReportExternalIssue(issue, inputComponent.scannerId());
        this.write(inputComponent.scannerId(), rawExternalIssue);
    }

    private static String nullToEmpty(@Nullable String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    private static ScannerReport.Issue createReportIssue(Issue issue, int componentRef) {
        List<String> internalTags;
        Double gap;
        TextRange primaryTextRange;
        String primaryMessage = IssuePublisher.nullToEmpty(issue.primaryLocation().message());
        ScannerReport.Issue.Builder builder = ScannerReport.Issue.newBuilder();
        ScannerReport.IssueLocation.Builder locationBuilder = ScannerReport.IssueLocation.newBuilder();
        ScannerReport.TextRange.Builder textRangeBuilder = ScannerReport.TextRange.newBuilder();
        builder.setRuleRepository(issue.ruleKey().repository());
        builder.setRuleKey(issue.ruleKey().rule());
        builder.setMsg(primaryMessage);
        builder.addAllMsgFormatting(IssuePublisher.toProtobufMessageFormattings(issue.primaryLocation().messageFormattings()));
        EnumMap<SoftwareQuality, org.sonar.api.issue.impact.Severity> overriddenImpacts = new EnumMap<SoftwareQuality, org.sonar.api.issue.impact.Severity>(issue.overridenImpacts());
        builder.addAllOverriddenImpacts(IssuePublisher.toProtobufImpacts(overriddenImpacts));
        locationBuilder.setMsg(primaryMessage);
        locationBuilder.addAllMsgFormatting(IssuePublisher.toProtobufMessageFormattings(issue.primaryLocation().messageFormattings()));
        locationBuilder.setComponentRef(componentRef);
        Severity overriddenSeverity = issue.overriddenSeverity();
        if (overriddenSeverity != null) {
            builder.setOverriddenSeverity(Constants.Severity.valueOf(overriddenSeverity.name()));
        }
        if ((primaryTextRange = issue.primaryLocation().textRange()) != null) {
            builder.setTextRange(IssuePublisher.toProtobufTextRange(textRangeBuilder, primaryTextRange));
        }
        if ((gap = issue.gap()) != null) {
            builder.setGap(gap);
        }
        IssuePublisher.applyFlows(builder::addFlow, locationBuilder, textRangeBuilder, issue.flows());
        builder.setQuickFixAvailable(issue.isQuickFixAvailable());
        issue.ruleDescriptionContextKey().ifPresent(builder::setRuleDescriptionContextKey);
        List<String> codeVariants = issue.codeVariants();
        if (codeVariants != null) {
            builder.addAllCodeVariants(codeVariants);
        }
        if ((internalTags = issue.internalTags()) != null) {
            builder.addAllInternalTags(internalTags);
        }
        return builder.build();
    }

    private static List<ScannerReport.Impact> toProtobufImpacts(Map<SoftwareQuality, org.sonar.api.issue.impact.Severity> softwareQualitySeverityMap) {
        ArrayList<ScannerReport.Impact> impacts = new ArrayList<ScannerReport.Impact>();
        softwareQualitySeverityMap.forEach((q, s) -> impacts.add(ScannerReport.Impact.newBuilder().setSoftwareQuality(ScannerReport.SoftwareQuality.valueOf(q.name())).setSeverity(ImpactMapper.mapImpactSeverity(s)).build()));
        return impacts;
    }

    private static List<ScannerReport.MessageFormatting> toProtobufMessageFormattings(List<MessageFormatting> messageFormattings) {
        return messageFormattings.stream().map(m -> ScannerReport.MessageFormatting.newBuilder().setStart(m.start()).setEnd(m.end()).setType(ScannerReport.MessageFormattingType.valueOf(m.type().name())).build()).toList();
    }

    private static ScannerReport.ExternalIssue createReportExternalIssue(ExternalIssue issue, int componentRef) {
        Long effort;
        RuleType issueType;
        Severity severity;
        String primaryMessage = issue.primaryLocation().message();
        ScannerReport.ExternalIssue.Builder builder = ScannerReport.ExternalIssue.newBuilder();
        ScannerReport.IssueLocation.Builder locationBuilder = ScannerReport.IssueLocation.newBuilder();
        ScannerReport.TextRange.Builder textRangeBuilder = ScannerReport.TextRange.newBuilder();
        builder.setEngineId(issue.engineId());
        builder.setRuleId(issue.ruleId());
        builder.setMsg(primaryMessage);
        builder.addAllMsgFormatting(IssuePublisher.toProtobufMessageFormattings(issue.primaryLocation().messageFormattings()));
        locationBuilder.setMsg(primaryMessage);
        locationBuilder.addAllMsgFormatting(IssuePublisher.toProtobufMessageFormattings(issue.primaryLocation().messageFormattings()));
        locationBuilder.setComponentRef(componentRef);
        TextRange primaryTextRange = issue.primaryLocation().textRange();
        CleanCodeAttribute cleanCodeAttribute = issue.cleanCodeAttribute();
        if (cleanCodeAttribute != null) {
            builder.setCleanCodeAttribute(cleanCodeAttribute.name());
        }
        if ((severity = issue.severity()) != null) {
            builder.setSeverity(Constants.Severity.valueOf(severity.name()));
        }
        if ((issueType = issue.type()) != null) {
            builder.setType(ScannerReport.IssueType.valueOf(issueType.name()));
        }
        if (primaryTextRange != null) {
            builder.setTextRange(IssuePublisher.toProtobufTextRange(textRangeBuilder, primaryTextRange));
        }
        if ((effort = issue.remediationEffort()) != null) {
            builder.setEffort(effort);
        }
        IssuePublisher.applyFlows(builder::addFlow, locationBuilder, textRangeBuilder, issue.flows());
        builder.addAllImpacts(IssuePublisher.toProtobufImpacts(issue.impacts()));
        return builder.build();
    }

    private static void applyFlows(Consumer<ScannerReport.Flow> consumer, ScannerReport.IssueLocation.Builder locationBuilder, ScannerReport.TextRange.Builder textRangeBuilder, Collection<Issue.Flow> flows) {
        ScannerReport.Flow.Builder flowBuilder = ScannerReport.Flow.newBuilder();
        for (Issue.Flow f : flows) {
            DefaultIssueFlow flow = (DefaultIssueFlow)f;
            if (flow.locations().isEmpty()) {
                return;
            }
            flowBuilder.clear();
            for (IssueLocation location : flow.locations()) {
                TextRange textRange;
                int locationComponentRef = ((DefaultInputComponent)location.inputComponent()).scannerId();
                locationBuilder.clear();
                locationBuilder.setComponentRef(locationComponentRef);
                String message = location.message();
                if (message != null) {
                    locationBuilder.setMsg(message);
                    locationBuilder.addAllMsgFormatting(IssuePublisher.toProtobufMessageFormattings(location.messageFormattings()));
                }
                if ((textRange = location.textRange()) != null) {
                    locationBuilder.setTextRange(IssuePublisher.toProtobufTextRange(textRangeBuilder, textRange));
                }
                flowBuilder.addLocation(locationBuilder.build());
            }
            if (flow.description() != null) {
                flowBuilder.setDescription(flow.description());
            }
            flowBuilder.setType(IssuePublisher.toProtobufFlowType(flow.type()));
            consumer.accept(flowBuilder.build());
        }
    }

    private static ScannerReport.FlowType toProtobufFlowType(NewIssue.FlowType flowType) {
        switch (flowType) {
            case EXECUTION: {
                return ScannerReport.FlowType.EXECUTION;
            }
            case DATA: {
                return ScannerReport.FlowType.DATA;
            }
            case UNDEFINED: {
                return ScannerReport.FlowType.UNDEFINED;
            }
        }
        throw new IllegalArgumentException("Unrecognized flow type: " + String.valueOf((Object)flowType));
    }

    private static ScannerReport.TextRange toProtobufTextRange(ScannerReport.TextRange.Builder textRangeBuilder, TextRange primaryTextRange) {
        textRangeBuilder.clear();
        textRangeBuilder.setStartLine(primaryTextRange.start().line());
        textRangeBuilder.setStartOffset(primaryTextRange.start().lineOffset());
        textRangeBuilder.setEndLine(primaryTextRange.end().line());
        textRangeBuilder.setEndOffset(primaryTextRange.end().lineOffset());
        return textRangeBuilder.build();
    }

    public void write(int batchId, ScannerReport.Issue rawIssue) {
        this.reportPublisher.getWriter().appendComponentIssue(batchId, rawIssue);
    }

    public void write(int batchId, ScannerReport.ExternalIssue rawIssue) {
        this.reportPublisher.getWriter().appendComponentExternalIssue(batchId, rawIssue);
    }
}

