/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import javax.annotation.Nullable;
import nl.altindag.ssl.SSLFactory;
import nl.altindag.ssl.exception.GenericKeyStoreException;
import nl.altindag.ssl.util.KeyStoreUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.utils.System2;
import org.sonar.batch.bootstrapper.EnvironmentInformation;
import org.sonar.scanner.bootstrap.GlobalAnalysisMode;
import org.sonar.scanner.bootstrap.ScannerProperties;
import org.sonar.scanner.bootstrap.SonarUserHome;
import org.sonar.scanner.http.DefaultScannerWsClient;
import org.sonar.scanner.http.ssl.CertificateStore;
import org.sonar.scanner.http.ssl.SslConfig;
import org.sonarqube.ws.client.HttpConnector;
import org.sonarqube.ws.client.WsClientFactories;
import org.springframework.context.annotation.Bean;

public class ScannerWsClientProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ScannerWsClientProvider.class);
    static final int DEFAULT_CONNECT_TIMEOUT = 5;
    static final int DEFAULT_RESPONSE_TIMEOUT = 0;
    static final String READ_TIMEOUT_SEC_PROPERTY = "sonar.ws.timeout";
    public static final String TOKEN_PROPERTY = "sonar.token";
    private static final String TOKEN_ENV_VARIABLE = "SONAR_TOKEN";
    static final int DEFAULT_READ_TIMEOUT_SEC = 60;
    public static final String SONAR_SCANNER_PROXY_PORT = "sonar.scanner.proxyPort";
    public static final String SONAR_SCANNER_CONNECT_TIMEOUT = "sonar.scanner.connectTimeout";
    public static final String SONAR_SCANNER_SOCKET_TIMEOUT = "sonar.scanner.socketTimeout";
    public static final String SONAR_SCANNER_RESPONSE_TIMEOUT = "sonar.scanner.responseTimeout";
    public static final String SKIP_SYSTEM_TRUST_MATERIAL = "sonar.scanner.skipSystemTruststore";

    @Bean(value={"DefaultScannerWsClient"})
    public DefaultScannerWsClient provide(ScannerProperties scannerProps, EnvironmentInformation env, GlobalAnalysisMode globalMode, System2 system, AnalysisWarnings analysisWarnings, SonarUserHome sonarUserHome) {
        String scannerProxyUser;
        String proxyUser;
        String url = StringUtils.defaultIfBlank(scannerProps.property("sonar.host.url"), "http://localhost:9000");
        HttpConnector.Builder connectorBuilder = HttpConnector.newBuilder().acceptGzip(true);
        String oldSocketTimeout = StringUtils.defaultIfBlank(scannerProps.property(READ_TIMEOUT_SEC_PROPERTY), String.valueOf(60));
        String socketTimeout = StringUtils.defaultIfBlank(scannerProps.property(SONAR_SCANNER_SOCKET_TIMEOUT), oldSocketTimeout);
        String connectTimeout = StringUtils.defaultIfBlank(scannerProps.property(SONAR_SCANNER_CONNECT_TIMEOUT), String.valueOf(5));
        String responseTimeout = StringUtils.defaultIfBlank(scannerProps.property(SONAR_SCANNER_RESPONSE_TIMEOUT), String.valueOf(0));
        String envVarToken = StringUtils.defaultIfBlank(system.envVariable(TOKEN_ENV_VARIABLE), null);
        String token = StringUtils.defaultIfBlank(scannerProps.property(TOKEN_PROPERTY), envVarToken);
        String login = StringUtils.defaultIfBlank(token, scannerProps.property("sonar.login"));
        boolean skipSystemTrustMaterial = Boolean.parseBoolean(StringUtils.defaultIfBlank(scannerProps.property(SKIP_SYSTEM_TRUST_MATERIAL), "false"));
        SSLFactory sslContext = ScannerWsClientProvider.configureSsl(ScannerWsClientProvider.parseSslConfig(scannerProps, sonarUserHome), system, skipSystemTrustMaterial);
        connectorBuilder.readTimeoutMilliseconds(ScannerWsClientProvider.parseDurationProperty(socketTimeout, SONAR_SCANNER_SOCKET_TIMEOUT)).connectTimeoutMilliseconds(ScannerWsClientProvider.parseDurationProperty(connectTimeout, SONAR_SCANNER_CONNECT_TIMEOUT)).responseTimeoutMilliseconds(ScannerWsClientProvider.parseDurationProperty(responseTimeout, SONAR_SCANNER_RESPONSE_TIMEOUT)).userAgent(env.toString()).url(url).token(login).setSSLSocketFactory(sslContext.getSslSocketFactory()).setTrustManager(sslContext.getTrustManager().orElseThrow());
        String proxyHost = StringUtils.defaultIfBlank(scannerProps.property("sonar.scanner.proxyHost"), null);
        if (proxyHost != null) {
            String proxyPortStr = StringUtils.defaultIfBlank(scannerProps.property(SONAR_SCANNER_PROXY_PORT), url.startsWith("https") ? "443" : "80");
            int proxyPort = ScannerWsClientProvider.parseIntProperty(proxyPortStr, SONAR_SCANNER_PROXY_PORT);
            connectorBuilder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort)));
        }
        String string = proxyUser = (scannerProxyUser = scannerProps.property("sonar.scanner.proxyUser")) != null ? scannerProxyUser : system.properties().getProperty("http.proxyUser", "");
        if (StringUtils.isNotBlank(proxyUser)) {
            String scannerProxyPwd = scannerProps.property("sonar.scanner.proxyPassword");
            String proxyPassword = scannerProxyPwd != null ? scannerProxyPwd : system.properties().getProperty("http.proxyPassword", "");
            connectorBuilder.proxyCredentials(proxyUser, proxyPassword);
        }
        return new DefaultScannerWsClient(WsClientFactories.getDefault().newClient(connectorBuilder.build()), login != null, globalMode, analysisWarnings);
    }

    private static int parseIntProperty(String propValue, String propKey) {
        try {
            return Integer.parseInt(propValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(propKey + " is not a valid integer: " + propValue, e);
        }
    }

    private static int parseDurationProperty(String propValue, String propKey) {
        try {
            return (int)Duration.parse(propValue).toMillis();
        }
        catch (DateTimeParseException e) {
            return ScannerWsClientProvider.parseIntProperty(propValue, propKey) * 1000;
        }
    }

    private static SslConfig parseSslConfig(ScannerProperties scannerProperties, SonarUserHome sonarUserHome) {
        String keyStorePath = StringUtils.defaultIfBlank(scannerProperties.property("sonar.scanner.keystorePath"), sonarUserHome.getPath().resolve("ssl/keystore.p12").toString());
        String keyStorePassword = scannerProperties.property("sonar.scanner.keystorePassword");
        CertificateStore keyStore = new CertificateStore(Path.of(keyStorePath, new String[0]), keyStorePassword);
        String trustStorePath = StringUtils.defaultIfBlank(scannerProperties.property("sonar.scanner.truststorePath"), sonarUserHome.getPath().resolve("ssl/truststore.p12").toString());
        String trustStorePassword = scannerProperties.property("sonar.scanner.truststorePassword");
        CertificateStore trustStore = new CertificateStore(Path.of(trustStorePath, new String[0]), trustStorePassword);
        return new SslConfig(keyStore, trustStore);
    }

    private static SSLFactory configureSsl(SslConfig sslConfig, System2 system2, boolean skipSystemTrustMaterial) {
        CertificateStore trustStoreConfig;
        CertificateStore keyStoreConfig;
        SSLFactory.Builder sslFactoryBuilder = SSLFactory.builder().withDefaultTrustMaterial();
        if (!skipSystemTrustMaterial) {
            LOG.debug("Loading OS trusted SSL certificates...");
            LOG.debug("This operation might be slow or even get stuck. You can skip it by passing the scanner property '{}=true'", (Object)SKIP_SYSTEM_TRUST_MATERIAL);
            sslFactoryBuilder.withSystemTrustMaterial();
        }
        if (system2.properties().containsKey("javax.net.ssl.keyStore")) {
            sslFactoryBuilder.withSystemPropertyDerivedIdentityMaterial();
        }
        if ((keyStoreConfig = sslConfig.getKeyStore()) != null && Files.exists(keyStoreConfig.getPath(), new LinkOption[0])) {
            keyStoreConfig.getKeyStorePassword().ifPresentOrElse(password -> sslFactoryBuilder.withIdentityMaterial(keyStoreConfig.getPath(), password.toCharArray(), keyStoreConfig.getKeyStoreType()), () -> ScannerWsClientProvider.loadIdentityMaterialWithDefaultPassword(sslFactoryBuilder, keyStoreConfig.getPath()));
        }
        if ((trustStoreConfig = sslConfig.getTrustStore()) != null && Files.exists(trustStoreConfig.getPath(), new LinkOption[0])) {
            KeyStore trustStore;
            try {
                trustStore = ScannerWsClientProvider.loadTrustStoreWithBouncyCastle(trustStoreConfig.getPath(), trustStoreConfig.getKeyStorePassword().orElse(null), trustStoreConfig.getKeyStoreType());
                LOG.debug("Loaded truststore from '{}' containing {} certificates", (Object)trustStoreConfig.getPath(), (Object)trustStore.size());
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new GenericKeyStoreException("Unable to read truststore from '" + String.valueOf(trustStoreConfig.getPath()) + "'", e);
            }
            sslFactoryBuilder.withTrustMaterial(trustStore);
        }
        return sslFactoryBuilder.build();
    }

    private static void loadIdentityMaterialWithDefaultPassword(SSLFactory.Builder sslFactoryBuilder, Path path) {
        try {
            KeyStore keystore = KeyStoreUtils.loadKeyStore(path, "changeit".toCharArray(), "PKCS12");
            sslFactoryBuilder.withIdentityMaterial(keystore, "changeit".toCharArray());
        }
        catch (GenericKeyStoreException e) {
            KeyStore keystore = KeyStoreUtils.loadKeyStore(path, "sonar".toCharArray(), "PKCS12");
            LOG.warn("Using deprecated default password for keystore '{}'.", (Object)path);
            sslFactoryBuilder.withIdentityMaterial(keystore, "sonar".toCharArray());
        }
    }

    static KeyStore loadTrustStoreWithBouncyCastle(Path keystorePath, @Nullable String keystorePassword, String keystoreType) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        KeyStore keystore = KeyStore.getInstance(keystoreType, new BouncyCastleProvider());
        if (keystorePassword != null) {
            ScannerWsClientProvider.loadKeyStoreWithPassword(keystorePath, keystore, keystorePassword);
        } else {
            try {
                ScannerWsClientProvider.loadKeyStoreWithPassword(keystorePath, keystore, "changeit");
            }
            catch (Exception e) {
                ScannerWsClientProvider.loadKeyStoreWithPassword(keystorePath, keystore, "sonar");
                LOG.warn("Using deprecated default password for truststore '{}'.", (Object)keystorePath);
            }
        }
        return keystore;
    }

    private static void loadKeyStoreWithPassword(Path keystorePath, KeyStore keystore, String oldDefaultPassword) throws IOException, NoSuchAlgorithmException, CertificateException {
        try (InputStream keystoreInputStream = Files.newInputStream(keystorePath, StandardOpenOption.READ);){
            keystore.load(keystoreInputStream, oldDefaultPassword.toCharArray());
        }
    }
}

