/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.genericcoverage;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.coverage.NewCoverage;
import org.sonar.api.utils.MessageException;
import org.sonar.scanner.genericcoverage.StaxParser;

public class GenericCoverageReportParser {
    private static final Logger LOG = LoggerFactory.getLogger(GenericCoverageReportParser.class);
    private static final String LINE_NUMBER_ATTR = "lineNumber";
    private static final String COVERED_ATTR = "covered";
    private static final String BRANCHES_TO_COVER_ATTR = "branchesToCover";
    private static final String COVERED_BRANCHES_ATTR = "coveredBranches";
    private static final int MAX_STORED_UNKNOWN_FILE_PATHS = 5;
    private int numberOfUnknownFiles;
    private final List<String> firstUnknownFiles = new ArrayList<String>();
    private final Set<String> matchedFileKeys = new HashSet<String>();

    public void parse(File reportFile, SensorContext context) {
        try (FileInputStream inputStream2 = new FileInputStream(reportFile);){
            this.parse(inputStream2, context);
        }
        catch (Exception e) {
            throw MessageException.of("Error during parsing of the generic coverage report '" + String.valueOf(reportFile) + "'. Look at SonarQube documentation to know the expected XML format.", e);
        }
    }

    private void parse(InputStream inputStream2, SensorContext context) throws XMLStreamException {
        new StaxParser(rootCursor -> {
            rootCursor.advance();
            this.parseRootNode(rootCursor, context);
        }).parse(inputStream2);
    }

    private void parseRootNode(SMHierarchicCursor rootCursor, SensorContext context) throws XMLStreamException {
        GenericCoverageReportParser.checkElementName(rootCursor, "coverage");
        String version = rootCursor.getAttrValue("version");
        if (!"1".equals(version)) {
            throw new IllegalStateException("Unknown report version: " + version + ". This parser only handles version 1.");
        }
        this.parseFiles(rootCursor.childElementCursor(), context);
    }

    private void parseFiles(SMInputCursor fileCursor, SensorContext context) throws XMLStreamException {
        while (fileCursor.getNext() != null) {
            GenericCoverageReportParser.checkElementName(fileCursor, "file");
            String filePath = GenericCoverageReportParser.mandatoryAttribute(fileCursor, "path");
            InputFile inputFile = context.fileSystem().inputFile(context.fileSystem().predicates().hasPath(filePath));
            if (inputFile == null || inputFile.language() == null) {
                ++this.numberOfUnknownFiles;
                if (this.numberOfUnknownFiles <= 5) {
                    this.firstUnknownFiles.add(filePath);
                }
                if (inputFile == null) continue;
                LOG.debug("Skipping file '{}' in the generic coverage report because it doesn't have a known language", (Object)filePath);
                continue;
            }
            this.matchedFileKeys.add(inputFile.key());
            NewCoverage newCoverage = context.newCoverage().onFile(inputFile);
            SMInputCursor lineToCoverCursor = fileCursor.childElementCursor();
            while (lineToCoverCursor.getNext() != null) {
                GenericCoverageReportParser.parseLineToCover(lineToCoverCursor, newCoverage);
            }
            newCoverage.save();
        }
    }

    private static void parseLineToCover(SMInputCursor cursor, NewCoverage newCoverage) throws XMLStreamException {
        GenericCoverageReportParser.checkElementName(cursor, "lineToCover");
        String lineNumberAsString = GenericCoverageReportParser.mandatoryAttribute(cursor, LINE_NUMBER_ATTR);
        int lineNumber = GenericCoverageReportParser.intValue(lineNumberAsString, cursor, LINE_NUMBER_ATTR, 1);
        boolean covered = GenericCoverageReportParser.getCoveredValue(cursor);
        newCoverage.lineHits(lineNumber, covered ? 1 : 0);
        String branchesToCoverAsString = cursor.getAttrValue(BRANCHES_TO_COVER_ATTR);
        if (branchesToCoverAsString != null) {
            int branchesToCover = GenericCoverageReportParser.intValue(branchesToCoverAsString, cursor, BRANCHES_TO_COVER_ATTR, 0);
            String coveredBranchesAsString = cursor.getAttrValue(COVERED_BRANCHES_ATTR);
            int coveredBranches = 0;
            if (coveredBranchesAsString != null && (coveredBranches = GenericCoverageReportParser.intValue(coveredBranchesAsString, cursor, COVERED_BRANCHES_ATTR, 0)) > branchesToCover) {
                throw new IllegalStateException("\"coveredBranches\" should not be greater than \"branchesToCover\" on line " + cursor.getCursorLocation().getLineNumber());
            }
            newCoverage.conditions(lineNumber, branchesToCover, coveredBranches);
        }
    }

    private static boolean getCoveredValue(SMInputCursor cursor) throws XMLStreamException {
        String coveredAsString = GenericCoverageReportParser.mandatoryAttribute(cursor, COVERED_ATTR);
        if (!"true".equalsIgnoreCase(coveredAsString) && !"false".equalsIgnoreCase(coveredAsString)) {
            throw new IllegalStateException(GenericCoverageReportParser.expectedMessage("boolean value", COVERED_ATTR, coveredAsString, cursor.getCursorLocation().getLineNumber()));
        }
        return Boolean.parseBoolean(coveredAsString);
    }

    static void checkElementName(SMInputCursor cursor, String expectedName) throws XMLStreamException {
        String elementName = cursor.getLocalName();
        if (!expectedName.equals(elementName)) {
            throw new IllegalStateException("Unknown XML node, expected \"" + expectedName + "\" but got \"" + elementName + "\" at line " + cursor.getCursorLocation().getLineNumber());
        }
    }

    static String mandatoryAttribute(SMInputCursor cursor, String attributeName) throws XMLStreamException {
        String attributeValue = cursor.getAttrValue(attributeName);
        if (attributeValue == null) {
            throw new IllegalStateException("Missing attribute \"" + attributeName + "\" in element \"" + cursor.getLocalName() + "\" at line " + cursor.getCursorLocation().getLineNumber());
        }
        return attributeValue;
    }

    static int intValue(String stringValue, SMInputCursor cursor, String attributeName, int minimum) throws XMLStreamException {
        int intValue;
        try {
            intValue = Integer.valueOf(stringValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(GenericCoverageReportParser.expectedMessage("integer value", attributeName, stringValue, cursor.getCursorLocation().getLineNumber()), e);
        }
        if (intValue < minimum) {
            throw new IllegalStateException("Value of attribute \"" + attributeName + "\" at line " + cursor.getCursorLocation().getLineNumber() + " is \"" + intValue + "\" but it should be greater than or equal to " + minimum);
        }
        return intValue;
    }

    static long longValue(String stringValue, SMInputCursor cursor, String attributeName, long minimum) throws XMLStreamException {
        long longValue;
        try {
            longValue = Long.valueOf(stringValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(GenericCoverageReportParser.expectedMessage("long value", attributeName, stringValue, cursor.getCursorLocation().getLineNumber()), e);
        }
        if (longValue < minimum) {
            throw new IllegalStateException("Value of attribute \"" + attributeName + "\" at line " + cursor.getCursorLocation().getLineNumber() + " is \"" + longValue + "\" but it should be greater than or equal to " + minimum);
        }
        return longValue;
    }

    private static String expectedMessage(String expected, String attributeName, String stringValue, int line) {
        return "Expected " + expected + " for attribute \"" + attributeName + "\" at line " + line + " but got \"" + stringValue + "\"";
    }

    public int numberOfMatchedFiles() {
        return this.matchedFileKeys.size();
    }

    public int numberOfUnknownFiles() {
        return this.numberOfUnknownFiles;
    }

    public List<String> firstUnknownFiles() {
        return this.firstUnknownFiles;
    }
}

