/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.externalissue.sarif;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.rule.NewAdHocRule;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.utils.Preconditions;
import org.sonar.sarif.pojo.ReportingDescriptor;
import org.sonar.sarif.pojo.Result;
import org.sonar.sarif.pojo.Run;
import org.sonar.sarif.pojo.Tool;
import org.sonar.sarif.pojo.ToolComponent;
import org.sonar.scanner.externalissue.sarif.ResultMapper;
import org.sonar.scanner.externalissue.sarif.RuleMapper;
import org.sonar.scanner.externalissue.sarif.RulesSeverityDetector;

@ScannerSide
public class RunMapper {
    private static final Logger LOG = LoggerFactory.getLogger(RunMapper.class);
    private final ResultMapper resultMapper;
    private final RuleMapper ruleMapper;

    RunMapper(ResultMapper resultMapper, RuleMapper ruleMapper) {
        this.resultMapper = resultMapper;
        this.ruleMapper = ruleMapper;
    }

    RunMapperResult mapRun(Run run) {
        if (run.getResults().isEmpty()) {
            return new RunMapperResult();
        }
        String driverName = RunMapper.getToolDriverName(run);
        Map<String, Result.Level> ruleSeveritiesByRuleId = RulesSeverityDetector.detectRulesSeverities(run, driverName);
        Map<String, Result.Level> ruleSeveritiesByRuleIdForNewCCT = RulesSeverityDetector.detectRulesSeveritiesForNewTaxonomy(run, driverName);
        return new RunMapperResult().newAdHocRules(this.toNewAdHocRules(run, driverName, ruleSeveritiesByRuleId, ruleSeveritiesByRuleIdForNewCCT)).newExternalIssues(this.toNewExternalIssues(run, driverName, ruleSeveritiesByRuleId, ruleSeveritiesByRuleIdForNewCCT));
    }

    private static String getToolDriverName(Run run) throws IllegalArgumentException {
        Preconditions.checkArgument(RunMapper.hasToolDriverNameDefined(run), "The run does not have a tool driver name defined.");
        return run.getTool().getDriver().getName();
    }

    private static boolean hasToolDriverNameDefined(Run run) {
        return Optional.ofNullable(run).map(Run::getTool).map(Tool::getDriver).map(ToolComponent::getName).isPresent();
    }

    private List<NewAdHocRule> toNewAdHocRules(Run run, String driverName, Map<String, Result.Level> ruleSeveritiesByRuleId, Map<String, Result.Level> ruleSeveritiesByRuleIdForNewCCT) {
        Set driverRules = Optional.ofNullable(run.getTool().getDriver().getRules()).orElse(Set.of());
        Set extensionRules = RunMapper.hasExtensions(run.getTool()) ? run.getTool().getExtensions().stream().filter(RunMapper::hasRules).flatMap(extension -> extension.getRules().stream()).collect(Collectors.toSet()) : Set.of();
        return Stream.concat(driverRules.stream(), extensionRules.stream()).distinct().map(rule -> this.ruleMapper.mapRule((ReportingDescriptor)rule, driverName, (Result.Level)((Object)((Object)ruleSeveritiesByRuleId.get(rule.getId()))), (Result.Level)((Object)((Object)ruleSeveritiesByRuleIdForNewCCT.get(rule.getId()))))).toList();
    }

    private static boolean hasExtensions(Tool tool) {
        return tool.getExtensions() != null && !tool.getExtensions().isEmpty();
    }

    private static boolean hasRules(ToolComponent extension) {
        return extension.getRules() != null && !extension.getRules().isEmpty();
    }

    private List<NewExternalIssue> toNewExternalIssues(Run run, String driverName, Map<String, Result.Level> ruleSeveritiesByRuleId, Map<String, Result.Level> ruleSeveritiesByRuleIdForNewCCT) {
        return run.getResults().stream().map(result -> this.toNewExternalIssue(driverName, (Result.Level)((Object)((Object)ruleSeveritiesByRuleId.get(result.getRuleId()))), (Result.Level)((Object)((Object)ruleSeveritiesByRuleIdForNewCCT.get(result.getRuleId()))), (Result)result)).filter(Optional::isPresent).map(Optional::get).toList();
    }

    private Optional<NewExternalIssue> toNewExternalIssue(String driverName, @Nullable Result.Level ruleSeverity, @Nullable Result.Level ruleSeverityForNewTaxonomy, Result result) {
        try {
            return Optional.of(this.resultMapper.mapResult(driverName, ruleSeverity, ruleSeverityForNewTaxonomy, result));
        }
        catch (Exception exception) {
            LOG.warn("Failed to import an issue raised by tool {}, error: {}", (Object)driverName, (Object)exception.getMessage());
            return Optional.empty();
        }
    }

    static class RunMapperResult {
        private List<NewExternalIssue> newExternalIssues = Collections.emptyList();
        private List<NewAdHocRule> newAdHocRules = Collections.emptyList();
        private boolean success = true;

        public RunMapperResult newExternalIssues(List<NewExternalIssue> newExternalIssues) {
            this.newExternalIssues = newExternalIssues;
            return this;
        }

        public RunMapperResult newAdHocRules(List<NewAdHocRule> newAdHocRules) {
            this.newAdHocRules = newAdHocRules;
            return this;
        }

        public RunMapperResult success(boolean success) {
            this.success = success;
            return this;
        }

        public List<NewExternalIssue> getNewExternalIssues() {
            return this.newExternalIssues;
        }

        public List<NewAdHocRule> getNewAdHocRules() {
            return this.newAdHocRules;
        }

        public boolean isSuccess() {
            return this.success;
        }
    }
}

