/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.externalissue.sarif;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.sarif.pojo.ReportingConfiguration;
import org.sonar.sarif.pojo.ReportingDescriptor;
import org.sonar.sarif.pojo.Result;
import org.sonar.sarif.pojo.Run;
import org.sonar.sarif.pojo.Tool;
import org.sonar.sarif.pojo.ToolComponent;
import org.sonar.scanner.externalissue.sarif.ResultMapper;

public class RulesSeverityDetector {
    private static final Logger LOG = LoggerFactory.getLogger(RulesSeverityDetector.class);
    private static final String UNSUPPORTED_RULE_SEVERITIES_WARNING = "Unable to detect rules severity for issue detected by tool {}, falling back to default rule severity: {}";

    private RulesSeverityDetector() {
    }

    public static Map<String, Result.Level> detectRulesSeverities(Run run, String driverName) {
        Map<String, Result.Level> resultDefinedRuleSeverities = RulesSeverityDetector.getResultDefinedRuleSeverities(run);
        if (!resultDefinedRuleSeverities.isEmpty()) {
            return resultDefinedRuleSeverities;
        }
        Map<String, Result.Level> driverDefinedRuleSeverities = RulesSeverityDetector.getDriverDefinedRuleSeverities(run);
        if (!driverDefinedRuleSeverities.isEmpty()) {
            return driverDefinedRuleSeverities;
        }
        Map<String, Result.Level> extensionDefinedRuleSeverities = RulesSeverityDetector.getExtensionsDefinedRuleSeverities(run);
        if (!extensionDefinedRuleSeverities.isEmpty()) {
            return extensionDefinedRuleSeverities;
        }
        LOG.warn(UNSUPPORTED_RULE_SEVERITIES_WARNING, (Object)driverName, (Object)ResultMapper.DEFAULT_SEVERITY.name());
        return Collections.emptyMap();
    }

    public static Map<String, Result.Level> detectRulesSeveritiesForNewTaxonomy(Run run, String driverName) {
        Map<String, Result.Level> driverDefinedRuleSeverities = RulesSeverityDetector.getDriverDefinedRuleSeverities(run);
        if (!driverDefinedRuleSeverities.isEmpty()) {
            return driverDefinedRuleSeverities;
        }
        Map<String, Result.Level> extensionDefinedRuleSeverities = RulesSeverityDetector.getExtensionsDefinedRuleSeverities(run);
        if (!extensionDefinedRuleSeverities.isEmpty()) {
            return extensionDefinedRuleSeverities;
        }
        LOG.warn(UNSUPPORTED_RULE_SEVERITIES_WARNING, (Object)driverName, (Object)ResultMapper.DEFAULT_IMPACT_SEVERITY.name());
        return Collections.emptyMap();
    }

    private static Map<String, Result.Level> getResultDefinedRuleSeverities(Run run) {
        Predicate<Result> hasResultDefinedLevel = result -> Optional.ofNullable(result).map(Result::getLevel).isPresent();
        return run.getResults().stream().filter(hasResultDefinedLevel).collect(Collectors.toMap(Result::getRuleId, Result::getLevel, (x, y) -> y));
    }

    private static Map<String, Result.Level> getDriverDefinedRuleSeverities(Run run) {
        Set<ReportingDescriptor> rules = run.getTool().getDriver().getRules();
        if (rules == null) {
            return Collections.emptyMap();
        }
        return rules.stream().filter(RulesSeverityDetector::hasRuleDefinedLevel).collect(Collectors.toMap(ReportingDescriptor::getId, x -> Result.Level.valueOf(x.getDefaultConfiguration().getLevel().name())));
    }

    private static Map<String, Result.Level> getExtensionsDefinedRuleSeverities(Run run) {
        return RulesSeverityDetector.getExtensions(run).stream().map(ToolComponent::getRules).filter(Objects::nonNull).flatMap(Collection::stream).filter(RulesSeverityDetector::hasRuleDefinedLevel).collect(Collectors.toMap(ReportingDescriptor::getId, rule -> Result.Level.valueOf(rule.getDefaultConfiguration().getLevel().name())));
    }

    private static Set<ToolComponent> getExtensions(Run run) {
        return Optional.of(run).map(Run::getTool).map(Tool::getExtensions).orElse(Collections.emptySet());
    }

    private static boolean hasRuleDefinedLevel(@Nullable ReportingDescriptor rule) {
        return Optional.ofNullable(rule).map(ReportingDescriptor::getDefaultConfiguration).map(ReportingConfiguration::getLevel).isPresent();
    }
}

