/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.externalissue.sarif;

import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.rule.NewAdHocRule;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.sarif.pojo.ReportingDescriptor;
import org.sonar.sarif.pojo.Result;
import org.sonar.scanner.externalissue.sarif.ResultMapper;

@ScannerSide
public class RuleMapper {
    private final SensorContext sensorContext;

    public RuleMapper(SensorContext sensorContext) {
        this.sensorContext = sensorContext;
    }

    NewAdHocRule mapRule(ReportingDescriptor rule, String driverName, @Nullable Result.Level ruleSeverity, @Nullable Result.Level ruleSeverityForNewTaxonomy) {
        NewAdHocRule newAdHocRule = this.sensorContext.newAdHocRule().severity(ResultMapper.toSonarQubeSeverity(ruleSeverity)).type(ResultMapper.DEFAULT_TYPE).ruleId(rule.getId()).engineId(driverName).cleanCodeAttribute(ResultMapper.DEFAULT_CLEAN_CODE_ATTRIBUTE).addDefaultImpact(ResultMapper.DEFAULT_SOFTWARE_QUALITY, ResultMapper.toSonarQubeImpactSeverity(ruleSeverityForNewTaxonomy));
        if (rule.getShortDescription() != null && !StringUtils.isBlank(rule.getShortDescription().getText())) {
            newAdHocRule.name(rule.getShortDescription().getText());
        } else {
            newAdHocRule.name(String.join((CharSequence)":", driverName, rule.getId()));
        }
        if (rule.getFullDescription() != null && !StringUtils.isBlank(rule.getFullDescription().getText())) {
            newAdHocRule.description(rule.getFullDescription().getText());
        }
        return newAdHocRule;
    }
}

