/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.externalissue.sarif;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.issue.impact.SoftwareQuality;
import org.sonar.api.rules.CleanCodeAttribute;
import org.sonar.api.rules.RuleType;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.sarif.pojo.Location;
import org.sonar.sarif.pojo.Message;
import org.sonar.sarif.pojo.Result;
import org.sonar.scanner.externalissue.sarif.LocationMapper;

@ScannerSide
public class ResultMapper {
    private static final Map<Result.Level, Severity> SEVERITY_MAPPING = ImmutableMap.builder().put(Result.Level.ERROR, Severity.CRITICAL).put(Result.Level.WARNING, Severity.MAJOR).put(Result.Level.NOTE, Severity.MINOR).put(Result.Level.NONE, Severity.INFO).build();
    private static final Map<Result.Level, org.sonar.api.issue.impact.Severity> IMPACT_SEVERITY_MAPPING = ImmutableMap.builder().put(Result.Level.ERROR, org.sonar.api.issue.impact.Severity.HIGH).put(Result.Level.WARNING, org.sonar.api.issue.impact.Severity.MEDIUM).put(Result.Level.NOTE, org.sonar.api.issue.impact.Severity.LOW).put(Result.Level.NONE, org.sonar.api.issue.impact.Severity.LOW).build();
    public static final Severity DEFAULT_SEVERITY = Severity.MAJOR;
    public static final RuleType DEFAULT_TYPE = RuleType.VULNERABILITY;
    public static final CleanCodeAttribute DEFAULT_CLEAN_CODE_ATTRIBUTE = CleanCodeAttribute.CONVENTIONAL;
    public static final SoftwareQuality DEFAULT_SOFTWARE_QUALITY = SoftwareQuality.SECURITY;
    public static final org.sonar.api.issue.impact.Severity DEFAULT_IMPACT_SEVERITY = org.sonar.api.issue.impact.Severity.MEDIUM;
    private final SensorContext sensorContext;
    private final LocationMapper locationMapper;

    ResultMapper(SensorContext sensorContext, LocationMapper locationMapper) {
        this.sensorContext = sensorContext;
        this.locationMapper = locationMapper;
    }

    NewExternalIssue mapResult(String driverName, @Nullable Result.Level ruleSeverity, @Nullable Result.Level ruleSeverityForNewTaxonomy, Result result) {
        NewExternalIssue newExternalIssue = this.sensorContext.newExternalIssue();
        newExternalIssue.type(DEFAULT_TYPE);
        newExternalIssue.engineId(driverName);
        newExternalIssue.severity(ResultMapper.toSonarQubeSeverity(ruleSeverity));
        newExternalIssue.ruleId(Objects.requireNonNull(result.getRuleId(), "No ruleId found for issue thrown by driver " + driverName));
        newExternalIssue.cleanCodeAttribute(DEFAULT_CLEAN_CODE_ATTRIBUTE);
        newExternalIssue.addImpact(DEFAULT_SOFTWARE_QUALITY, ResultMapper.toSonarQubeImpactSeverity(ruleSeverityForNewTaxonomy));
        this.mapLocations(result, newExternalIssue);
        return newExternalIssue;
    }

    protected static org.sonar.api.issue.impact.Severity toSonarQubeImpactSeverity(@Nullable Result.Level ruleSeverity) {
        return IMPACT_SEVERITY_MAPPING.getOrDefault((Object)ruleSeverity, DEFAULT_IMPACT_SEVERITY);
    }

    protected static Severity toSonarQubeSeverity(@Nullable Result.Level ruleSeverity) {
        return SEVERITY_MAPPING.getOrDefault((Object)ruleSeverity, DEFAULT_SEVERITY);
    }

    private void mapLocations(Result result, NewExternalIssue newExternalIssue) {
        this.createPrimaryLocation(newExternalIssue, result);
        this.createSecondaryLocations(result, newExternalIssue);
        this.createFlows(result, newExternalIssue);
    }

    private void createFlows(Result result, NewExternalIssue newExternalIssue) {
        Set stacks = Optional.ofNullable(result.getStacks()).orElse(Set.of());
        if (!stacks.isEmpty()) {
            stacks.forEach(stack -> {
                List frames = Optional.ofNullable(stack.getFrames()).orElse(List.of());
                if (!frames.isEmpty()) {
                    ArrayList<NewIssueLocation> flow = new ArrayList<NewIssueLocation>();
                    frames.forEach(frame -> {
                        Location frameLocation = frame.getLocation();
                        if (frameLocation != null) {
                            NewIssueLocation newFrameLocation = this.createIssueLocation(newExternalIssue, frameLocation);
                            flow.add(newFrameLocation);
                        }
                    });
                    newExternalIssue.addFlow(flow);
                }
            });
        }
    }

    private void createSecondaryLocations(Result result, NewExternalIssue newExternalIssue) {
        Set relatedLocations = Optional.ofNullable(result.getRelatedLocations()).orElse(Set.of());
        if (!relatedLocations.isEmpty()) {
            relatedLocations.forEach(relatedLocation -> {
                NewIssueLocation newRelatedLocation = this.createIssueLocation(newExternalIssue, (Location)relatedLocation);
                newExternalIssue.addLocation(newRelatedLocation);
            });
        }
    }

    private NewIssueLocation createIssueLocation(NewExternalIssue newExternalIssue, Location sarifLocation) {
        NewIssueLocation newRelatedLocation = newExternalIssue.newLocation();
        String locationMessageText = ResultMapper.getTextMessageOrNull(sarifLocation.getMessage());
        if (locationMessageText != null) {
            newRelatedLocation.message(locationMessageText);
        }
        this.fillFileOrProjectLocation(newRelatedLocation, sarifLocation);
        return newRelatedLocation;
    }

    private void createPrimaryLocation(NewExternalIssue newExternalIssue, Result result) {
        NewIssueLocation sonarLocation = newExternalIssue.newLocation();
        List<Location> sarifLocations = Optional.ofNullable(result.getLocations()).orElse(List.of());
        String primaryMessage = ResultMapper.computePrimaryMessage(result, sarifLocations);
        sonarLocation.message(primaryMessage);
        if (sarifLocations.isEmpty()) {
            this.locationMapper.fillIssueInProjectLocation(sonarLocation);
        } else {
            Location firstSarifLocation = sarifLocations.get(0);
            this.fillFileOrProjectLocation(sonarLocation, firstSarifLocation);
        }
        newExternalIssue.at(sonarLocation);
    }

    private static String computePrimaryMessage(Result result, List<Location> locations) {
        Location firstLocation;
        String locationMessageText;
        String resultMessage = Objects.requireNonNull(result.getMessage().getText(), "Message text is required on result");
        if (!locations.isEmpty() && (locationMessageText = ResultMapper.getTextMessageOrNull((firstLocation = locations.get(0)).getMessage())) != null) {
            return resultMessage + " - " + locationMessageText;
        }
        return resultMessage;
    }

    @CheckForNull
    private static String getTextMessageOrNull(@Nullable Message message) {
        if (message == null) {
            return null;
        }
        return message.getText();
    }

    private void fillFileOrProjectLocation(NewIssueLocation newIssueLocation, Location firstLocation) {
        if (!this.locationMapper.fillIssueInFileLocation(newIssueLocation, firstLocation)) {
            this.locationMapper.fillIssueInProjectLocation(newIssueLocation);
        }
    }
}

