/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.externalissue.sarif;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.predicates.AbstractFilePredicate;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.utils.Preconditions;
import org.sonar.sarif.pojo.ArtifactLocation;
import org.sonar.sarif.pojo.Location;
import org.sonar.sarif.pojo.PhysicalLocation;
import org.sonar.scanner.externalissue.sarif.RegionMapper;

@ScannerSide
public class LocationMapper {
    private static final Logger LOG = LoggerFactory.getLogger(LocationMapper.class);
    private static final int CACHE_SIZE = 500;
    private static final int CACHE_EXPIRY = 60;
    private final SensorContext sensorContext;
    private final RegionMapper regionMapper;
    private final AnalysisWarnings analysisWarnings;
    LoadingCache<String, Optional<InputFile>> inputFileCache = CacheBuilder.newBuilder().maximumSize(500L).expireAfterAccess(60L, TimeUnit.SECONDS).concurrencyLevel(Runtime.getRuntime().availableProcessors()).build(this.getCacheLoader());

    LocationMapper(SensorContext sensorContext, RegionMapper regionMapper, AnalysisWarnings analysisWarnings) {
        this.sensorContext = sensorContext;
        this.regionMapper = regionMapper;
        this.analysisWarnings = analysisWarnings;
    }

    void fillIssueInProjectLocation(NewIssueLocation newIssueLocation) {
        newIssueLocation.on(this.sensorContext.project());
    }

    boolean fillIssueInFileLocation(NewIssueLocation newIssueLocation, Location location) {
        PhysicalLocation physicalLocation = location.getPhysicalLocation();
        String fileUri = LocationMapper.getFileUriOrThrow(location);
        Optional<InputFile> file = this.findFile(fileUri);
        if (file.isEmpty()) {
            String unresolvedLocationWarning = String.format("Unable to resolve Issue location from SARIF physical location %s. Falling back to the project location.", fileUri);
            this.analysisWarnings.addUnique(unresolvedLocationWarning);
            LOG.warn(unresolvedLocationWarning);
            return false;
        }
        InputFile inputFile = file.get();
        newIssueLocation.on(inputFile);
        this.regionMapper.mapRegion(physicalLocation.getRegion(), inputFile).ifPresent(newIssueLocation::at);
        return true;
    }

    private static String getFileUriOrThrow(Location location) {
        PhysicalLocation physicalLocation = location.getPhysicalLocation();
        Preconditions.checkArgument(LocationMapper.hasUriFieldPopulated(physicalLocation), "The field location.physicalLocation.artifactLocation.uri is not set.");
        return physicalLocation.getArtifactLocation().getUri();
    }

    private static boolean hasUriFieldPopulated(@Nullable PhysicalLocation location) {
        return Optional.ofNullable(location).map(PhysicalLocation::getArtifactLocation).map(ArtifactLocation::getUri).isPresent();
    }

    private Optional<InputFile> findFile(String filePath) {
        return this.inputFileCache.getUnchecked(filePath);
    }

    private CacheLoader<String, Optional<InputFile>> getCacheLoader() {
        return new CacheLoader<String, Optional<InputFile>>(){

            @Override
            @NotNull
            public Optional<InputFile> load(String filePath) {
                return LocationMapper.this.computeInputFile(filePath);
            }
        };
    }

    private Optional<InputFile> computeInputFile(String key) {
        return Optional.ofNullable(this.sensorContext.fileSystem().inputFile(new IsPredicate(LocationMapper.getFileFromAbsoluteUriOrPath(key).toPath())));
    }

    private static File getFileFromAbsoluteUriOrPath(String filePath) {
        URI uri = URI.create(filePath);
        if (uri.isAbsolute()) {
            return LocationMapper.getFileFromAbsoluteUri(filePath, uri);
        }
        return new File(filePath);
    }

    @NotNull
    private static File getFileFromAbsoluteUri(String filePath, URI uri) {
        String path = uri.getPath();
        if (StringUtils.isNotBlank(path)) {
            return new File(path);
        }
        throw new IllegalArgumentException("Invalid file scheme URI: " + filePath);
    }

    @VisibleForTesting
    static class IsPredicate
    extends AbstractFilePredicate {
        private final Path path;

        public IsPredicate(Path path) {
            this.path = path;
        }

        @Override
        public boolean apply(InputFile inputFile) {
            try {
                return Files.isSameFile(this.path, inputFile.path());
            }
            catch (IOException e) {
                return false;
            }
        }
    }
}

