/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.externalissue.sarif;

import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.rule.NewAdHocRule;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.sarif.pojo.Run;
import org.sonar.sarif.pojo.SarifSchema210;
import org.sonar.scanner.externalissue.sarif.RunMapper;
import org.sonar.scanner.externalissue.sarif.Sarif210Importer;
import org.sonar.scanner.externalissue.sarif.SarifImportResults;

@ScannerSide
public class DefaultSarif210Importer
implements Sarif210Importer {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSarif210Importer.class);
    private final RunMapper runMapper;

    DefaultSarif210Importer(RunMapper runMapper) {
        this.runMapper = runMapper;
    }

    @Override
    public SarifImportResults importSarif(SarifSchema210 sarif210) {
        int successFullyImportedIssues = 0;
        int successFullyImportedRuns = 0;
        int failedRuns = 0;
        List<Run> runs = Objects.requireNonNull(sarif210.getRuns(), "The runs section of the Sarif report is null");
        for (Run run : runs) {
            RunMapper.RunMapperResult runMapperResult = this.tryMapRun(run);
            if (runMapperResult.isSuccess()) {
                List<NewAdHocRule> newAdHocRules = runMapperResult.getNewAdHocRules();
                newAdHocRules.forEach(NewAdHocRule::save);
                List<NewExternalIssue> newExternalIssues = runMapperResult.getNewExternalIssues();
                ++successFullyImportedRuns;
                successFullyImportedIssues += newExternalIssues.size();
                newExternalIssues.forEach(NewExternalIssue::save);
                continue;
            }
            ++failedRuns;
        }
        return SarifImportResults.builder().successFullyImportedIssues(successFullyImportedIssues).successFullyImportedRuns(successFullyImportedRuns).failedRuns(failedRuns).build();
    }

    private RunMapper.RunMapperResult tryMapRun(Run run) {
        try {
            return this.runMapper.mapRun(run);
        }
        catch (Exception exception) {
            LOG.warn("Failed to import a sarif run, error: {}", (Object)exception.getMessage());
            return new RunMapper.RunMapperResult().success(false);
        }
    }
}

