/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.externalissue;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.rules.RuleType;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.core.documentation.DocumentationLinkGenerator;
import org.sonar.scanner.externalissue.ExternalIssueReport;

@ScannerSide
public class ExternalIssueReportValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalIssueReportValidator.class);
    private static final String ISSUE_RULE_ID = "ruleId";
    private static final String SEVERITY = "severity";
    private static final String TYPE = "type";
    private static final String DOCUMENTATION_SUFFIX = "/analyzing-source-code/importing-external-issues/generic-issue-import-format/";
    private final DocumentationLinkGenerator documentationLinkGenerator;

    ExternalIssueReportValidator(DocumentationLinkGenerator documentationLinkGenerator) {
        this.documentationLinkGenerator = documentationLinkGenerator;
    }

    public void validate(ExternalIssueReport report, Path reportPath) {
        if (report.rules != null && report.issues != null) {
            Set<String> ruleIds = ExternalIssueReportValidator.validateRules(report.rules, reportPath);
            ExternalIssueReportValidator.validateIssuesNewFormat(report.issues, ruleIds, reportPath);
        } else if (report.rules == null && report.issues != null) {
            String documentationLink = this.documentationLinkGenerator.getDocumentationLink(DOCUMENTATION_SUFFIX);
            LOGGER.warn("External issues were imported with a deprecated format which will be removed soon. The \"rules\" field is missing. Please switch to the newest format. Look at the documentation for more information, including what default values have been set: {}", (Object)documentationLink);
            ExternalIssueReportValidator.validateIssuesDeprecatedFormat(report.issues, reportPath);
        } else {
            throw new IllegalStateException(String.format("Failed to parse report '%s': invalid report detected.", reportPath));
        }
    }

    private static void validateIssuesNewFormat(ExternalIssueReport.Issue[] issues, Set<String> ruleIds, Path reportPath) {
        for (ExternalIssueReport.Issue issue : issues) {
            ExternalIssueReportValidator.mandatoryField(issue.ruleId, ISSUE_RULE_ID, reportPath);
            ExternalIssueReportValidator.checkRuleExistsInReport(ruleIds, issue, reportPath);
            ExternalIssueReportValidator.checkNoField(issue.severity, SEVERITY, reportPath);
            ExternalIssueReportValidator.checkNoField(issue.type, TYPE, reportPath);
            ExternalIssueReportValidator.validateAlwaysRequiredIssueFields(issue, reportPath);
        }
    }

    private static void validateIssuesDeprecatedFormat(ExternalIssueReport.Issue[] issues, Path reportPath) {
        for (ExternalIssueReport.Issue issue : issues) {
            ExternalIssueReportValidator.mandatoryField(issue.ruleId, ISSUE_RULE_ID, reportPath);
            ExternalIssueReportValidator.mandatoryField(issue.severity, SEVERITY, reportPath);
            ExternalIssueReportValidator.mandatoryField(issue.type, TYPE, reportPath);
            ExternalIssueReportValidator.mandatoryField(issue.engineId, "engineId", reportPath);
            ExternalIssueReportValidator.validateAlwaysRequiredIssueFields(issue, reportPath);
        }
    }

    private static Set<String> validateRules(ExternalIssueReport.Rule[] rules, Path reportPath) {
        HashSet<String> ruleIds = new HashSet<String>();
        for (ExternalIssueReport.Rule rule : rules) {
            ExternalIssueReportValidator.mandatoryField(rule.id, "id", reportPath);
            ExternalIssueReportValidator.mandatoryField(rule.name, "name", reportPath);
            ExternalIssueReportValidator.mandatoryField(rule.engineId, "engineId", reportPath);
            ExternalIssueReportValidator.validateTypeOrImpacts(reportPath, rule);
            if (rule.impacts != null) {
                ExternalIssueReportValidator.checkImpactsArray(rule.impacts, reportPath);
                ExternalIssueReportValidator.validateImpactsOnSecurityHostpots(rule.impacts, rule.type, reportPath);
            }
            if (rule.type != null) {
                ExternalIssueReportValidator.mandatoryField(rule.severity, SEVERITY, reportPath);
            }
            if (rule.severity != null) {
                ExternalIssueReportValidator.mandatoryField(rule.type, TYPE, reportPath);
            }
            if (ruleIds.add(rule.id)) continue;
            throw new IllegalStateException(String.format("Failed to parse report '%s': found duplicate rule ID '%s'.", reportPath, rule.id));
        }
        return ruleIds;
    }

    private static void validateImpactsOnSecurityHostpots(ExternalIssueReport.Impact[] impacts, String type, Path reportPath) {
        if (impacts.length > 0 && RuleType.SECURITY_HOTSPOT.name().equals(type)) {
            throw new IllegalStateException(String.format("Failed to parse report '%s': impacts should not be provided for rule type 'SECURITY_HOTSPOT'.", reportPath));
        }
    }

    private static void validateTypeOrImpacts(Path reportPath, ExternalIssueReport.Rule rule) {
        if (rule.type == null && rule.impacts == null) {
            throw new IllegalStateException(String.format("Failed to parse report '%s': either type, impacts or both should be provided.", reportPath));
        }
    }

    private static void checkNoField(@Nullable Object value, String fieldName, Path reportPath) {
        if (value != null) {
            throw new IllegalStateException(String.format("Deprecated '%s' field found in the following report: '%s'.", fieldName, reportPath));
        }
    }

    private static void validateAlwaysRequiredIssueFields(ExternalIssueReport.Issue issue, Path reportPath) {
        ExternalIssueReportValidator.mandatoryField(issue.primaryLocation, "primaryLocation", reportPath);
        ExternalIssueReportValidator.mandatoryFieldPrimaryLocation(issue.primaryLocation.filePath, "filePath", reportPath);
        ExternalIssueReportValidator.mandatoryFieldPrimaryLocation(issue.primaryLocation.message, "message", reportPath);
        if (issue.primaryLocation.textRange != null) {
            ExternalIssueReportValidator.mandatoryFieldPrimaryLocation(issue.primaryLocation.textRange.startLine, "startLine of the text range", reportPath);
        }
        if (issue.secondaryLocations != null) {
            for (ExternalIssueReport.Location l : issue.secondaryLocations) {
                ExternalIssueReportValidator.mandatoryFieldSecondaryLocation(l.filePath, "filePath", reportPath);
                ExternalIssueReportValidator.mandatoryFieldSecondaryLocation(l.textRange, "textRange", reportPath);
                ExternalIssueReportValidator.mandatoryFieldSecondaryLocation(l.textRange.startLine, "startLine of the text range", reportPath);
            }
        }
    }

    private static void mandatoryFieldPrimaryLocation(@Nullable Object value, String fieldName, Path reportPath) {
        if (value == null) {
            throw new IllegalStateException(String.format("Failed to parse report '%s': missing mandatory field '%s' in the primary location of the issue.", reportPath, fieldName));
        }
    }

    private static void mandatoryFieldSecondaryLocation(@Nullable Object value, String fieldName, Path reportPath) {
        if (value == null) {
            throw new IllegalStateException(String.format("Failed to parse report '%s': missing mandatory field '%s' in a secondary location of the issue.", reportPath, fieldName));
        }
    }

    private static void mandatoryField(@Nullable Object value, String fieldName, Path reportPath) {
        String string;
        if (value == null || value instanceof String && (string = (String)value).isEmpty()) {
            throw new IllegalStateException(String.format("Failed to parse report '%s': missing mandatory field '%s'.", reportPath, fieldName));
        }
    }

    private static void checkImpactsArray(@Nullable Object[] value, Path reportPath) {
        ExternalIssueReportValidator.mandatoryField(value, "impacts", reportPath);
        if (value.length == 0) {
            throw new IllegalStateException(String.format("Failed to parse report '%s': mandatory array '%s' not populated.", reportPath, "impacts"));
        }
    }

    private static void checkRuleExistsInReport(Set<String> ruleIds, ExternalIssueReport.Issue issue, Path reportPath) {
        if (!ruleIds.contains(issue.ruleId)) {
            throw new IllegalStateException(String.format("Failed to parse report '%s': rule with '%s' not present.", reportPath, issue.ruleId));
        }
    }
}

