/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.externalissue;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.scanner.externalissue.ExternalIssueReport;
import org.sonar.scanner.externalissue.ExternalIssueReportValidator;

@ScannerSide
public class ExternalIssueReportParser {
    private final Gson gson = new Gson();
    private final ExternalIssueReportValidator externalIssueReportValidator;

    public ExternalIssueReportParser(ExternalIssueReportValidator externalIssueReportValidator) {
        this.externalIssueReportValidator = externalIssueReportValidator;
    }

    public ExternalIssueReport parse(Path reportPath) {
        ExternalIssueReport externalIssueReport;
        block9: {
            BufferedReader reader = Files.newBufferedReader(reportPath, StandardCharsets.UTF_8);
            try {
                ExternalIssueReport report = this.gson.fromJson((Reader)reader, ExternalIssueReport.class);
                this.externalIssueReportValidator.validate(report, reportPath);
                externalIssueReport = report;
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonIOException | IOException e) {
                    throw new IllegalStateException("Failed to read external issues report '" + String.valueOf(reportPath) + "'", e);
                }
                catch (JsonSyntaxException e) {
                    throw new IllegalStateException("Failed to read external issues report '" + String.valueOf(reportPath) + "': invalid JSON syntax", e);
                }
            }
            ((Reader)reader).close();
        }
        return externalIssueReport;
    }
}

