/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.externalissue;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.batch.sensor.rule.NewAdHocRule;
import org.sonar.api.issue.impact.SoftwareQuality;
import org.sonar.api.rules.CleanCodeAttribute;
import org.sonar.api.rules.RuleType;
import org.sonar.scanner.externalissue.ExternalIssueReport;

public class ExternalIssueImporter {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalIssueImporter.class);
    private static final int MAX_UNKNOWN_FILE_PATHS_TO_PRINT = 5;
    private final SensorContext context;
    private final ExternalIssueReport report;
    private final Set<String> unknownFiles = new LinkedHashSet<String>();
    private final Set<String> knownFiles = new LinkedHashSet<String>();

    public ExternalIssueImporter(SensorContext context, ExternalIssueReport report) {
        this.context = context;
        this.report = report;
    }

    public void execute() {
        if (this.report.rules != null) {
            this.importNewFormat();
        } else {
            this.importDeprecatedFormat();
        }
    }

    private void importDeprecatedFormat() {
        int issueCount = 0;
        for (ExternalIssueReport.Issue issue : this.report.issues) {
            if (!this.importDeprecatedIssue(issue)) continue;
            ++issueCount;
        }
        this.logStatistics(issueCount, "");
    }

    private void importNewFormat() {
        HashMap<String, ExternalIssueReport.Rule> rulesMap = new HashMap<String, ExternalIssueReport.Rule>();
        for (ExternalIssueReport.Rule rule : this.report.rules) {
            rulesMap.put(rule.id, rule);
            NewAdHocRule adHocRule = this.createAdHocRule(rule);
            adHocRule.save();
        }
        int issueCount = 0;
        for (ExternalIssueReport.Issue issue : this.report.issues) {
            if (!this.importIssue(issue, (ExternalIssueReport.Rule)rulesMap.get(issue.ruleId))) continue;
            ++issueCount;
        }
        this.logStatistics(issueCount, "");
    }

    private NewAdHocRule createAdHocRule(ExternalIssueReport.Rule rule) {
        NewAdHocRule adHocRule = this.context.newAdHocRule();
        adHocRule.ruleId(rule.id);
        adHocRule.name(rule.name);
        adHocRule.description(rule.description);
        adHocRule.engineId(rule.engineId);
        Optional.ofNullable(rule.cleanCodeAttribute).ifPresent(cca -> adHocRule.cleanCodeAttribute(CleanCodeAttribute.valueOf(cca)));
        Optional.ofNullable(rule.severity).ifPresent(s -> adHocRule.severity(Severity.valueOf(s)));
        Optional.ofNullable(rule.type).ifPresent(t -> adHocRule.type(RuleType.valueOf(t)));
        if (rule.impacts != null) {
            for (ExternalIssueReport.Impact impact : rule.impacts) {
                adHocRule.addDefaultImpact(SoftwareQuality.valueOf(impact.softwareQuality), org.sonar.api.issue.impact.Severity.valueOf(impact.severity));
            }
        }
        return adHocRule;
    }

    private boolean populateCommonValues(ExternalIssueReport.Issue issue, NewExternalIssue externalIssue) {
        NewIssueLocation primary;
        if (issue.effortMinutes != null) {
            externalIssue.remediationEffortMinutes((long)issue.effortMinutes);
        }
        if ((primary = ExternalIssueImporter.fillLocation(this.context, externalIssue.newLocation(), issue.primaryLocation)) != null) {
            this.knownFiles.add(issue.primaryLocation.filePath);
            externalIssue.at(primary);
            if (issue.secondaryLocations != null) {
                for (ExternalIssueReport.Location l : issue.secondaryLocations) {
                    NewIssueLocation secondary = ExternalIssueImporter.fillLocation(this.context, externalIssue.newLocation(), l);
                    if (secondary == null) continue;
                    externalIssue.addLocation(secondary);
                }
            }
            externalIssue.save();
            return true;
        }
        this.unknownFiles.add(issue.primaryLocation.filePath);
        return false;
    }

    private boolean importDeprecatedIssue(ExternalIssueReport.Issue issue) {
        NewExternalIssue externalIssue = this.context.newExternalIssue().engineId(issue.engineId).ruleId(issue.ruleId).severity(Severity.valueOf(issue.severity)).type(RuleType.valueOf(issue.type));
        return this.populateCommonValues(issue, externalIssue);
    }

    private boolean importIssue(ExternalIssueReport.Issue issue, ExternalIssueReport.Rule rule) {
        NewExternalIssue externalIssue = this.context.newExternalIssue().engineId(rule.engineId).ruleId(rule.id);
        Optional.ofNullable(rule.severity).ifPresent(s -> externalIssue.severity(Severity.valueOf(s)));
        Optional.ofNullable(rule.type).ifPresent(t -> externalIssue.type(RuleType.valueOf(t)));
        return this.populateCommonValues(issue, externalIssue);
    }

    private void logStatistics(int issueCount, String additionalInformation) {
        String pluralizedIssues = ExternalIssueImporter.pluralize("issue", issueCount);
        String pluralizedFiles = ExternalIssueImporter.pluralize("file", this.knownFiles.size());
        LOG.info("Imported {} {} in {} {}{}", issueCount, pluralizedIssues, this.knownFiles.size(), pluralizedFiles, additionalInformation);
        int numberOfUnknownFiles = this.unknownFiles.size();
        if (numberOfUnknownFiles > 0) {
            String limitedUnknownFiles = this.unknownFiles.stream().limit(5L).collect(Collectors.joining(", "));
            LOG.info("External issues{} ignored for {} unknown files, including: {}", additionalInformation, numberOfUnknownFiles, limitedUnknownFiles);
        }
    }

    private static String pluralize(String msg, int count) {
        if (count == 1) {
            return msg;
        }
        return msg + "s";
    }

    @CheckForNull
    private static NewIssueLocation fillLocation(SensorContext context, NewIssueLocation newLocation, ExternalIssueReport.Location location) {
        InputFile file = ExternalIssueImporter.findFile(context, location.filePath);
        if (file == null) {
            return null;
        }
        newLocation.on(file);
        if (location.message != null) {
            newLocation.message(location.message);
        }
        if (location.textRange != null) {
            if (location.textRange.startColumn != null) {
                TextPointer start = file.newPointer(location.textRange.startLine, location.textRange.startColumn);
                ExternalIssueImporter.checkStartColumnOnEmptyLine(file, start);
                int endLine = location.textRange.endLine != null ? location.textRange.endLine : location.textRange.startLine;
                int endColumn = Objects.requireNonNullElseGet(location.textRange.endColumn, () -> file.selectLine(endLine).end().lineOffset());
                TextPointer end = file.newPointer(endLine, endColumn);
                newLocation.at(file.newRange(start, end));
            } else {
                newLocation.at(file.selectLine(location.textRange.startLine));
            }
        }
        return newLocation;
    }

    private static void checkStartColumnOnEmptyLine(InputFile file, TextPointer startPointer) {
        if (file.selectLine(startPointer.line()).end().lineOffset() == 0) {
            throw new IllegalArgumentException(String.format("A 'startColumn' %s cannot be provided when the line is empty", startPointer));
        }
    }

    @CheckForNull
    private static InputFile findFile(SensorContext context, String filePath) {
        return context.fileSystem().inputFile(context.fileSystem().predicates().hasPath(filePath));
    }
}

