/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.ci.vendors;

import java.nio.file.Path;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.internal.DefaultInputProject;
import org.sonar.api.utils.System2;
import org.sonar.scanner.ci.CiConfiguration;
import org.sonar.scanner.ci.CiConfigurationImpl;
import org.sonar.scanner.ci.CiVendor;

public class Jenkins
implements CiVendor {
    private static final Logger LOG = LoggerFactory.getLogger(Jenkins.class);
    private final System2 system;
    private final DefaultInputProject inputProject;

    public Jenkins(System2 system, DefaultInputProject inputProject) {
        this.system = system;
        this.inputProject = inputProject;
    }

    @Override
    public String getName() {
        return "Jenkins";
    }

    @Override
    public boolean isDetected() {
        return StringUtils.isNotBlank(this.system.envVariable("JENKINS_URL")) && StringUtils.isNotBlank(this.system.envVariable("EXECUTOR_NUMBER"));
    }

    @Override
    public CiConfiguration loadConfiguration() {
        String revision = this.system.envVariable("ghprbActualCommit");
        if (StringUtils.isNotBlank(revision)) {
            return new CiConfigurationImpl(revision, this.getName());
        }
        revision = this.system.envVariable("GIT_COMMIT");
        if (StringUtils.isNotBlank(revision)) {
            String jenkinsGitPrSha1;
            if (StringUtils.isNotBlank(this.system.envVariable("CHANGE_ID")) && StringUtils.isNotBlank(jenkinsGitPrSha1 = this.getJenkinsGitPrSha1())) {
                return new CiConfigurationImpl(jenkinsGitPrSha1, this.getName());
            }
            return new CiConfigurationImpl(revision, this.getName());
        }
        revision = this.system.envVariable("SVN_COMMIT");
        return new CiConfigurationImpl(revision, this.getName());
    }

    private String getJenkinsGitPrSha1() {
        String gitBranch = this.system.envVariable("GIT_BRANCH");
        if (StringUtils.isBlank(gitBranch)) {
            return null;
        }
        Path baseDir = this.inputProject.getBaseDir();
        RepositoryBuilder builder = (RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().findGitDir(baseDir.toFile())).setMustExist(true);
        if (builder.getGitDir() == null) {
            return null;
        }
        String refName = "refs/remotes/origin/" + gitBranch;
        Object repo = builder.build();
        try {
            String string = Optional.ofNullable(((Repository)repo).exactRef(refName)).map(Ref::getObjectId).map(AnyObjectId::getName).orElse(null);
            if (repo != null) {
                ((Repository)repo).close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (repo != null) {
                    try {
                        ((Repository)repo).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                LOG.debug("Couldn't find git sha1 in '{}': {}", (Object)refName, (Object)e.getMessage());
                return null;
            }
        }
    }
}

