/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.ci.vendors;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.utils.System2;
import org.sonar.scanner.ci.CiConfiguration;
import org.sonar.scanner.ci.CiConfigurationImpl;
import org.sonar.scanner.ci.CiVendor;
import org.sonar.scanner.ci.DevOpsPlatformInfo;

public class GithubActions
implements CiVendor {
    private static final Logger LOG = LoggerFactory.getLogger(GithubActions.class);
    public static final String GITHUB_SHA = "GITHUB_SHA";
    public static final String GITHUB_REPOSITORY_ENV_VAR = "GITHUB_REPOSITORY";
    public static final String GITHUB_API_URL_ENV_VAR = "GITHUB_API_URL";
    public static final String GITHUB_EVENT_PATH = "GITHUB_EVENT_PATH";
    public static final String GITHUB_EVENT_NAME = "GITHUB_EVENT_NAME";
    public static final String GITHUB_ACTION = "GITHUB_ACTION";
    public static final String NAME = "Github Actions";
    private final System2 system;

    public GithubActions(System2 system) {
        this.system = system;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isDetected() {
        return StringUtils.isNotBlank(this.system.envVariable(GITHUB_ACTION));
    }

    @Override
    public CiConfiguration loadConfiguration() {
        String revision = this.getScmRevision().orElse(null);
        return this.getDevOpsPlatformInfo().map(devOpsPlatformInfo -> new CiConfigurationImpl(revision, this.getName(), (DevOpsPlatformInfo)devOpsPlatformInfo)).orElseGet(() -> new CiConfigurationImpl(revision, this.getName()));
    }

    private Optional<DevOpsPlatformInfo> getDevOpsPlatformInfo() {
        String githubRepository = this.system.envVariable(GITHUB_REPOSITORY_ENV_VAR);
        String githubApiUrl = this.system.envVariable(GITHUB_API_URL_ENV_VAR);
        if (StringUtils.isEmpty(githubRepository) || StringUtils.isEmpty(githubApiUrl)) {
            LOG.warn("Missing or empty environment variables: {}, and/or {}", (Object)GITHUB_API_URL_ENV_VAR, (Object)GITHUB_REPOSITORY_ENV_VAR);
            return Optional.empty();
        }
        return Optional.of(new DevOpsPlatformInfo(githubApiUrl, githubRepository));
    }

    private Optional<String> getScmRevision() {
        Optional<String> revisionOpt = this.getScmRevisionIfPullRequest();
        if (revisionOpt.isPresent()) {
            return revisionOpt;
        }
        return this.getScmRevisionFromEnvVar();
    }

    private Optional<String> getScmRevisionIfPullRequest() {
        boolean detected;
        String path = this.system.envVariable(GITHUB_EVENT_PATH);
        String eventName = this.system.envVariable(GITHUB_EVENT_NAME);
        boolean bl = detected = StringUtils.isNotBlank(eventName) && StringUtils.isNotBlank(path);
        if (!detected) {
            return Optional.empty();
        }
        if ("pull_request".equals(eventName)) {
            String json = GithubActions.readFile(path);
            PrEvent prEvent = new Gson().fromJson(json, PrEvent.class);
            return Optional.of(prEvent.pullRequest.head.sha);
        }
        return Optional.empty();
    }

    private Optional<String> getScmRevisionFromEnvVar() {
        String revision = this.system.envVariable(GITHUB_SHA);
        if (StringUtils.isEmpty(revision)) {
            LOG.warn("Missing environment variable GITHUB_SHA");
            return Optional.empty();
        }
        return Optional.of(revision);
    }

    private static String readFile(String path) {
        File file = new File(path);
        if (!file.exists() || !file.isFile()) {
            throw new IllegalStateException("Event file does not exist: " + String.valueOf(file));
        }
        try {
            return FileUtils.readFileToString(file, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to read event file: " + String.valueOf(file), e);
        }
    }

    private static class PrEvent {
        @SerializedName(value="ref")
        private String ref;
        @SerializedName(value="pull_request")
        private Pr pullRequest;

        private PrEvent() {
        }
    }

    private static class Pr {
        @SerializedName(value="number")
        private int number;
        @SerializedName(value="base")
        private PrCommit base;
        @SerializedName(value="head")
        private PrCommit head;

        private Pr() {
        }
    }

    private static class PrCommit {
        @SerializedName(value="ref")
        private String ref;
        @SerializedName(value="sha")
        private String sha;
        @SerializedName(value="repo")
        private Repository repository;

        private PrCommit() {
        }
    }

    private static class Owner {
        @SerializedName(value="name")
        private String name;
        @SerializedName(value="url")
        private String url;

        private Owner() {
        }
    }

    private static class Repository {
        @SerializedName(value="full_name")
        private String fullName;
        @SerializedName(value="owner")
        private Owner owner;

        private Repository() {
        }
    }
}

