/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.ci.vendors;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import org.sonar.api.utils.System2;
import org.sonar.scanner.ci.CiConfiguration;
import org.sonar.scanner.ci.CiConfigurationImpl;
import org.sonar.scanner.ci.CiVendor;

public class CirrusCi
implements CiVendor {
    private static final String PROPERTY_COMMIT = "CIRRUS_CHANGE_IN_REPO";
    private final System2 system;

    public CirrusCi(System2 system) {
        this.system = system;
    }

    @Override
    public String getName() {
        return "CirrusCI";
    }

    @Override
    public boolean isDetected() {
        return "true".equals(this.system.envVariable("CIRRUS_CI"));
    }

    @Override
    public CiConfiguration loadConfiguration() {
        String revision = this.system.envVariable(PROPERTY_COMMIT);
        if (StringUtils.isEmpty(revision)) {
            LoggerFactory.getLogger(this.getClass()).warn("Missing environment variable CIRRUS_CHANGE_IN_REPO");
        }
        return new CiConfigurationImpl(revision, this.getName());
    }
}

