/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.ci;

import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.sonar.scanner.ci.CiConfiguration;
import org.sonar.scanner.ci.DevOpsPlatformInfo;

public class CiConfigurationImpl
implements CiConfiguration {
    private final String ciName;
    private final Optional<String> scmRevision;
    private final Optional<DevOpsPlatformInfo> devOpsPlatformInfo;

    public CiConfigurationImpl(@Nullable String scmRevision, String ciName) {
        this.scmRevision = Optional.ofNullable(StringUtils.defaultIfBlank(scmRevision, null));
        this.ciName = ciName;
        this.devOpsPlatformInfo = Optional.empty();
    }

    public CiConfigurationImpl(@Nullable String scmRevision, String ciName, DevOpsPlatformInfo devOpsPlatformInfo) {
        this.scmRevision = Optional.ofNullable(StringUtils.defaultIfBlank(scmRevision, null));
        this.ciName = ciName;
        this.devOpsPlatformInfo = Optional.of(devOpsPlatformInfo);
    }

    @Override
    public Optional<String> getScmRevision() {
        return this.scmRevision;
    }

    @Override
    public String getCiName() {
        return this.ciName;
    }

    @Override
    public Optional<DevOpsPlatformInfo> getDevOpsPlatformInfo() {
        return this.devOpsPlatformInfo;
    }
}

