/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.cache;

import com.google.protobuf.ByteString;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import org.sonar.api.batch.sensor.cache.ReadCache;
import org.sonar.api.utils.Preconditions;
import org.sonar.scanner.cache.ScannerWriteCache;
import org.sonar.scanner.protocol.internal.ScannerInternal;
import org.sonar.scanner.protocol.output.FileStructure;

public class WriteCacheImpl
implements ScannerWriteCache {
    private final ReadCache readCache;
    private final Set<String> keys = new HashSet<String>();
    private final FileStructure fileStructure;
    private OutputStream stream = null;

    public WriteCacheImpl(ReadCache readCache, FileStructure fileStructure) {
        this.readCache = readCache;
        this.fileStructure = fileStructure;
    }

    @Override
    public void write(String key, InputStream data) {
        Preconditions.checkNotNull(data);
        try {
            this.write(key, data.readAllBytes());
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read sensor write cache data", e);
        }
    }

    @Override
    public void write(String key, byte[] data) {
        Preconditions.checkNotNull(data);
        this.checkKey(key);
        try {
            OutputStream out = this.getStream();
            WriteCacheImpl.toProto(key, data).writeDelimitedTo(out);
            this.keys.add(key);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to write to sensor cache file", e);
        }
    }

    private OutputStream getStream() throws IOException {
        if (this.stream == null) {
            this.stream = new GZIPOutputStream(new FileOutputStream(this.fileStructure.analysisCache()));
        }
        return this.stream;
    }

    @Override
    public void copyFromPrevious(String key) {
        Preconditions.checkArgument(this.readCache.contains(key), "Previous cache doesn't contain key '%s'", key);
        this.write(key, this.readCache.read(key));
    }

    private static ScannerInternal.SensorCacheEntry toProto(String key, byte[] data) {
        return ScannerInternal.SensorCacheEntry.newBuilder().setKey(key).setData(ByteString.copyFrom(data)).build();
    }

    @Override
    public void close() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to close sensor cache file", e);
            }
        }
    }

    private void checkKey(String key) {
        Preconditions.checkNotNull(key);
        Preconditions.checkArgument(!this.keys.contains(key), "Cache already contains key '%s'", key);
    }
}

