/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.cache;

import java.io.InputStream;
import org.jetbrains.annotations.Nullable;
import org.sonar.api.batch.sensor.cache.ReadCache;
import org.sonar.scanner.cache.AnalysisCacheEnabled;
import org.sonar.scanner.cache.AnalysisCacheMemoryStorage;
import org.sonar.scanner.cache.ReadCacheImpl;
import org.sonar.scanner.cache.ScannerWriteCache;
import org.sonar.scanner.cache.WriteCacheImpl;
import org.sonar.scanner.protocol.output.FileStructure;
import org.sonar.scanner.scan.branch.BranchConfiguration;
import org.springframework.context.annotation.Bean;

public class AnalysisCacheProvider {
    @Bean(value={"ReadCache"})
    public ReadCache provideReader(AnalysisCacheEnabled analysisCacheEnabled, AnalysisCacheMemoryStorage storage) {
        if (analysisCacheEnabled.isEnabled()) {
            storage.load();
            return new ReadCacheImpl(storage);
        }
        return new NoOpReadCache();
    }

    @Bean(value={"WriteCache"})
    public ScannerWriteCache provideWriter(AnalysisCacheEnabled analysisCacheEnabled, ReadCache readCache, BranchConfiguration branchConfiguration, FileStructure fileStructure) {
        if (analysisCacheEnabled.isEnabled() && !branchConfiguration.isPullRequest()) {
            return new WriteCacheImpl(readCache, fileStructure);
        }
        return new NoOpWriteCache();
    }

    static class NoOpReadCache
    implements ReadCache {
        NoOpReadCache() {
        }

        @Override
        @Nullable
        public InputStream read(String s) {
            return null;
        }

        @Override
        public boolean contains(String s) {
            return false;
        }
    }

    static class NoOpWriteCache
    implements ScannerWriteCache {
        NoOpWriteCache() {
        }

        @Override
        public void write(String s, InputStream inputStream2) {
        }

        @Override
        public void write(String s, byte[] bytes) {
        }

        @Override
        public void copyFromPrevious(String s) {
        }

        @Override
        public void close() {
        }
    }
}

