/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import jakarta.annotation.Priority;
import java.time.Clock;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.Plugin;
import org.sonar.api.SonarEdition;
import org.sonar.api.SonarQubeSide;
import org.sonar.api.internal.MetadataLoader;
import org.sonar.api.internal.SonarRuntimeImpl;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.UriReader;
import org.sonar.api.utils.Version;
import org.sonar.core.documentation.DefaultDocumentationLinkGenerator;
import org.sonar.core.extension.CoreExtensionRepositoryImpl;
import org.sonar.core.extension.CoreExtensionsLoader;
import org.sonar.core.platform.PluginClassLoader;
import org.sonar.core.platform.PluginClassloaderFactory;
import org.sonar.core.platform.PluginInfo;
import org.sonar.core.platform.PluginRepository;
import org.sonar.core.platform.SonarQubeVersion;
import org.sonar.core.platform.SpringComponentContainer;
import org.sonar.core.util.DefaultHttpDownloader;
import org.sonar.core.util.UuidFactoryImpl;
import org.sonar.scanner.bootstrap.ExtensionInstaller;
import org.sonar.scanner.bootstrap.GlobalAnalysisMode;
import org.sonar.scanner.bootstrap.GlobalConfigurationProvider;
import org.sonar.scanner.bootstrap.GlobalServerSettingsProvider;
import org.sonar.scanner.bootstrap.GlobalTempFolderProvider;
import org.sonar.scanner.bootstrap.JREDeprecationChecker;
import org.sonar.scanner.bootstrap.PluginFiles;
import org.sonar.scanner.bootstrap.ScannerPluginInstaller;
import org.sonar.scanner.bootstrap.ScannerPluginJarExploder;
import org.sonar.scanner.bootstrap.ScannerPluginRepository;
import org.sonar.scanner.bootstrap.ScannerProperties;
import org.sonar.scanner.bootstrap.SonarUserHomeProvider;
import org.sonar.scanner.bootstrap.SpringScannerContainer;
import org.sonar.scanner.extension.ScannerCoreExtensionsInstaller;
import org.sonar.scanner.http.ScannerWsClientProvider;
import org.sonar.scanner.notifications.DefaultAnalysisWarnings;
import org.sonar.scanner.platform.DefaultServer;
import org.sonar.scanner.repository.DefaultMetricsRepositoryLoader;
import org.sonar.scanner.repository.DefaultNewCodePeriodLoader;
import org.sonar.scanner.repository.MetricsRepositoryProvider;
import org.sonar.scanner.repository.settings.DefaultGlobalSettingsLoader;

@Priority(value=4)
public class SpringGlobalContainer
extends SpringComponentContainer {
    private static final Logger LOG = LoggerFactory.getLogger(SpringGlobalContainer.class);
    private final Map<String, String> scannerProperties;

    private SpringGlobalContainer(Map<String, String> scannerProperties, List<?> addedExternally) {
        super(addedExternally);
        this.scannerProperties = scannerProperties;
    }

    public static SpringGlobalContainer create(Map<String, String> scannerProperties, List<?> extensions) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("JVM max available memory: {}", (Object)FileUtils.byteCountToDisplaySize(Runtime.getRuntime().maxMemory()));
        }
        return new SpringGlobalContainer(scannerProperties, extensions);
    }

    @Override
    public void doBeforeStart() {
        ScannerProperties rawScannerProperties = new ScannerProperties(this.scannerProperties);
        GlobalAnalysisMode globalMode = new GlobalAnalysisMode(rawScannerProperties);
        this.add(rawScannerProperties);
        this.add(globalMode);
        this.addBootstrapComponents();
    }

    private void addBootstrapComponents() {
        Version apiVersion = MetadataLoader.loadApiVersion(System2.INSTANCE);
        Version sqVersion = MetadataLoader.loadSQVersion(System2.INSTANCE);
        SonarEdition edition = MetadataLoader.loadEdition(System2.INSTANCE);
        DefaultAnalysisWarnings analysisWarnings = new DefaultAnalysisWarnings(System2.INSTANCE);
        LOG.debug("{} {}", (Object)edition.getLabel(), (Object)sqVersion);
        this.add(JREDeprecationChecker.class, ScannerPluginRepository.class, PluginClassLoader.class, PluginClassloaderFactory.class, ScannerPluginJarExploder.class, ExtensionInstaller.class, new SonarQubeVersion(sqVersion), new GlobalServerSettingsProvider(), new GlobalConfigurationProvider(), new ScannerWsClientProvider(), DefaultServer.class, DefaultDocumentationLinkGenerator.class, new GlobalTempFolderProvider(), new SonarUserHomeProvider(), analysisWarnings, UriReader.class, PluginFiles.class, System2.INSTANCE, Clock.systemDefaultZone(), new MetricsRepositoryProvider(), UuidFactoryImpl.INSTANCE, DefaultHttpDownloader.class, SonarRuntimeImpl.forSonarQube(apiVersion, SonarQubeSide.SCANNER, edition), ScannerPluginInstaller.class, CoreExtensionRepositoryImpl.class, CoreExtensionsLoader.class, ScannerCoreExtensionsInstaller.class, DefaultGlobalSettingsLoader.class, DefaultNewCodePeriodLoader.class, DefaultMetricsRepositoryLoader.class);
    }

    @Override
    protected void doAfterStart() {
        this.installRequiredPlugins();
        this.loadCoreExtensions();
        long startTime = System.currentTimeMillis();
        String taskKey = StringUtils.defaultIfEmpty(this.scannerProperties.get("sonar.task"), "scan");
        if (taskKey.equals("views")) {
            throw MessageException.of("The task 'views' was removed with SonarQube 7.1. You can safely remove this call since portfolios and applications are automatically re-calculated.");
        }
        if (!taskKey.equals("scan")) {
            throw MessageException.of("Tasks support was removed in SonarQube 7.6.");
        }
        String analysisMode = StringUtils.defaultIfEmpty(this.scannerProperties.get("sonar.analysis.mode"), "publish");
        if (!analysisMode.equals("publish")) {
            throw MessageException.of("The preview mode, along with the 'sonar.analysis.mode' parameter, is no more supported. You should stop using this parameter.");
        }
        new SpringScannerContainer(this).execute();
        if (LOG.isInfoEnabled()) {
            LOG.info("Analysis total time: {}", (Object)SpringGlobalContainer.formatTime(System.currentTimeMillis() - startTime));
        }
    }

    private void installRequiredPlugins() {
        PluginRepository pluginRepository = this.getComponentByType(PluginRepository.class);
        for (PluginInfo pluginInfo : pluginRepository.getPluginInfos()) {
            Plugin instance = pluginRepository.getPluginInstance(pluginInfo.getKey());
            this.addExtension(pluginInfo, (Object)instance);
        }
    }

    private void loadCoreExtensions() {
        this.getComponentByType(CoreExtensionsLoader.class).load();
    }

    static String formatTime(long time) {
        long h = time / 3600000L;
        long m = (time - h * 60L * 60L * 1000L) / 60000L;
        long s = (time - h * 60L * 60L * 1000L - m * 60L * 1000L) / 1000L;
        long ms = time % 1000L;
        String format = h > 0L ? "%1$d:%2$02d:%3$02d.%4$03d s" : (m > 0L ? "%2$d:%3$02d.%4$03d s" : "%3$d.%4$03d s");
        return String.format(format, h, m, s, ms);
    }
}

