/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.utils.System2;
import org.sonar.scanner.bootstrap.ScannerProperties;
import org.sonar.scanner.bootstrap.SonarUserHome;
import org.springframework.context.annotation.Bean;

public class SonarUserHomeProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SonarUserHomeProvider.class);
    private System2 system;

    public SonarUserHomeProvider() {
        this(new System2());
    }

    SonarUserHomeProvider(System2 system) {
        this.system = system;
    }

    @Bean
    public SonarUserHome provide(ScannerProperties scannerProps) {
        Path home = this.findSonarHome(scannerProps);
        LOG.debug("Sonar User Home: {}", (Object)home);
        return new SonarUserHome(home);
    }

    private Path findSonarHome(ScannerProperties props) {
        String home = props.property("sonar.userHome");
        if (home != null) {
            return Paths.get(home, new String[0]).toAbsolutePath();
        }
        home = this.system.envVariable("SONAR_USER_HOME");
        if (home != null) {
            return Paths.get(home, new String[0]).toAbsolutePath();
        }
        String userHome = Objects.requireNonNull(this.system.property("user.home"), "The system property 'user.home' is expected to be non null");
        return Paths.get(userHome, ".sonar").toAbsolutePath();
    }
}

