/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.Plugin;
import org.sonar.api.Startable;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.Preconditions;
import org.sonar.core.platform.ExplodedPlugin;
import org.sonar.core.platform.PluginClassLoader;
import org.sonar.core.platform.PluginInfo;
import org.sonar.core.platform.PluginJarExploder;
import org.sonar.core.platform.PluginRepository;
import org.sonar.core.plugin.PluginType;
import org.sonar.scanner.bootstrap.PluginInstaller;
import org.sonar.scanner.bootstrap.ScannerPlugin;
import org.sonar.scanner.mediumtest.LocalPlugin;

public class ScannerPluginRepository
implements PluginRepository,
Startable {
    private static final Logger LOG = LoggerFactory.getLogger(ScannerPluginRepository.class);
    private final PluginInstaller installer;
    private final PluginJarExploder pluginJarExploder;
    private final PluginClassLoader loader;
    private final Configuration properties;
    private Map<String, Plugin> pluginInstancesByKeys;
    private Map<String, ScannerPlugin> pluginsByKeys;
    private Map<ClassLoader, String> keysByClassLoader;
    private boolean shouldLoadOnlyRequiredPluginsOnStart;

    public ScannerPluginRepository(PluginInstaller installer, PluginJarExploder pluginJarExploder, PluginClassLoader loader, Configuration properties) {
        this.installer = installer;
        this.pluginJarExploder = pluginJarExploder;
        this.loader = loader;
        this.properties = properties;
    }

    @Override
    public void start() {
        this.shouldLoadOnlyRequiredPluginsOnStart = this.properties.getBoolean("sonar.plugins.downloadOnlyRequired").orElse(true);
        if (!this.shouldLoadOnlyRequiredPluginsOnStart) {
            LOG.warn("{} is false, so ALL available plugins will be downloaded", (Object)"sonar.plugins.downloadOnlyRequired");
            this.pluginsByKeys = new HashMap<String, ScannerPlugin>(this.installer.installAllPlugins());
        } else {
            this.pluginsByKeys = new HashMap<String, ScannerPlugin>(this.installer.installRequiredPlugins());
        }
        Map<String, ExplodedPlugin> explodedPluginsByKey = this.pluginsByKeys.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.pluginJarExploder.explode(((ScannerPlugin)e.getValue()).getInfo())));
        this.pluginInstancesByKeys = new HashMap<String, Plugin>(this.loader.load(explodedPluginsByKey));
        for (LocalPlugin localPlugin : this.installer.installLocals()) {
            ScannerPlugin scannerPlugin = localPlugin.toScannerPlugin();
            String pluginKey = localPlugin.pluginInfo().getKey();
            this.pluginsByKeys.put(pluginKey, scannerPlugin);
            this.pluginInstancesByKeys.put(pluginKey, localPlugin.pluginInstance());
        }
        this.keysByClassLoader = new HashMap<ClassLoader, String>();
        for (Map.Entry entry : this.pluginInstancesByKeys.entrySet()) {
            this.keysByClassLoader.put(((Plugin)entry.getValue()).getClass().getClassLoader(), (String)entry.getKey());
        }
        ScannerPluginRepository.logPlugins(this.pluginsByKeys.values());
    }

    public Collection<PluginInfo> installPluginsForLanguages(Set<String> languageKeys) {
        if (!this.shouldLoadOnlyRequiredPluginsOnStart) {
            return Collections.emptySet();
        }
        HashMap<String, ScannerPlugin> languagePluginsByKeys = new HashMap<String, ScannerPlugin>(this.installer.installPluginsForLanguages(languageKeys));
        this.pluginsByKeys.putAll(languagePluginsByKeys);
        Map<String, ExplodedPlugin> explodedPluginsByKey = languagePluginsByKeys.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.pluginJarExploder.explode(((ScannerPlugin)e.getValue()).getInfo())));
        this.pluginInstancesByKeys.putAll(new HashMap<String, Plugin>(this.loader.load(explodedPluginsByKey)));
        for (LocalPlugin localPlugin : this.installer.installOptionalLocals(languageKeys)) {
            ScannerPlugin scannerPlugin = localPlugin.toScannerPlugin();
            String pluginKey = localPlugin.pluginInfo().getKey();
            languagePluginsByKeys.put(pluginKey, scannerPlugin);
            this.pluginsByKeys.put(pluginKey, scannerPlugin);
            this.pluginInstancesByKeys.put(pluginKey, localPlugin.pluginInstance());
        }
        this.keysByClassLoader = new HashMap<ClassLoader, String>();
        for (Map.Entry entry : this.pluginInstancesByKeys.entrySet()) {
            this.keysByClassLoader.put(((Plugin)entry.getValue()).getClass().getClassLoader(), (String)entry.getKey());
        }
        ScannerPluginRepository.logPlugins(languagePluginsByKeys.values());
        return languagePluginsByKeys.values().stream().map(ScannerPlugin::getInfo).toList();
    }

    @CheckForNull
    public String getPluginKey(ClassLoader cl) {
        return this.keysByClassLoader.get(cl);
    }

    private static void logPlugins(Collection<ScannerPlugin> plugins) {
        if (plugins.isEmpty()) {
            LOG.debug("No plugins loaded");
        } else {
            LOG.debug("Plugins loaded:");
            for (ScannerPlugin p : plugins) {
                LOG.debug("  * {} {} ({})", p.getName(), p.getVersion(), p.getKey());
            }
        }
    }

    @Override
    public void stop() {
        this.loader.unload(this.pluginInstancesByKeys.values());
        this.pluginInstancesByKeys.clear();
        this.pluginsByKeys.clear();
        this.keysByClassLoader.clear();
    }

    public Map<String, ScannerPlugin> getPluginsByKey() {
        return this.pluginsByKeys;
    }

    @Override
    public Collection<PluginInfo> getPluginInfos() {
        return this.pluginsByKeys.values().stream().map(ScannerPlugin::getInfo).toList();
    }

    public Collection<PluginInfo> getExternalPluginsInfos() {
        return this.pluginsByKeys.values().stream().filter(p -> p.getType() == PluginType.EXTERNAL).map(ScannerPlugin::getInfo).toList();
    }

    public Collection<PluginInfo> getBundledPluginsInfos() {
        return this.pluginsByKeys.values().stream().filter(p -> p.getType() == PluginType.BUNDLED).map(ScannerPlugin::getInfo).toList();
    }

    @Override
    public PluginInfo getPluginInfo(String key) {
        ScannerPlugin info = this.pluginsByKeys.get(key);
        Preconditions.checkState(info != null, "Plugin [%s] does not exist", key);
        return info.getInfo();
    }

    @Override
    public Plugin getPluginInstance(String key) {
        Plugin instance = this.pluginInstancesByKeys.get(key);
        Preconditions.checkState(instance != null, "Plugin [%s] does not exist", key);
        return instance;
    }

    @Override
    public Collection<Plugin> getPluginInstances() {
        return this.pluginInstancesByKeys.values();
    }

    @Override
    public boolean hasPlugin(String key) {
        return this.pluginsByKeys.containsKey(key);
    }
}

