/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import com.google.gson.Gson;
import java.io.File;
import java.io.Reader;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.core.platform.PluginInfo;
import org.sonar.core.plugin.PluginType;
import org.sonar.scanner.bootstrap.PluginFiles;
import org.sonar.scanner.bootstrap.PluginInstaller;
import org.sonar.scanner.bootstrap.ScannerPlugin;
import org.sonar.scanner.http.DefaultScannerWsClient;
import org.sonar.scanner.mediumtest.LocalPlugin;
import org.sonarqube.ws.client.GetRequest;

public class ScannerPluginInstaller
implements PluginInstaller {
    private static final Logger LOG = Loggers.get(ScannerPluginInstaller.class);
    private static final String PLUGINS_WS_URL = "api/plugins/installed";
    private final PluginFiles pluginFiles;
    private final DefaultScannerWsClient wsClient;
    private List<InstalledPlugin> availablePlugins;

    public ScannerPluginInstaller(PluginFiles pluginFiles, DefaultScannerWsClient wsClient) {
        this.pluginFiles = pluginFiles;
        this.wsClient = wsClient;
    }

    @Override
    public Map<String, ScannerPlugin> installAllPlugins() {
        LOG.info("Loading all plugins");
        return this.installPlugins((Predicate<InstalledPlugin>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$installAllPlugins$0(org.sonar.scanner.bootstrap.ScannerPluginInstaller$InstalledPlugin ), (Lorg/sonar/scanner/bootstrap/ScannerPluginInstaller$InstalledPlugin;)Z)()).installedPluginsByKey;
    }

    @Override
    public Map<String, ScannerPlugin> installRequiredPlugins() {
        LOG.info("Loading required plugins");
        InstallResult result = this.installPlugins(p -> p.getRequiredForLanguages() == null || p.getRequiredForLanguages().isEmpty());
        LOG.debug("Plugins not loaded because they are optional: {}", (Object)result.skippedPlugins);
        return result.installedPluginsByKey;
    }

    @Override
    public Map<String, ScannerPlugin> installPluginsForLanguages(Set<String> languageKeys) {
        LOG.info("Loading plugins for detected languages");
        LOG.debug("Detected languages: {}", (Object)languageKeys);
        InstallResult result = this.installPlugins(p -> p.getRequiredForLanguages() != null && !Collections.disjoint(p.getRequiredForLanguages(), languageKeys));
        List<InstalledPlugin> skippedLanguagePlugins = result.skippedPlugins.stream().filter(p -> p.getRequiredForLanguages() != null && !p.getRequiredForLanguages().isEmpty()).toList();
        LOG.debug("Optional language-specific plugins not loaded: {}", (Object)skippedLanguagePlugins);
        return result.installedPluginsByKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstallResult installPlugins(Predicate<InstalledPlugin> pluginFilter) {
        if (this.availablePlugins == null) {
            this.availablePlugins = this.listInstalledPlugins();
        }
        Profiler profiler = Profiler.create(LOG).startInfo("Load/download plugins");
        try {
            InstallResult result = new InstallResult();
            Loaded loaded = this.loadPlugins(result, pluginFilter);
            if (!loaded.ok) {
                this.availablePlugins = this.listInstalledPlugins();
                result.installedPluginsByKey.clear();
                loaded = this.loadPlugins(result, pluginFilter);
                if (!loaded.ok) {
                    throw new IllegalStateException(String.format("Fail to download plugin [%s]. Not found.", loaded.notFoundPlugin));
                }
            }
            InstallResult installResult = result;
            return installResult;
        }
        finally {
            profiler.stopInfo();
        }
    }

    private Loaded loadPlugins(InstallResult result, Predicate<InstalledPlugin> pluginFilter) {
        List<InstalledPlugin> pluginsToInstall = this.availablePlugins.stream().filter(pluginFilter).toList();
        for (InstalledPlugin plugin : pluginsToInstall) {
            Optional<File> jarFile = this.pluginFiles.get(plugin);
            if (jarFile.isEmpty()) {
                return new Loaded(false, plugin.key);
            }
            PluginInfo info = PluginInfo.create(jarFile.get());
            result.installedPluginsByKey.put(info.getKey(), new ScannerPlugin(plugin.key, plugin.updatedAt, PluginType.valueOf(plugin.type), info));
        }
        result.skippedPlugins = this.availablePlugins.stream().filter(Predicate.not(pluginFilter)).toList();
        return new Loaded(true, null);
    }

    @Override
    public List<LocalPlugin> installLocals() {
        return Collections.emptyList();
    }

    @Override
    public List<LocalPlugin> installOptionalLocals(Set<String> languageKeys) {
        return Collections.emptyList();
    }

    private List<InstalledPlugin> listInstalledPlugins() {
        InstalledPlugins installedPlugins;
        Profiler profiler = Profiler.create(LOG).startInfo("Load plugins index");
        GetRequest getRequest = new GetRequest(PLUGINS_WS_URL);
        try (Reader reader = this.wsClient.call(getRequest).contentReader();){
            installedPlugins = new Gson().fromJson(reader, InstalledPlugins.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to parse response of api/plugins/installed", e);
        }
        profiler.stopInfo();
        return installedPlugins.plugins;
    }

    private static /* synthetic */ boolean lambda$installAllPlugins$0(InstalledPlugin p) {
        return true;
    }

    private static class InstallResult {
        Map<String, ScannerPlugin> installedPluginsByKey = new HashMap<String, ScannerPlugin>();
        List<InstalledPlugin> skippedPlugins = new ArrayList<InstalledPlugin>();

        private InstallResult() {
        }
    }

    private static class Loaded {
        private final boolean ok;
        @Nullable
        private final String notFoundPlugin;

        private Loaded(boolean ok, @Nullable String notFoundPlugin) {
            this.ok = ok;
            this.notFoundPlugin = notFoundPlugin;
        }
    }

    static class InstalledPlugin {
        String key;
        String hash;
        long updatedAt;
        String type;
        private Set<String> requiredForLanguages;

        public Set<String> getRequiredForLanguages() {
            return this.requiredForLanguages;
        }

        public String toString() {
            return this.key;
        }
    }

    private static class InstalledPlugins {
        List<InstalledPlugin> plugins;
    }
}

