/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.OutputStreamAppender;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.utils.MessageException;
import org.sonar.batch.bootstrapper.EnvironmentInformation;
import org.sonar.batch.bootstrapper.LoggingConfiguration;
import org.sonar.scanner.bootstrap.EnvironmentConfig;
import org.sonar.scanner.bootstrap.JGitCleanupService;
import org.sonar.scanner.bootstrap.ScannerLogbackEncoder;
import org.sonar.scanner.bootstrap.SpringGlobalContainer;

public class ScannerMain {
    private static final Logger LOG = LoggerFactory.getLogger(ScannerMain.class);
    private static final String SCANNER_APP_KEY = "sonar.scanner.app";
    private static final String SCANNER_APP_VERSION_KEY = "sonar.scanner.appVersion";

    public static void main(String ... args) {
        System.exit(ScannerMain.run(System.in, System.out));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int run(InputStream in, OutputStream out) {
        try {
            int n;
            JGitCleanupService ignored = new JGitCleanupService();
            try {
                ScannerMain.configureLogOutput(out);
                LOG.info("Starting SonarScanner Engine...");
                LOG.atInfo().log(ScannerMain::java);
                Map<String, String> properties = ScannerMain.parseInputProperties(in);
                EnvironmentConfig.processEnvVariables(properties);
                ScannerMain.configureLogLevel(properties);
                ScannerMain.runScannerEngine(properties);
                LOG.info("SonarScanner Engine completed successfully");
                n = 0;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    ScannerMain.handleException(throwable3);
                    int n2 = 1;
                    return n2;
                }
            }
            ignored.close();
            return n;
        }
        finally {
            ScannerMain.stopLogback();
        }
    }

    static String java() {
        StringBuilder sb = new StringBuilder();
        sb.append("Java ").append(System.getProperty("java.version")).append(" ").append(System.getProperty("java.vendor"));
        String bits = System.getProperty("sun.arch.data.model");
        if ("32".equals(bits) || "64".equals(bits)) {
            sb.append(" (").append(bits).append("-bit)");
        }
        return sb.toString();
    }

    private static void handleException(Throwable throwable) {
        Optional<String> messageException = ScannerMain.unwrapMessageException(throwable);
        if (messageException.isPresent()) {
            if (LoggerFactory.getLogger(ScannerMain.class).isDebugEnabled()) {
                LOG.error(messageException.get(), throwable);
            } else {
                LOG.error(messageException.get());
            }
        } else {
            LOG.error("Error during SonarScanner Engine execution", throwable);
        }
    }

    private static Optional<String> unwrapMessageException(@Nullable Throwable throwable) {
        if (throwable == null) {
            return Optional.empty();
        }
        if (throwable instanceof MessageException) {
            MessageException messageException = (MessageException)throwable;
            return Optional.of(messageException.getMessage());
        }
        return ScannerMain.unwrapMessageException(throwable.getCause());
    }

    @NotNull
    private static Map<String, String> parseInputProperties(InputStream in) {
        HashMap<String, String> properties = new HashMap<String, String>();
        Input input = ScannerMain.parseJsonInput(in);
        if (input != null && input.scannerProperties != null) {
            input.scannerProperties.forEach(prop -> {
                if (prop == null || prop.key == null && prop.value == null) {
                    LOG.warn("Ignoring null or empty property");
                } else if (prop.key == null) {
                    LOG.warn("Ignoring property with null key. Value='{}'", (Object)prop.value);
                } else if (prop.value == null) {
                    LOG.warn("Ignoring property with null value. Key='{}'", (Object)prop.key);
                } else {
                    if (properties.containsKey(prop.key)) {
                        LOG.warn("Duplicated properties. Key='{}'", (Object)prop.key);
                    }
                    properties.put(prop.key, prop.value);
                }
            });
        }
        return properties;
    }

    @CheckForNull
    private static Input parseJsonInput(InputStream in) {
        Input input;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        try {
            input = new Gson().fromJson((Reader)reader, Input.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to parse JSON input", e);
            }
        }
        reader.close();
        return input;
    }

    private static void runScannerEngine(Map<String, String> properties) {
        String scannerAppKey = properties.get(SCANNER_APP_KEY);
        String scannerAppVersion = properties.get(SCANNER_APP_VERSION_KEY);
        EnvironmentInformation env = new EnvironmentInformation(scannerAppKey, scannerAppVersion);
        SpringGlobalContainer.create(properties, List.of(env)).execute();
    }

    private static void configureLogLevel(Map<String, String> properties) {
        boolean verbose = LoggingConfiguration.isVerboseEnabled(properties);
        ch.qos.logback.classic.Logger rootLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger("ROOT");
        rootLogger.setLevel(Level.toLevel(verbose ? "DEBUG" : "INFO"));
    }

    private static void configureLogOutput(OutputStream out) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        ScannerLogbackEncoder encoder = new ScannerLogbackEncoder();
        encoder.setContext(loggerContext);
        encoder.start();
        OutputStreamAppender<ILoggingEvent> appender = new OutputStreamAppender<ILoggingEvent>();
        appender.setEncoder(encoder);
        appender.setContext(loggerContext);
        appender.setOutputStream(out);
        appender.start();
        ch.qos.logback.classic.Logger rootLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger("ROOT");
        rootLogger.addAppender((Appender<ILoggingEvent>)appender);
        rootLogger.setLevel(Level.toLevel("INFO"));
    }

    private static void stopLogback() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        loggerContext.stop();
    }

    private static class Input {
        @SerializedName(value="scannerProperties")
        private List<ScannerProperty> scannerProperties;

        private Input() {
        }
    }

    private static class ScannerProperty {
        @SerializedName(value="key")
        private String key;
        @SerializedName(value="value")
        private String value;

        private ScannerProperty() {
        }
    }
}

