/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.encoder.EncoderBase;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;

public class ScannerLogbackEncoder
extends EncoderBase<ILoggingEvent> {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final char OPEN_OBJ = '{';
    private static final char CLOSE_OBJ = '}';
    private static final char VALUE_SEPARATOR = ',';
    private static final char QUOTE = '\"';
    private static final String QUOTE_COL = "\":";
    private final ThrowableProxyConverter tpc = new ThrowableProxyConverter();

    public ScannerLogbackEncoder() {
        this.tpc.setOptionList(List.of("full"));
        this.tpc.start();
    }

    @Override
    public byte[] headerBytes() {
        return EMPTY_BYTES;
    }

    @Override
    public byte[] encode(ILoggingEvent event) {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        Level level = event.getLevel();
        if (level != null) {
            ScannerLogbackEncoder.appenderMember(sb, "level", level.levelStr);
            sb.append(',');
        }
        ScannerLogbackEncoder.appenderMember(sb, "message", StringEscapeUtils.escapeJson(event.getFormattedMessage()));
        IThrowableProxy tp = event.getThrowableProxy();
        String stackTrace = null;
        if (tp != null) {
            sb.append(',');
            stackTrace = this.tpc.convert(event);
            ScannerLogbackEncoder.appenderMember(sb, "stacktrace", StringEscapeUtils.escapeJson(stackTrace));
        }
        sb.append('}');
        sb.append('\n');
        return sb.toString().getBytes(CoreConstants.UTF_8_CHARSET);
    }

    private static void appenderMember(StringBuilder sb, String key, String value) {
        sb.append('\"').append(key).append(QUOTE_COL).append('\"').append(value).append('\"');
    }

    @Override
    public byte[] footerBytes() {
        return EMPTY_BYTES;
    }
}

