/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.config.Configuration;
import org.sonar.scanner.bootstrap.ScannerPluginInstaller;
import org.sonar.scanner.bootstrap.SonarUserHome;
import org.sonar.scanner.http.DefaultScannerWsClient;
import org.sonarqube.ws.client.GetRequest;
import org.sonarqube.ws.client.HttpException;
import org.sonarqube.ws.client.RequestWithoutPayload;
import org.sonarqube.ws.client.WsResponse;

public class PluginFiles {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginFiles.class);
    private static final String MD5_HEADER = "Sonar-MD5";
    @VisibleForTesting
    static final String PLUGINS_DOWNLOAD_TIMEOUT_PROPERTY = "sonar.plugins.download.timeout";
    private static final int PLUGINS_DOWNLOAD_TIMEOUT_DEFAULT = 300;
    private final DefaultScannerWsClient wsClient;
    private final Configuration configuration;
    private final Path cacheDir;
    private final Path tempDir;

    public PluginFiles(DefaultScannerWsClient wsClient, Configuration configuration, SonarUserHome sonarUserHome) {
        this.wsClient = wsClient;
        this.configuration = configuration;
        Path home = sonarUserHome.getPath();
        this.cacheDir = PluginFiles.mkdir(home.resolve("cache"), "user cache");
        this.tempDir = PluginFiles.mkdir(home.resolve("_tmp"), "temp dir");
        LOGGER.debug("User cache: {}", (Object)this.cacheDir);
    }

    public File createTempDir() {
        try {
            return Files.createTempDirectory(this.tempDir, "plugins", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to create temp directory in " + String.valueOf(this.tempDir), e);
        }
    }

    public Optional<File> get(ScannerPluginInstaller.InstalledPlugin plugin) {
        Path jarInCache = this.jarInCache(plugin.key, plugin.hash);
        if (Files.isRegularFile(jarInCache, new LinkOption[0])) {
            return Optional.of(jarInCache.toFile());
        }
        return this.download(plugin).map(Path::toFile);
    }

    private Optional<Path> download(ScannerPluginInstaller.InstalledPlugin plugin) {
        GetRequest request = (GetRequest)((RequestWithoutPayload)new GetRequest("api/plugins/download").setParam("plugin", plugin.key)).setTimeOutInMs(this.configuration.getInt(PLUGINS_DOWNLOAD_TIMEOUT_PROPERTY).orElse(300) * 1000);
        Path downloadedFile = this.newTempFile();
        LOGGER.debug("Download plugin '{}' to '{}'", (Object)plugin.key, (Object)downloadedFile);
        WsResponse response = this.wsClient.call(request);
        try {
            Optional<String> expectedMd5 = response.header(MD5_HEADER);
            if (expectedMd5.isEmpty()) {
                throw new IllegalStateException(String.format("Fail to download plugin [%s]. Request to %s did not return header %s", plugin.key, response.requestUrl(), MD5_HEADER));
            }
            PluginFiles.downloadBinaryTo(plugin, downloadedFile, response);
            String effectiveTempMd5 = PluginFiles.computeMd5(downloadedFile);
            if (!expectedMd5.get().equals(effectiveTempMd5)) {
                throw new IllegalStateException(String.format("Fail to download plugin [%s]. File %s was expected to have checksum %s but had %s", plugin.key, downloadedFile, expectedMd5.get(), effectiveTempMd5));
            }
            Path tempJar = downloadedFile;
            String cacheMd5 = expectedMd5.get();
            Path jarInCache = this.jarInCache(plugin.key, cacheMd5);
            PluginFiles.mkdir(jarInCache.getParent());
            PluginFiles.moveFile(tempJar, jarInCache);
            Optional<Path> optional = Optional.of(jarInCache);
            if (response != null) {
                response.close();
            }
            return optional;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (HttpException e) {
                if (e.code() == 404) {
                    return Optional.empty();
                }
                throw new IllegalStateException(String.format("Fail to download plugin [%s]. Request to %s returned code %d.", plugin.key, e.url(), e.code()));
            }
        }
    }

    private static void downloadBinaryTo(ScannerPluginInstaller.InstalledPlugin plugin, Path downloadedFile, WsResponse response) {
        try (InputStream stream = response.contentStream();){
            FileUtils.copyInputStreamToFile(stream, downloadedFile.toFile());
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Fail to download plugin [%s] into %s", plugin.key, downloadedFile), e);
        }
    }

    private Path jarInCache(String pluginKey, String hash) {
        Path hashDir = this.cacheDir.resolve(hash);
        Path file = hashDir.resolve(String.format("sonar-%s-plugin.jar", pluginKey));
        if (!file.getParent().equals(hashDir)) {
            throw new IllegalStateException(String.format("Fail to download plugin [%s]. Key is not valid.", pluginKey));
        }
        return file;
    }

    private Path newTempFile() {
        try {
            return Files.createTempFile(this.tempDir, "fileCache", null, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to create temp file in " + String.valueOf(this.tempDir), e);
        }
    }

    private static String computeMd5(Path file) {
        String string;
        BufferedInputStream fis = new BufferedInputStream(Files.newInputStream(file, new OpenOption[0]));
        try {
            string = DigestUtils.md5Hex(fis);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)fis).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("Fail to compute md5 of " + String.valueOf(file), e);
            }
        }
        ((InputStream)fis).close();
        return string;
    }

    private static void moveFile(Path sourceFile, Path targetFile) {
        block4: {
            try {
                Files.move(sourceFile, targetFile, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException e1) {
                if (Files.exists(targetFile, new LinkOption[0])) break block4;
                LOGGER.warn("Unable to rename {} to {}", (Object)sourceFile, (Object)targetFile);
                LOGGER.warn("A copy/delete will be tempted but with no guarantee of atomicity");
                try {
                    Files.move(sourceFile, targetFile, new CopyOption[0]);
                }
                catch (IOException e2) {
                    throw new IllegalStateException("Fail to move " + String.valueOf(sourceFile) + " to " + String.valueOf(targetFile), e2);
                }
            }
        }
    }

    private static void mkdir(Path dir) {
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to create cache directory: " + String.valueOf(dir), e);
        }
    }

    private static Path mkdir(Path dir, String debugTitle) {
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            LOGGER.debug("Create : {}", (Object)dir);
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to create folder " + debugTitle + " at " + String.valueOf(dir), e);
            }
        }
        return dir;
    }
}

