/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.Startable;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.utils.System2;

class JREDeprecationChecker
implements Startable {
    private static final Logger LOG = LoggerFactory.getLogger(JREDeprecationChecker.class);
    private final AnalysisWarnings analysisWarnings;
    private final System2 system2;

    JREDeprecationChecker(AnalysisWarnings analysisWarnings, System2 system2) {
        this.analysisWarnings = analysisWarnings;
        this.system2 = system2;
    }

    @Override
    public void start() {
        String javaVersion = this.system2.property("java.version");
        if (javaVersion != null) {
            try {
                String[] versionElements = javaVersion.split("\\.");
                int majorVersion = Integer.parseInt(versionElements[0]);
                if (majorVersion < 21) {
                    String msg = "Java " + majorVersion + " scanner support ends with SonarQube 2026.3 (July 2026). Please upgrade to Java 21 or newer, or use JRE auto-provisioning to keep this requirement always up to date.";
                    LOG.warn(msg);
                    this.analysisWarnings.addUnique(msg);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public void stop() {
    }
}

