/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.impl.utils.DefaultTempFolder;
import org.sonar.api.utils.TempFolder;
import org.sonar.core.util.FileUtils;
import org.sonar.scanner.bootstrap.ScannerProperties;
import org.sonar.scanner.bootstrap.SonarUserHome;
import org.springframework.context.annotation.Bean;

public class GlobalTempFolderProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalTempFolderProvider.class);
    private static final long CLEAN_MAX_AGE = TimeUnit.DAYS.toMillis(21L);
    static final String TMP_NAME_PREFIX = ".sonartmp_";

    @Bean(value={"GlobalTempFolder"})
    public TempFolder provide(ScannerProperties scannerProps, SonarUserHome userHome) {
        String workingPathName = StringUtils.defaultIfBlank(scannerProps.property("sonar.globalWorking.directory"), "");
        Path workingPath = Paths.get(workingPathName, new String[0]);
        if (!workingPath.isAbsolute()) {
            Path home = userHome.getPath();
            workingPath = home.resolve(workingPath).normalize();
        }
        try {
            GlobalTempFolderProvider.cleanTempFolders(workingPath);
        }
        catch (IOException e) {
            LOG.error(String.format("failed to clean global working directory: %s", workingPath), e);
        }
        Path tempDir = GlobalTempFolderProvider.createTempFolder(workingPath);
        return new DefaultTempFolder(tempDir.toFile(), true);
    }

    private static Path createTempFolder(Path workingPath) {
        try {
            Path realPath = workingPath;
            if (Files.isSymbolicLink(realPath)) {
                realPath = realPath.toRealPath(new LinkOption[0]);
            }
            Files.createDirectories(realPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create working path: " + String.valueOf(workingPath), e);
        }
        try {
            return Files.createTempDirectory(workingPath, TMP_NAME_PREFIX, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create temporary folder in " + String.valueOf(workingPath), e);
        }
    }

    private static void cleanTempFolders(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path, new CleanFilter());){
                for (Path p : stream) {
                    FileUtils.deleteQuietly(p.toFile());
                }
            }
        }
    }

    private static class CleanFilter
    implements DirectoryStream.Filter<Path> {
        private CleanFilter() {
        }

        @Override
        public boolean accept(Path path) {
            BasicFileAttributes attrs;
            if (!Files.exists(path, new LinkOption[0])) {
                return false;
            }
            if (!path.getFileName().toString().startsWith(GlobalTempFolderProvider.TMP_NAME_PREFIX)) {
                return false;
            }
            long threshold = System.currentTimeMillis() - CLEAN_MAX_AGE;
            try {
                attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            }
            catch (IOException ioe) {
                LOG.error(String.format("Couldn't read file attributes for %s : ", path), ioe);
                return false;
            }
            long creationTime = attrs.creationTime().toMillis();
            return creationTime < threshold;
        }
    }
}

