/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentConfig {
    private static final Logger LOG = LoggerFactory.getLogger(EnvironmentConfig.class);
    private static final String SONAR_SCANNER_JSON_PARAMS = "SONAR_SCANNER_JSON_PARAMS";
    private static final String SONARQUBE_SCANNER_PARAMS = "SONARQUBE_SCANNER_PARAMS";
    private static final String GENERIC_ENV_PREFIX = "SONAR_SCANNER_";

    private EnvironmentConfig() {
    }

    public static void processEnvVariables(Map<String, String> inputProperties) {
        EnvironmentConfig.processEnvVariables(inputProperties, System.getenv());
    }

    static void processEnvVariables(Map<String, String> inputProperties, Map<String, String> env) {
        env.forEach((key, value) -> {
            if (!key.equals(SONAR_SCANNER_JSON_PARAMS) && key.startsWith(GENERIC_ENV_PREFIX)) {
                EnvironmentConfig.processEnvVariable(key, value, inputProperties);
            }
        });
        String jsonParams = env.get(SONAR_SCANNER_JSON_PARAMS);
        String oldJsonParams = env.get(SONARQUBE_SCANNER_PARAMS);
        if (jsonParams != null) {
            if (oldJsonParams != null && !oldJsonParams.equals(jsonParams)) {
                LOG.warn("Ignoring environment variable '{}' because '{}' is set", (Object)SONARQUBE_SCANNER_PARAMS, (Object)SONAR_SCANNER_JSON_PARAMS);
            }
            EnvironmentConfig.parseJsonPropertiesFromEnv(jsonParams, inputProperties, SONAR_SCANNER_JSON_PARAMS);
        } else if (oldJsonParams != null) {
            EnvironmentConfig.parseJsonPropertiesFromEnv(oldJsonParams, inputProperties, SONARQUBE_SCANNER_PARAMS);
        }
    }

    private static void parseJsonPropertiesFromEnv(String jsonParams, Map<String, String> inputProperties, String envVariableName) {
        try {
            Map jsonProperties = (Map)new Gson().fromJson(jsonParams, (Type)((Object)Map.class));
            if (jsonProperties != null) {
                jsonProperties.forEach((key, value) -> {
                    if (inputProperties.containsKey(key)) {
                        if (!((String)inputProperties.get(key)).equals(value)) {
                            LOG.warn("Ignoring property '{}' from env variable '{}' because it is already defined", key, (Object)envVariableName);
                        }
                    } else {
                        inputProperties.put((String)key, (String)value);
                    }
                });
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse JSON properties from environment variable '" + envVariableName + "'", e);
        }
    }

    private static void processEnvVariable(String key, String value, Map<String, String> inputProperties) {
        String suffix = key.substring(GENERIC_ENV_PREFIX.length());
        if (suffix.isEmpty()) {
            return;
        }
        String toCamelCase = Stream.of(suffix.split("_")).map(String::toLowerCase).reduce((a, b) -> a + StringUtils.capitalize(b)).orElseThrow();
        String propKey = "sonar.scanner." + toCamelCase;
        if (inputProperties.containsKey(propKey)) {
            if (!inputProperties.get(propKey).equals(value)) {
                LOG.warn("Ignoring environment variable '{}' because it is already defined in the properties", (Object)key);
            }
        } else {
            inputProperties.put(propKey, value);
        }
    }
}

