/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sarif.pojo;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonar.sarif.pojo.PropertyBag;
import org.sonar.sarif.pojo.ToolComponent;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"driver", "extensions", "properties"})
public class Tool {
    @Nullable
    @JsonProperty(value="driver")
    @JsonPropertyDescription(value="A component, such as a plug-in or the driver, of the analysis tool that was run.")
    @Nonnull
    private ToolComponent driver;
    @Nullable
    @JsonProperty(value="extensions")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="Tool extensions that contributed to or reconfigured the analysis tool that was run.")
    private Set<ToolComponent> extensions;
    @Nullable
    @JsonProperty(value="properties")
    @JsonPropertyDescription(value="Key/value pairs that provide additional information about the object.")
    private PropertyBag properties;

    @JsonProperty(value="driver")
    public ToolComponent getDriver() {
        return this.driver;
    }

    @JsonProperty(value="driver")
    public void setDriver(ToolComponent driver) {
        this.driver = driver;
    }

    public Tool withDriver(ToolComponent driver) {
        this.driver = driver;
        return this;
    }

    @JsonProperty(value="extensions")
    public Set<ToolComponent> getExtensions() {
        return this.extensions;
    }

    @JsonProperty(value="extensions")
    public void setExtensions(Set<ToolComponent> extensions) {
        this.extensions = extensions;
    }

    public Tool withExtensions(Set<ToolComponent> extensions) {
        this.extensions = extensions;
        return this;
    }

    @JsonProperty(value="properties")
    public PropertyBag getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    public void setProperties(PropertyBag properties) {
        this.properties = properties;
    }

    public Tool withProperties(PropertyBag properties) {
        this.properties = properties;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Tool.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("driver");
        sb.append('=');
        sb.append(this.driver == null ? "<null>" : this.driver);
        sb.append(',');
        sb.append("extensions");
        sb.append('=');
        sb.append(this.extensions == null ? "<null>" : this.extensions);
        sb.append(',');
        sb.append("properties");
        sb.append('=');
        sb.append(this.properties == null ? "<null>" : this.properties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.driver == null ? 0 : this.driver.hashCode());
        result = result * 31 + (this.extensions == null ? 0 : this.extensions.hashCode());
        result = result * 31 + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Tool)) {
            return false;
        }
        Tool rhs = (Tool)other;
        return (this.driver == rhs.driver || this.driver != null && this.driver.equals(rhs.driver)) && (this.extensions == rhs.extensions || this.extensions != null && this.extensions.equals(rhs.extensions)) && (this.properties == rhs.properties || this.properties != null && this.properties.equals(rhs.properties));
    }
}

