/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sarif.pojo;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonar.sarif.pojo.Location;
import org.sonar.sarif.pojo.PropertyBag;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"guid", "kind", "status", "justification", "location", "properties"})
public class Suppression {
    @Nullable
    @JsonProperty(value="guid")
    @JsonPropertyDescription(value="A stable, unique identifier for the suprression in the form of a GUID.")
    private String guid;
    @JsonProperty(value="kind")
    @JsonPropertyDescription(value="A string that indicates where the suppression is persisted.")
    @Nonnull
    private Kind kind;
    @Nullable
    @JsonProperty(value="status")
    @JsonPropertyDescription(value="A string that indicates the review status of the suppression.")
    private Status status;
    @Nullable
    @JsonProperty(value="justification")
    @JsonPropertyDescription(value="A string representing the justification for the suppression.")
    private String justification;
    @Nullable
    @JsonProperty(value="location")
    @JsonPropertyDescription(value="A location within a programming artifact.")
    private Location location;
    @Nullable
    @JsonProperty(value="properties")
    @JsonPropertyDescription(value="Key/value pairs that provide additional information about the object.")
    private PropertyBag properties;

    @JsonProperty(value="guid")
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public Suppression withGuid(String guid) {
        this.guid = guid;
        return this;
    }

    @JsonProperty(value="kind")
    public Kind getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(Kind kind) {
        this.kind = kind;
    }

    public Suppression withKind(Kind kind) {
        this.kind = kind;
        return this;
    }

    @JsonProperty(value="status")
    public Status getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(Status status) {
        this.status = status;
    }

    public Suppression withStatus(Status status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="justification")
    public String getJustification() {
        return this.justification;
    }

    @JsonProperty(value="justification")
    public void setJustification(String justification) {
        this.justification = justification;
    }

    public Suppression withJustification(String justification) {
        this.justification = justification;
        return this;
    }

    @JsonProperty(value="location")
    public Location getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    public void setLocation(Location location) {
        this.location = location;
    }

    public Suppression withLocation(Location location) {
        this.location = location;
        return this;
    }

    @JsonProperty(value="properties")
    public PropertyBag getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    public void setProperties(PropertyBag properties) {
        this.properties = properties;
    }

    public Suppression withProperties(PropertyBag properties) {
        this.properties = properties;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Suppression.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("guid");
        sb.append('=');
        sb.append(this.guid == null ? "<null>" : this.guid);
        sb.append(',');
        sb.append("kind");
        sb.append('=');
        sb.append(this.kind == null ? "<null>" : this.kind);
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(this.status == null ? "<null>" : this.status);
        sb.append(',');
        sb.append("justification");
        sb.append('=');
        sb.append(this.justification == null ? "<null>" : this.justification);
        sb.append(',');
        sb.append("location");
        sb.append('=');
        sb.append(this.location == null ? "<null>" : this.location);
        sb.append(',');
        sb.append("properties");
        sb.append('=');
        sb.append(this.properties == null ? "<null>" : this.properties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.guid == null ? 0 : this.guid.hashCode());
        result = result * 31 + (this.location == null ? 0 : this.location.hashCode());
        result = result * 31 + (this.justification == null ? 0 : this.justification.hashCode());
        result = result * 31 + (this.kind == null ? 0 : this.kind.hashCode());
        result = result * 31 + (this.properties == null ? 0 : this.properties.hashCode());
        result = result * 31 + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Suppression)) {
            return false;
        }
        Suppression rhs = (Suppression)other;
        return (this.guid == rhs.guid || this.guid != null && this.guid.equals(rhs.guid)) && (this.location == rhs.location || this.location != null && this.location.equals(rhs.location)) && (this.justification == rhs.justification || this.justification != null && this.justification.equals(rhs.justification)) && (this.kind == rhs.kind || this.kind != null && this.kind.equals((Object)rhs.kind)) && (this.properties == rhs.properties || this.properties != null && this.properties.equals(rhs.properties)) && (this.status == rhs.status || this.status != null && this.status.equals((Object)rhs.status));
    }

    public static enum Kind {
        IN_SOURCE("inSource"),
        EXTERNAL("external");

        private final String value;
        private static final Map<String, Kind> CONSTANTS;

        private Kind(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Kind fromValue(String value) {
            Kind constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Kind>();
            for (Kind c : Kind.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum Status {
        ACCEPTED("accepted"),
        UNDER_REVIEW("underReview"),
        REJECTED("rejected");

        private final String value;
        private static final Map<String, Status> CONSTANTS;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Status fromValue(String value) {
            Status constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Status>();
            for (Status c : Status.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

