/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sarif.pojo;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonar.sarif.pojo.Address;
import org.sonar.sarif.pojo.Artifact;
import org.sonar.sarif.pojo.Conversion;
import org.sonar.sarif.pojo.ExternalPropertyFileReferences;
import org.sonar.sarif.pojo.Graph;
import org.sonar.sarif.pojo.Invocation;
import org.sonar.sarif.pojo.LogicalLocation;
import org.sonar.sarif.pojo.OriginalUriBaseIds;
import org.sonar.sarif.pojo.PropertyBag;
import org.sonar.sarif.pojo.Result;
import org.sonar.sarif.pojo.RunAutomationDetails;
import org.sonar.sarif.pojo.SpecialLocations;
import org.sonar.sarif.pojo.ThreadFlowLocation;
import org.sonar.sarif.pojo.Tool;
import org.sonar.sarif.pojo.ToolComponent;
import org.sonar.sarif.pojo.VersionControlDetails;
import org.sonar.sarif.pojo.WebRequest;
import org.sonar.sarif.pojo.WebResponse;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"tool", "invocations", "conversion", "language", "versionControlProvenance", "originalUriBaseIds", "artifacts", "logicalLocations", "graphs", "results", "automationDetails", "runAggregates", "baselineGuid", "redactionTokens", "defaultEncoding", "defaultSourceLanguage", "newlineSequences", "columnKind", "externalPropertyFileReferences", "threadFlowLocations", "taxonomies", "addresses", "translations", "policies", "webRequests", "webResponses", "specialLocations", "properties"})
public class Run {
    @Nullable
    @JsonProperty(value="tool")
    @JsonPropertyDescription(value="The analysis tool that was run.")
    @Nonnull
    private Tool tool;
    @Nullable
    @JsonProperty(value="invocations")
    @JsonPropertyDescription(value="Describes the invocation of the analysis tool.")
    private List<Invocation> invocations;
    @Nullable
    @JsonProperty(value="conversion")
    @JsonPropertyDescription(value="Describes how a converter transformed the output of a static analysis tool from the analysis tool's native output format into the SARIF format.")
    private Conversion conversion;
    @Nullable
    @JsonProperty(value="language")
    @JsonPropertyDescription(value="The language of the messages emitted into the log file during this run (expressed as an ISO 639-1 two-letter lowercase culture code) and an optional region (expressed as an ISO 3166-1 two-letter uppercase subculture code associated with a country or region). The casing is recommended but not required (in order for this data to conform to RFC5646).")
    private String language;
    @Nullable
    @JsonProperty(value="versionControlProvenance")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="Specifies the revision in version control of the artifacts that were scanned.")
    private Set<VersionControlDetails> versionControlProvenance;
    @Nullable
    @JsonProperty(value="originalUriBaseIds")
    @JsonPropertyDescription(value="The artifact location specified by each uriBaseId symbol on the machine where the tool originally ran.")
    private OriginalUriBaseIds originalUriBaseIds;
    @Nullable
    @JsonProperty(value="artifacts")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="An array of artifact objects relevant to the run.")
    private Set<Artifact> artifacts;
    @Nullable
    @JsonProperty(value="logicalLocations")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="An array of logical locations such as namespaces, types or functions.")
    private Set<LogicalLocation> logicalLocations;
    @Nullable
    @JsonProperty(value="graphs")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="An array of zero or more unique graph objects associated with the run.")
    private Set<Graph> graphs;
    @Nullable
    @JsonProperty(value="results")
    @JsonPropertyDescription(value="The set of results contained in an SARIF log. The results array can be omitted when a run is solely exporting rules metadata. It must be present (but may be empty) if a log file represents an actual scan.")
    private List<Result> results;
    @Nullable
    @JsonProperty(value="automationDetails")
    @JsonPropertyDescription(value="Information that describes a run's identity and role within an engineering system process.")
    private RunAutomationDetails automationDetails;
    @Nullable
    @JsonProperty(value="runAggregates")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="Automation details that describe the aggregate of runs to which this run belongs.")
    private Set<RunAutomationDetails> runAggregates;
    @Nullable
    @JsonProperty(value="baselineGuid")
    @JsonPropertyDescription(value="The 'guid' property of a previous SARIF 'run' that comprises the baseline that was used to compute result 'baselineState' properties for the run.")
    private String baselineGuid;
    @Nullable
    @JsonProperty(value="redactionTokens")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="An array of strings used to replace sensitive information in a redaction-aware property.")
    private Set<String> redactionTokens;
    @Nullable
    @JsonProperty(value="defaultEncoding")
    @JsonPropertyDescription(value="Specifies the default encoding for any artifact object that refers to a text file.")
    private String defaultEncoding;
    @Nullable
    @JsonProperty(value="defaultSourceLanguage")
    @JsonPropertyDescription(value="Specifies the default source language for any artifact object that refers to a text file that contains source code.")
    private String defaultSourceLanguage;
    @Nullable
    @JsonProperty(value="newlineSequences")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="An ordered list of character sequences that were treated as line breaks when computing region information for the run.")
    private Set<String> newlineSequences;
    @Nullable
    @JsonProperty(value="columnKind")
    @JsonPropertyDescription(value="Specifies the unit in which the tool measures columns.")
    private ColumnKind columnKind;
    @Nullable
    @JsonProperty(value="externalPropertyFileReferences")
    @JsonPropertyDescription(value="References to external property files that should be inlined with the content of a root log file.")
    private ExternalPropertyFileReferences externalPropertyFileReferences;
    @Nullable
    @JsonProperty(value="threadFlowLocations")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="An array of threadFlowLocation objects cached at run level.")
    private Set<ThreadFlowLocation> threadFlowLocations;
    @Nullable
    @JsonProperty(value="taxonomies")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="An array of toolComponent objects relevant to a taxonomy in which results are categorized.")
    private Set<ToolComponent> taxonomies;
    @Nullable
    @JsonProperty(value="addresses")
    @JsonPropertyDescription(value="Addresses associated with this run instance, if any.")
    private List<Address> addresses;
    @Nullable
    @JsonProperty(value="translations")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="The set of available translations of the localized data provided by the tool.")
    private Set<ToolComponent> translations;
    @Nullable
    @JsonProperty(value="policies")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="Contains configurations that may potentially override both reportingDescriptor.defaultConfiguration (the tool's default severities) and invocation.configurationOverrides (severities established at run-time from the command line).")
    private Set<ToolComponent> policies;
    @Nullable
    @JsonProperty(value="webRequests")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="An array of request objects cached at run level.")
    private Set<WebRequest> webRequests;
    @Nullable
    @JsonProperty(value="webResponses")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="An array of response objects cached at run level.")
    private Set<WebResponse> webResponses;
    @Nullable
    @JsonProperty(value="specialLocations")
    @JsonPropertyDescription(value="Defines locations of special significance to SARIF consumers.")
    private SpecialLocations specialLocations;
    @Nullable
    @JsonProperty(value="properties")
    @JsonPropertyDescription(value="Key/value pairs that provide additional information about the object.")
    private PropertyBag properties;

    @JsonProperty(value="tool")
    public Tool getTool() {
        return this.tool;
    }

    @JsonProperty(value="tool")
    public void setTool(Tool tool) {
        this.tool = tool;
    }

    public Run withTool(Tool tool) {
        this.tool = tool;
        return this;
    }

    @JsonProperty(value="invocations")
    public List<Invocation> getInvocations() {
        return this.invocations;
    }

    @JsonProperty(value="invocations")
    public void setInvocations(List<Invocation> invocations) {
        this.invocations = invocations;
    }

    public Run withInvocations(List<Invocation> invocations) {
        this.invocations = invocations;
        return this;
    }

    @JsonProperty(value="conversion")
    public Conversion getConversion() {
        return this.conversion;
    }

    @JsonProperty(value="conversion")
    public void setConversion(Conversion conversion) {
        this.conversion = conversion;
    }

    public Run withConversion(Conversion conversion) {
        this.conversion = conversion;
        return this;
    }

    @JsonProperty(value="language")
    public String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    public void setLanguage(String language) {
        this.language = language;
    }

    public Run withLanguage(String language) {
        this.language = language;
        return this;
    }

    @JsonProperty(value="versionControlProvenance")
    public Set<VersionControlDetails> getVersionControlProvenance() {
        return this.versionControlProvenance;
    }

    @JsonProperty(value="versionControlProvenance")
    public void setVersionControlProvenance(Set<VersionControlDetails> versionControlProvenance) {
        this.versionControlProvenance = versionControlProvenance;
    }

    public Run withVersionControlProvenance(Set<VersionControlDetails> versionControlProvenance) {
        this.versionControlProvenance = versionControlProvenance;
        return this;
    }

    @JsonProperty(value="originalUriBaseIds")
    public OriginalUriBaseIds getOriginalUriBaseIds() {
        return this.originalUriBaseIds;
    }

    @JsonProperty(value="originalUriBaseIds")
    public void setOriginalUriBaseIds(OriginalUriBaseIds originalUriBaseIds) {
        this.originalUriBaseIds = originalUriBaseIds;
    }

    public Run withOriginalUriBaseIds(OriginalUriBaseIds originalUriBaseIds) {
        this.originalUriBaseIds = originalUriBaseIds;
        return this;
    }

    @JsonProperty(value="artifacts")
    public Set<Artifact> getArtifacts() {
        return this.artifacts;
    }

    @JsonProperty(value="artifacts")
    public void setArtifacts(Set<Artifact> artifacts) {
        this.artifacts = artifacts;
    }

    public Run withArtifacts(Set<Artifact> artifacts) {
        this.artifacts = artifacts;
        return this;
    }

    @JsonProperty(value="logicalLocations")
    public Set<LogicalLocation> getLogicalLocations() {
        return this.logicalLocations;
    }

    @JsonProperty(value="logicalLocations")
    public void setLogicalLocations(Set<LogicalLocation> logicalLocations) {
        this.logicalLocations = logicalLocations;
    }

    public Run withLogicalLocations(Set<LogicalLocation> logicalLocations) {
        this.logicalLocations = logicalLocations;
        return this;
    }

    @JsonProperty(value="graphs")
    public Set<Graph> getGraphs() {
        return this.graphs;
    }

    @JsonProperty(value="graphs")
    public void setGraphs(Set<Graph> graphs) {
        this.graphs = graphs;
    }

    public Run withGraphs(Set<Graph> graphs) {
        this.graphs = graphs;
        return this;
    }

    @JsonProperty(value="results")
    public List<Result> getResults() {
        return this.results;
    }

    @JsonProperty(value="results")
    public void setResults(List<Result> results) {
        this.results = results;
    }

    public Run withResults(List<Result> results) {
        this.results = results;
        return this;
    }

    @JsonProperty(value="automationDetails")
    public RunAutomationDetails getAutomationDetails() {
        return this.automationDetails;
    }

    @JsonProperty(value="automationDetails")
    public void setAutomationDetails(RunAutomationDetails automationDetails) {
        this.automationDetails = automationDetails;
    }

    public Run withAutomationDetails(RunAutomationDetails automationDetails) {
        this.automationDetails = automationDetails;
        return this;
    }

    @JsonProperty(value="runAggregates")
    public Set<RunAutomationDetails> getRunAggregates() {
        return this.runAggregates;
    }

    @JsonProperty(value="runAggregates")
    public void setRunAggregates(Set<RunAutomationDetails> runAggregates) {
        this.runAggregates = runAggregates;
    }

    public Run withRunAggregates(Set<RunAutomationDetails> runAggregates) {
        this.runAggregates = runAggregates;
        return this;
    }

    @JsonProperty(value="baselineGuid")
    public String getBaselineGuid() {
        return this.baselineGuid;
    }

    @JsonProperty(value="baselineGuid")
    public void setBaselineGuid(String baselineGuid) {
        this.baselineGuid = baselineGuid;
    }

    public Run withBaselineGuid(String baselineGuid) {
        this.baselineGuid = baselineGuid;
        return this;
    }

    @JsonProperty(value="redactionTokens")
    public Set<String> getRedactionTokens() {
        return this.redactionTokens;
    }

    @JsonProperty(value="redactionTokens")
    public void setRedactionTokens(Set<String> redactionTokens) {
        this.redactionTokens = redactionTokens;
    }

    public Run withRedactionTokens(Set<String> redactionTokens) {
        this.redactionTokens = redactionTokens;
        return this;
    }

    @JsonProperty(value="defaultEncoding")
    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    @JsonProperty(value="defaultEncoding")
    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public Run withDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
        return this;
    }

    @JsonProperty(value="defaultSourceLanguage")
    public String getDefaultSourceLanguage() {
        return this.defaultSourceLanguage;
    }

    @JsonProperty(value="defaultSourceLanguage")
    public void setDefaultSourceLanguage(String defaultSourceLanguage) {
        this.defaultSourceLanguage = defaultSourceLanguage;
    }

    public Run withDefaultSourceLanguage(String defaultSourceLanguage) {
        this.defaultSourceLanguage = defaultSourceLanguage;
        return this;
    }

    @JsonProperty(value="newlineSequences")
    public Set<String> getNewlineSequences() {
        return this.newlineSequences;
    }

    @JsonProperty(value="newlineSequences")
    public void setNewlineSequences(Set<String> newlineSequences) {
        this.newlineSequences = newlineSequences;
    }

    public Run withNewlineSequences(Set<String> newlineSequences) {
        this.newlineSequences = newlineSequences;
        return this;
    }

    @JsonProperty(value="columnKind")
    public ColumnKind getColumnKind() {
        return this.columnKind;
    }

    @JsonProperty(value="columnKind")
    public void setColumnKind(ColumnKind columnKind) {
        this.columnKind = columnKind;
    }

    public Run withColumnKind(ColumnKind columnKind) {
        this.columnKind = columnKind;
        return this;
    }

    @JsonProperty(value="externalPropertyFileReferences")
    public ExternalPropertyFileReferences getExternalPropertyFileReferences() {
        return this.externalPropertyFileReferences;
    }

    @JsonProperty(value="externalPropertyFileReferences")
    public void setExternalPropertyFileReferences(ExternalPropertyFileReferences externalPropertyFileReferences) {
        this.externalPropertyFileReferences = externalPropertyFileReferences;
    }

    public Run withExternalPropertyFileReferences(ExternalPropertyFileReferences externalPropertyFileReferences) {
        this.externalPropertyFileReferences = externalPropertyFileReferences;
        return this;
    }

    @JsonProperty(value="threadFlowLocations")
    public Set<ThreadFlowLocation> getThreadFlowLocations() {
        return this.threadFlowLocations;
    }

    @JsonProperty(value="threadFlowLocations")
    public void setThreadFlowLocations(Set<ThreadFlowLocation> threadFlowLocations) {
        this.threadFlowLocations = threadFlowLocations;
    }

    public Run withThreadFlowLocations(Set<ThreadFlowLocation> threadFlowLocations) {
        this.threadFlowLocations = threadFlowLocations;
        return this;
    }

    @JsonProperty(value="taxonomies")
    public Set<ToolComponent> getTaxonomies() {
        return this.taxonomies;
    }

    @JsonProperty(value="taxonomies")
    public void setTaxonomies(Set<ToolComponent> taxonomies) {
        this.taxonomies = taxonomies;
    }

    public Run withTaxonomies(Set<ToolComponent> taxonomies) {
        this.taxonomies = taxonomies;
        return this;
    }

    @JsonProperty(value="addresses")
    public List<Address> getAddresses() {
        return this.addresses;
    }

    @JsonProperty(value="addresses")
    public void setAddresses(List<Address> addresses) {
        this.addresses = addresses;
    }

    public Run withAddresses(List<Address> addresses) {
        this.addresses = addresses;
        return this;
    }

    @JsonProperty(value="translations")
    public Set<ToolComponent> getTranslations() {
        return this.translations;
    }

    @JsonProperty(value="translations")
    public void setTranslations(Set<ToolComponent> translations) {
        this.translations = translations;
    }

    public Run withTranslations(Set<ToolComponent> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty(value="policies")
    public Set<ToolComponent> getPolicies() {
        return this.policies;
    }

    @JsonProperty(value="policies")
    public void setPolicies(Set<ToolComponent> policies) {
        this.policies = policies;
    }

    public Run withPolicies(Set<ToolComponent> policies) {
        this.policies = policies;
        return this;
    }

    @JsonProperty(value="webRequests")
    public Set<WebRequest> getWebRequests() {
        return this.webRequests;
    }

    @JsonProperty(value="webRequests")
    public void setWebRequests(Set<WebRequest> webRequests) {
        this.webRequests = webRequests;
    }

    public Run withWebRequests(Set<WebRequest> webRequests) {
        this.webRequests = webRequests;
        return this;
    }

    @JsonProperty(value="webResponses")
    public Set<WebResponse> getWebResponses() {
        return this.webResponses;
    }

    @JsonProperty(value="webResponses")
    public void setWebResponses(Set<WebResponse> webResponses) {
        this.webResponses = webResponses;
    }

    public Run withWebResponses(Set<WebResponse> webResponses) {
        this.webResponses = webResponses;
        return this;
    }

    @JsonProperty(value="specialLocations")
    public SpecialLocations getSpecialLocations() {
        return this.specialLocations;
    }

    @JsonProperty(value="specialLocations")
    public void setSpecialLocations(SpecialLocations specialLocations) {
        this.specialLocations = specialLocations;
    }

    public Run withSpecialLocations(SpecialLocations specialLocations) {
        this.specialLocations = specialLocations;
        return this;
    }

    @JsonProperty(value="properties")
    public PropertyBag getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    public void setProperties(PropertyBag properties) {
        this.properties = properties;
    }

    public Run withProperties(PropertyBag properties) {
        this.properties = properties;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Run.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("tool");
        sb.append('=');
        sb.append(this.tool == null ? "<null>" : this.tool);
        sb.append(',');
        sb.append("invocations");
        sb.append('=');
        sb.append(this.invocations == null ? "<null>" : this.invocations);
        sb.append(',');
        sb.append("conversion");
        sb.append('=');
        sb.append(this.conversion == null ? "<null>" : this.conversion);
        sb.append(',');
        sb.append("language");
        sb.append('=');
        sb.append(this.language == null ? "<null>" : this.language);
        sb.append(',');
        sb.append("versionControlProvenance");
        sb.append('=');
        sb.append(this.versionControlProvenance == null ? "<null>" : this.versionControlProvenance);
        sb.append(',');
        sb.append("originalUriBaseIds");
        sb.append('=');
        sb.append(this.originalUriBaseIds == null ? "<null>" : this.originalUriBaseIds);
        sb.append(',');
        sb.append("artifacts");
        sb.append('=');
        sb.append(this.artifacts == null ? "<null>" : this.artifacts);
        sb.append(',');
        sb.append("logicalLocations");
        sb.append('=');
        sb.append(this.logicalLocations == null ? "<null>" : this.logicalLocations);
        sb.append(',');
        sb.append("graphs");
        sb.append('=');
        sb.append(this.graphs == null ? "<null>" : this.graphs);
        sb.append(',');
        sb.append("results");
        sb.append('=');
        sb.append(this.results == null ? "<null>" : this.results);
        sb.append(',');
        sb.append("automationDetails");
        sb.append('=');
        sb.append(this.automationDetails == null ? "<null>" : this.automationDetails);
        sb.append(',');
        sb.append("runAggregates");
        sb.append('=');
        sb.append(this.runAggregates == null ? "<null>" : this.runAggregates);
        sb.append(',');
        sb.append("baselineGuid");
        sb.append('=');
        sb.append(this.baselineGuid == null ? "<null>" : this.baselineGuid);
        sb.append(',');
        sb.append("redactionTokens");
        sb.append('=');
        sb.append(this.redactionTokens == null ? "<null>" : this.redactionTokens);
        sb.append(',');
        sb.append("defaultEncoding");
        sb.append('=');
        sb.append(this.defaultEncoding == null ? "<null>" : this.defaultEncoding);
        sb.append(',');
        sb.append("defaultSourceLanguage");
        sb.append('=');
        sb.append(this.defaultSourceLanguage == null ? "<null>" : this.defaultSourceLanguage);
        sb.append(',');
        sb.append("newlineSequences");
        sb.append('=');
        sb.append(this.newlineSequences == null ? "<null>" : this.newlineSequences);
        sb.append(',');
        sb.append("columnKind");
        sb.append('=');
        sb.append(this.columnKind == null ? "<null>" : this.columnKind);
        sb.append(',');
        sb.append("externalPropertyFileReferences");
        sb.append('=');
        sb.append(this.externalPropertyFileReferences == null ? "<null>" : this.externalPropertyFileReferences);
        sb.append(',');
        sb.append("threadFlowLocations");
        sb.append('=');
        sb.append(this.threadFlowLocations == null ? "<null>" : this.threadFlowLocations);
        sb.append(',');
        sb.append("taxonomies");
        sb.append('=');
        sb.append(this.taxonomies == null ? "<null>" : this.taxonomies);
        sb.append(',');
        sb.append("addresses");
        sb.append('=');
        sb.append(this.addresses == null ? "<null>" : this.addresses);
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(this.translations == null ? "<null>" : this.translations);
        sb.append(',');
        sb.append("policies");
        sb.append('=');
        sb.append(this.policies == null ? "<null>" : this.policies);
        sb.append(',');
        sb.append("webRequests");
        sb.append('=');
        sb.append(this.webRequests == null ? "<null>" : this.webRequests);
        sb.append(',');
        sb.append("webResponses");
        sb.append('=');
        sb.append(this.webResponses == null ? "<null>" : this.webResponses);
        sb.append(',');
        sb.append("specialLocations");
        sb.append('=');
        sb.append(this.specialLocations == null ? "<null>" : this.specialLocations);
        sb.append(',');
        sb.append("properties");
        sb.append('=');
        sb.append(this.properties == null ? "<null>" : this.properties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.addresses == null ? 0 : this.addresses.hashCode());
        result = result * 31 + (this.logicalLocations == null ? 0 : this.logicalLocations.hashCode());
        result = result * 31 + (this.policies == null ? 0 : this.policies.hashCode());
        result = result * 31 + (this.language == null ? 0 : this.language.hashCode());
        result = result * 31 + (this.invocations == null ? 0 : this.invocations.hashCode());
        result = result * 31 + (this.graphs == null ? 0 : this.graphs.hashCode());
        result = result * 31 + (this.baselineGuid == null ? 0 : this.baselineGuid.hashCode());
        result = result * 31 + (this.translations == null ? 0 : this.translations.hashCode());
        result = result * 31 + (this.newlineSequences == null ? 0 : this.newlineSequences.hashCode());
        result = result * 31 + (this.webResponses == null ? 0 : this.webResponses.hashCode());
        result = result * 31 + (this.externalPropertyFileReferences == null ? 0 : this.externalPropertyFileReferences.hashCode());
        result = result * 31 + (this.defaultSourceLanguage == null ? 0 : this.defaultSourceLanguage.hashCode());
        result = result * 31 + (this.webRequests == null ? 0 : this.webRequests.hashCode());
        result = result * 31 + (this.results == null ? 0 : this.results.hashCode());
        result = result * 31 + (this.automationDetails == null ? 0 : this.automationDetails.hashCode());
        result = result * 31 + (this.conversion == null ? 0 : this.conversion.hashCode());
        result = result * 31 + (this.artifacts == null ? 0 : this.artifacts.hashCode());
        result = result * 31 + (this.originalUriBaseIds == null ? 0 : this.originalUriBaseIds.hashCode());
        result = result * 31 + (this.specialLocations == null ? 0 : this.specialLocations.hashCode());
        result = result * 31 + (this.defaultEncoding == null ? 0 : this.defaultEncoding.hashCode());
        result = result * 31 + (this.tool == null ? 0 : this.tool.hashCode());
        result = result * 31 + (this.versionControlProvenance == null ? 0 : this.versionControlProvenance.hashCode());
        result = result * 31 + (this.runAggregates == null ? 0 : this.runAggregates.hashCode());
        result = result * 31 + (this.redactionTokens == null ? 0 : this.redactionTokens.hashCode());
        result = result * 31 + (this.taxonomies == null ? 0 : this.taxonomies.hashCode());
        result = result * 31 + (this.columnKind == null ? 0 : this.columnKind.hashCode());
        result = result * 31 + (this.threadFlowLocations == null ? 0 : this.threadFlowLocations.hashCode());
        result = result * 31 + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Run)) {
            return false;
        }
        Run rhs = (Run)other;
        return (this.addresses == rhs.addresses || this.addresses != null && this.addresses.equals(rhs.addresses)) && (this.logicalLocations == rhs.logicalLocations || this.logicalLocations != null && this.logicalLocations.equals(rhs.logicalLocations)) && (this.policies == rhs.policies || this.policies != null && this.policies.equals(rhs.policies)) && (this.language == rhs.language || this.language != null && this.language.equals(rhs.language)) && (this.invocations == rhs.invocations || this.invocations != null && this.invocations.equals(rhs.invocations)) && (this.graphs == rhs.graphs || this.graphs != null && this.graphs.equals(rhs.graphs)) && (this.baselineGuid == rhs.baselineGuid || this.baselineGuid != null && this.baselineGuid.equals(rhs.baselineGuid)) && (this.translations == rhs.translations || this.translations != null && this.translations.equals(rhs.translations)) && (this.newlineSequences == rhs.newlineSequences || this.newlineSequences != null && this.newlineSequences.equals(rhs.newlineSequences)) && (this.webResponses == rhs.webResponses || this.webResponses != null && this.webResponses.equals(rhs.webResponses)) && (this.externalPropertyFileReferences == rhs.externalPropertyFileReferences || this.externalPropertyFileReferences != null && this.externalPropertyFileReferences.equals(rhs.externalPropertyFileReferences)) && (this.defaultSourceLanguage == rhs.defaultSourceLanguage || this.defaultSourceLanguage != null && this.defaultSourceLanguage.equals(rhs.defaultSourceLanguage)) && (this.webRequests == rhs.webRequests || this.webRequests != null && this.webRequests.equals(rhs.webRequests)) && (this.results == rhs.results || this.results != null && this.results.equals(rhs.results)) && (this.automationDetails == rhs.automationDetails || this.automationDetails != null && this.automationDetails.equals(rhs.automationDetails)) && (this.conversion == rhs.conversion || this.conversion != null && this.conversion.equals(rhs.conversion)) && (this.artifacts == rhs.artifacts || this.artifacts != null && this.artifacts.equals(rhs.artifacts)) && (this.originalUriBaseIds == rhs.originalUriBaseIds || this.originalUriBaseIds != null && this.originalUriBaseIds.equals(rhs.originalUriBaseIds)) && (this.specialLocations == rhs.specialLocations || this.specialLocations != null && this.specialLocations.equals(rhs.specialLocations)) && (this.defaultEncoding == rhs.defaultEncoding || this.defaultEncoding != null && this.defaultEncoding.equals(rhs.defaultEncoding)) && (this.tool == rhs.tool || this.tool != null && this.tool.equals(rhs.tool)) && (this.versionControlProvenance == rhs.versionControlProvenance || this.versionControlProvenance != null && this.versionControlProvenance.equals(rhs.versionControlProvenance)) && (this.runAggregates == rhs.runAggregates || this.runAggregates != null && this.runAggregates.equals(rhs.runAggregates)) && (this.redactionTokens == rhs.redactionTokens || this.redactionTokens != null && this.redactionTokens.equals(rhs.redactionTokens)) && (this.taxonomies == rhs.taxonomies || this.taxonomies != null && this.taxonomies.equals(rhs.taxonomies)) && (this.columnKind == rhs.columnKind || this.columnKind != null && this.columnKind.equals((Object)rhs.columnKind)) && (this.threadFlowLocations == rhs.threadFlowLocations || this.threadFlowLocations != null && this.threadFlowLocations.equals(rhs.threadFlowLocations)) && (this.properties == rhs.properties || this.properties != null && this.properties.equals(rhs.properties));
    }

    public static enum ColumnKind {
        UTF_16_CODE_UNITS("utf16CodeUnits"),
        UNICODE_CODE_POINTS("unicodeCodePoints");

        private final String value;
        private static final Map<String, ColumnKind> CONSTANTS;

        private ColumnKind(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ColumnKind fromValue(String value) {
            ColumnKind constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ColumnKind>();
            for (ColumnKind c : ColumnKind.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

