/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sarif.pojo;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.sarif.pojo.PhysicalLocation;
import org.sonar.sarif.pojo.PropertyBag;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"firstDetectionTimeUtc", "lastDetectionTimeUtc", "firstDetectionRunGuid", "lastDetectionRunGuid", "invocationIndex", "conversionSources", "properties"})
public class ResultProvenance {
    @Nullable
    @JsonProperty(value="firstDetectionTimeUtc")
    @JsonPropertyDescription(value="The Coordinated Universal Time (UTC) date and time at which the result was first detected. See \"Date/time properties\" in the SARIF spec for the required format.")
    private Date firstDetectionTimeUtc;
    @Nullable
    @JsonProperty(value="lastDetectionTimeUtc")
    @JsonPropertyDescription(value="The Coordinated Universal Time (UTC) date and time at which the result was most recently detected. See \"Date/time properties\" in the SARIF spec for the required format.")
    private Date lastDetectionTimeUtc;
    @Nullable
    @JsonProperty(value="firstDetectionRunGuid")
    @JsonPropertyDescription(value="A GUID-valued string equal to the automationDetails.guid property of the run in which the result was first detected.")
    private String firstDetectionRunGuid;
    @Nullable
    @JsonProperty(value="lastDetectionRunGuid")
    @JsonPropertyDescription(value="A GUID-valued string equal to the automationDetails.guid property of the run in which the result was most recently detected.")
    private String lastDetectionRunGuid;
    @Nullable
    @JsonProperty(value="invocationIndex")
    @JsonPropertyDescription(value="The index within the run.invocations array of the invocation object which describes the tool invocation that detected the result.")
    private Integer invocationIndex;
    @Nullable
    @JsonProperty(value="conversionSources")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="An array of physicalLocation objects which specify the portions of an analysis tool's output that a converter transformed into the result.")
    private Set<PhysicalLocation> conversionSources;
    @Nullable
    @JsonProperty(value="properties")
    @JsonPropertyDescription(value="Key/value pairs that provide additional information about the object.")
    private PropertyBag properties;

    @JsonProperty(value="firstDetectionTimeUtc")
    public Date getFirstDetectionTimeUtc() {
        return this.firstDetectionTimeUtc;
    }

    @JsonProperty(value="firstDetectionTimeUtc")
    public void setFirstDetectionTimeUtc(Date firstDetectionTimeUtc) {
        this.firstDetectionTimeUtc = firstDetectionTimeUtc;
    }

    public ResultProvenance withFirstDetectionTimeUtc(Date firstDetectionTimeUtc) {
        this.firstDetectionTimeUtc = firstDetectionTimeUtc;
        return this;
    }

    @JsonProperty(value="lastDetectionTimeUtc")
    public Date getLastDetectionTimeUtc() {
        return this.lastDetectionTimeUtc;
    }

    @JsonProperty(value="lastDetectionTimeUtc")
    public void setLastDetectionTimeUtc(Date lastDetectionTimeUtc) {
        this.lastDetectionTimeUtc = lastDetectionTimeUtc;
    }

    public ResultProvenance withLastDetectionTimeUtc(Date lastDetectionTimeUtc) {
        this.lastDetectionTimeUtc = lastDetectionTimeUtc;
        return this;
    }

    @JsonProperty(value="firstDetectionRunGuid")
    public String getFirstDetectionRunGuid() {
        return this.firstDetectionRunGuid;
    }

    @JsonProperty(value="firstDetectionRunGuid")
    public void setFirstDetectionRunGuid(String firstDetectionRunGuid) {
        this.firstDetectionRunGuid = firstDetectionRunGuid;
    }

    public ResultProvenance withFirstDetectionRunGuid(String firstDetectionRunGuid) {
        this.firstDetectionRunGuid = firstDetectionRunGuid;
        return this;
    }

    @JsonProperty(value="lastDetectionRunGuid")
    public String getLastDetectionRunGuid() {
        return this.lastDetectionRunGuid;
    }

    @JsonProperty(value="lastDetectionRunGuid")
    public void setLastDetectionRunGuid(String lastDetectionRunGuid) {
        this.lastDetectionRunGuid = lastDetectionRunGuid;
    }

    public ResultProvenance withLastDetectionRunGuid(String lastDetectionRunGuid) {
        this.lastDetectionRunGuid = lastDetectionRunGuid;
        return this;
    }

    @JsonProperty(value="invocationIndex")
    public Integer getInvocationIndex() {
        return this.invocationIndex;
    }

    @JsonProperty(value="invocationIndex")
    public void setInvocationIndex(Integer invocationIndex) {
        this.invocationIndex = invocationIndex;
    }

    public ResultProvenance withInvocationIndex(Integer invocationIndex) {
        this.invocationIndex = invocationIndex;
        return this;
    }

    @JsonProperty(value="conversionSources")
    public Set<PhysicalLocation> getConversionSources() {
        return this.conversionSources;
    }

    @JsonProperty(value="conversionSources")
    public void setConversionSources(Set<PhysicalLocation> conversionSources) {
        this.conversionSources = conversionSources;
    }

    public ResultProvenance withConversionSources(Set<PhysicalLocation> conversionSources) {
        this.conversionSources = conversionSources;
        return this;
    }

    @JsonProperty(value="properties")
    public PropertyBag getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    public void setProperties(PropertyBag properties) {
        this.properties = properties;
    }

    public ResultProvenance withProperties(PropertyBag properties) {
        this.properties = properties;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ResultProvenance.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("firstDetectionTimeUtc");
        sb.append('=');
        sb.append(this.firstDetectionTimeUtc == null ? "<null>" : this.firstDetectionTimeUtc);
        sb.append(',');
        sb.append("lastDetectionTimeUtc");
        sb.append('=');
        sb.append(this.lastDetectionTimeUtc == null ? "<null>" : this.lastDetectionTimeUtc);
        sb.append(',');
        sb.append("firstDetectionRunGuid");
        sb.append('=');
        sb.append(this.firstDetectionRunGuid == null ? "<null>" : this.firstDetectionRunGuid);
        sb.append(',');
        sb.append("lastDetectionRunGuid");
        sb.append('=');
        sb.append(this.lastDetectionRunGuid == null ? "<null>" : this.lastDetectionRunGuid);
        sb.append(',');
        sb.append("invocationIndex");
        sb.append('=');
        sb.append(this.invocationIndex == null ? "<null>" : this.invocationIndex);
        sb.append(',');
        sb.append("conversionSources");
        sb.append('=');
        sb.append(this.conversionSources == null ? "<null>" : this.conversionSources);
        sb.append(',');
        sb.append("properties");
        sb.append('=');
        sb.append(this.properties == null ? "<null>" : this.properties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.firstDetectionRunGuid == null ? 0 : this.firstDetectionRunGuid.hashCode());
        result = result * 31 + (this.lastDetectionTimeUtc == null ? 0 : this.lastDetectionTimeUtc.hashCode());
        result = result * 31 + (this.invocationIndex == null ? 0 : this.invocationIndex.hashCode());
        result = result * 31 + (this.lastDetectionRunGuid == null ? 0 : this.lastDetectionRunGuid.hashCode());
        result = result * 31 + (this.conversionSources == null ? 0 : this.conversionSources.hashCode());
        result = result * 31 + (this.firstDetectionTimeUtc == null ? 0 : this.firstDetectionTimeUtc.hashCode());
        result = result * 31 + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ResultProvenance)) {
            return false;
        }
        ResultProvenance rhs = (ResultProvenance)other;
        return (this.firstDetectionRunGuid == rhs.firstDetectionRunGuid || this.firstDetectionRunGuid != null && this.firstDetectionRunGuid.equals(rhs.firstDetectionRunGuid)) && (this.lastDetectionTimeUtc == rhs.lastDetectionTimeUtc || this.lastDetectionTimeUtc != null && this.lastDetectionTimeUtc.equals(rhs.lastDetectionTimeUtc)) && (this.invocationIndex == rhs.invocationIndex || this.invocationIndex != null && this.invocationIndex.equals(rhs.invocationIndex)) && (this.lastDetectionRunGuid == rhs.lastDetectionRunGuid || this.lastDetectionRunGuid != null && this.lastDetectionRunGuid.equals(rhs.lastDetectionRunGuid)) && (this.conversionSources == rhs.conversionSources || this.conversionSources != null && this.conversionSources.equals(rhs.conversionSources)) && (this.firstDetectionTimeUtc == rhs.firstDetectionTimeUtc || this.firstDetectionTimeUtc != null && this.firstDetectionTimeUtc.equals(rhs.firstDetectionTimeUtc)) && (this.properties == rhs.properties || this.properties != null && this.properties.equals(rhs.properties));
    }
}

