/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sarif.pojo;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonar.sarif.pojo.ArtifactLocation;
import org.sonar.sarif.pojo.Attachment;
import org.sonar.sarif.pojo.CodeFlow;
import org.sonar.sarif.pojo.Fingerprints;
import org.sonar.sarif.pojo.Fix;
import org.sonar.sarif.pojo.Graph;
import org.sonar.sarif.pojo.GraphTraversal;
import org.sonar.sarif.pojo.Location;
import org.sonar.sarif.pojo.Message;
import org.sonar.sarif.pojo.PartialFingerprints;
import org.sonar.sarif.pojo.PropertyBag;
import org.sonar.sarif.pojo.ReportingDescriptorReference;
import org.sonar.sarif.pojo.ResultProvenance;
import org.sonar.sarif.pojo.Stack;
import org.sonar.sarif.pojo.Suppression;
import org.sonar.sarif.pojo.WebRequest;
import org.sonar.sarif.pojo.WebResponse;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"ruleId", "ruleIndex", "rule", "kind", "level", "message", "analysisTarget", "locations", "guid", "correlationGuid", "occurrenceCount", "partialFingerprints", "fingerprints", "stacks", "codeFlows", "graphs", "graphTraversals", "relatedLocations", "suppressions", "baselineState", "rank", "attachments", "hostedViewerUri", "workItemUris", "provenance", "fixes", "taxa", "webRequest", "webResponse", "properties"})
public class Result {
    @Nullable
    @JsonProperty(value="ruleId")
    @JsonPropertyDescription(value="The stable, unique identifier of the rule, if any, to which this result is relevant.")
    private String ruleId;
    @Nullable
    @JsonProperty(value="ruleIndex")
    @JsonPropertyDescription(value="The index within the tool component rules array of the rule object associated with this result.")
    private Integer ruleIndex;
    @Nullable
    @JsonProperty(value="rule")
    @JsonPropertyDescription(value="Information about how to locate a relevant reporting descriptor.")
    private ReportingDescriptorReference rule;
    @Nullable
    @JsonProperty(value="kind")
    @JsonPropertyDescription(value="A value that categorizes results by evaluation state.")
    private Kind kind;
    @Nullable
    @JsonProperty(value="level")
    @JsonPropertyDescription(value="A value specifying the severity level of the result.")
    private Level level;
    @JsonProperty(value="message")
    @JsonPropertyDescription(value="Encapsulates a message intended to be read by the end user.")
    @Nonnull
    private Message message;
    @Nullable
    @JsonProperty(value="analysisTarget")
    @JsonPropertyDescription(value="Specifies the location of an artifact.")
    private ArtifactLocation analysisTarget;
    @Nullable
    @JsonProperty(value="locations")
    @JsonPropertyDescription(value="The set of locations where the result was detected. Specify only one location unless the problem indicated by the result can only be corrected by making a change at every specified location.")
    private List<Location> locations;
    @Nullable
    @JsonProperty(value="guid")
    @JsonPropertyDescription(value="A stable, unique identifier for the result in the form of a GUID.")
    private String guid;
    @Nullable
    @JsonProperty(value="correlationGuid")
    @JsonPropertyDescription(value="A stable, unique identifier for the equivalence class of logically identical results to which this result belongs, in the form of a GUID.")
    private String correlationGuid;
    @Nullable
    @JsonProperty(value="occurrenceCount")
    @JsonPropertyDescription(value="A positive integer specifying the number of times this logically unique result was observed in this run.")
    private Integer occurrenceCount;
    @Nullable
    @JsonProperty(value="partialFingerprints")
    @JsonPropertyDescription(value="A set of strings that contribute to the stable, unique identity of the result.")
    private PartialFingerprints partialFingerprints;
    @Nullable
    @JsonProperty(value="fingerprints")
    @JsonPropertyDescription(value="A set of strings each of which individually defines a stable, unique identity for the result.")
    private Fingerprints fingerprints;
    @Nullable
    @JsonProperty(value="stacks")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="An array of 'stack' objects relevant to the result.")
    private Set<Stack> stacks;
    @Nullable
    @JsonProperty(value="codeFlows")
    @JsonPropertyDescription(value="An array of 'codeFlow' objects relevant to the result.")
    private List<CodeFlow> codeFlows;
    @Nullable
    @JsonProperty(value="graphs")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="An array of zero or more unique graph objects associated with the result.")
    private Set<Graph> graphs;
    @Nullable
    @JsonProperty(value="graphTraversals")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="An array of one or more unique 'graphTraversal' objects.")
    private Set<GraphTraversal> graphTraversals;
    @Nullable
    @JsonProperty(value="relatedLocations")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="A set of locations relevant to this result.")
    private Set<Location> relatedLocations;
    @Nullable
    @JsonProperty(value="suppressions")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="A set of suppressions relevant to this result.")
    private Set<Suppression> suppressions;
    @Nullable
    @JsonProperty(value="baselineState")
    @JsonPropertyDescription(value="The state of a result relative to a baseline of a previous run.")
    private BaselineState baselineState;
    @Nullable
    @JsonProperty(value="rank")
    @JsonPropertyDescription(value="A number representing the priority or importance of the result.")
    private Double rank;
    @Nullable
    @JsonProperty(value="attachments")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="A set of artifacts relevant to the result.")
    private Set<Attachment> attachments;
    @Nullable
    @JsonProperty(value="hostedViewerUri")
    @JsonPropertyDescription(value="An absolute URI at which the result can be viewed.")
    private URI hostedViewerUri;
    @Nullable
    @JsonProperty(value="workItemUris")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="The URIs of the work items associated with this result.")
    private Set<URI> workItemUris;
    @Nullable
    @JsonProperty(value="provenance")
    @JsonPropertyDescription(value="Contains information about how and when a result was detected.")
    private ResultProvenance provenance;
    @Nullable
    @JsonProperty(value="fixes")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="An array of 'fix' objects, each of which represents a proposed fix to the problem indicated by the result.")
    private Set<Fix> fixes;
    @Nullable
    @JsonProperty(value="taxa")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="An array of references to taxonomy reporting descriptors that are applicable to the result.")
    private Set<ReportingDescriptorReference> taxa;
    @Nullable
    @JsonProperty(value="webRequest")
    @JsonPropertyDescription(value="Describes an HTTP request.")
    private WebRequest webRequest;
    @Nullable
    @JsonProperty(value="webResponse")
    @JsonPropertyDescription(value="Describes the response to an HTTP request.")
    private WebResponse webResponse;
    @Nullable
    @JsonProperty(value="properties")
    @JsonPropertyDescription(value="Key/value pairs that provide additional information about the object.")
    private PropertyBag properties;

    @JsonProperty(value="ruleId")
    public String getRuleId() {
        return this.ruleId;
    }

    @JsonProperty(value="ruleId")
    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public Result withRuleId(String ruleId) {
        this.ruleId = ruleId;
        return this;
    }

    @JsonProperty(value="ruleIndex")
    public Integer getRuleIndex() {
        return this.ruleIndex;
    }

    @JsonProperty(value="ruleIndex")
    public void setRuleIndex(Integer ruleIndex) {
        this.ruleIndex = ruleIndex;
    }

    public Result withRuleIndex(Integer ruleIndex) {
        this.ruleIndex = ruleIndex;
        return this;
    }

    @JsonProperty(value="rule")
    public ReportingDescriptorReference getRule() {
        return this.rule;
    }

    @JsonProperty(value="rule")
    public void setRule(ReportingDescriptorReference rule) {
        this.rule = rule;
    }

    public Result withRule(ReportingDescriptorReference rule) {
        this.rule = rule;
        return this;
    }

    @JsonProperty(value="kind")
    public Kind getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(Kind kind) {
        this.kind = kind;
    }

    public Result withKind(Kind kind) {
        this.kind = kind;
        return this;
    }

    @JsonProperty(value="level")
    public Level getLevel() {
        return this.level;
    }

    @JsonProperty(value="level")
    public void setLevel(Level level) {
        this.level = level;
    }

    public Result withLevel(Level level) {
        this.level = level;
        return this;
    }

    @JsonProperty(value="message")
    public Message getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    public void setMessage(Message message) {
        this.message = message;
    }

    public Result withMessage(Message message) {
        this.message = message;
        return this;
    }

    @JsonProperty(value="analysisTarget")
    public ArtifactLocation getAnalysisTarget() {
        return this.analysisTarget;
    }

    @JsonProperty(value="analysisTarget")
    public void setAnalysisTarget(ArtifactLocation analysisTarget) {
        this.analysisTarget = analysisTarget;
    }

    public Result withAnalysisTarget(ArtifactLocation analysisTarget) {
        this.analysisTarget = analysisTarget;
        return this;
    }

    @JsonProperty(value="locations")
    public List<Location> getLocations() {
        return this.locations;
    }

    @JsonProperty(value="locations")
    public void setLocations(List<Location> locations) {
        this.locations = locations;
    }

    public Result withLocations(List<Location> locations) {
        this.locations = locations;
        return this;
    }

    @JsonProperty(value="guid")
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public Result withGuid(String guid) {
        this.guid = guid;
        return this;
    }

    @JsonProperty(value="correlationGuid")
    public String getCorrelationGuid() {
        return this.correlationGuid;
    }

    @JsonProperty(value="correlationGuid")
    public void setCorrelationGuid(String correlationGuid) {
        this.correlationGuid = correlationGuid;
    }

    public Result withCorrelationGuid(String correlationGuid) {
        this.correlationGuid = correlationGuid;
        return this;
    }

    @JsonProperty(value="occurrenceCount")
    public Integer getOccurrenceCount() {
        return this.occurrenceCount;
    }

    @JsonProperty(value="occurrenceCount")
    public void setOccurrenceCount(Integer occurrenceCount) {
        this.occurrenceCount = occurrenceCount;
    }

    public Result withOccurrenceCount(Integer occurrenceCount) {
        this.occurrenceCount = occurrenceCount;
        return this;
    }

    @JsonProperty(value="partialFingerprints")
    public PartialFingerprints getPartialFingerprints() {
        return this.partialFingerprints;
    }

    @JsonProperty(value="partialFingerprints")
    public void setPartialFingerprints(PartialFingerprints partialFingerprints) {
        this.partialFingerprints = partialFingerprints;
    }

    public Result withPartialFingerprints(PartialFingerprints partialFingerprints) {
        this.partialFingerprints = partialFingerprints;
        return this;
    }

    @JsonProperty(value="fingerprints")
    public Fingerprints getFingerprints() {
        return this.fingerprints;
    }

    @JsonProperty(value="fingerprints")
    public void setFingerprints(Fingerprints fingerprints) {
        this.fingerprints = fingerprints;
    }

    public Result withFingerprints(Fingerprints fingerprints) {
        this.fingerprints = fingerprints;
        return this;
    }

    @JsonProperty(value="stacks")
    public Set<Stack> getStacks() {
        return this.stacks;
    }

    @JsonProperty(value="stacks")
    public void setStacks(Set<Stack> stacks) {
        this.stacks = stacks;
    }

    public Result withStacks(Set<Stack> stacks) {
        this.stacks = stacks;
        return this;
    }

    @JsonProperty(value="codeFlows")
    public List<CodeFlow> getCodeFlows() {
        return this.codeFlows;
    }

    @JsonProperty(value="codeFlows")
    public void setCodeFlows(List<CodeFlow> codeFlows) {
        this.codeFlows = codeFlows;
    }

    public Result withCodeFlows(List<CodeFlow> codeFlows) {
        this.codeFlows = codeFlows;
        return this;
    }

    @JsonProperty(value="graphs")
    public Set<Graph> getGraphs() {
        return this.graphs;
    }

    @JsonProperty(value="graphs")
    public void setGraphs(Set<Graph> graphs) {
        this.graphs = graphs;
    }

    public Result withGraphs(Set<Graph> graphs) {
        this.graphs = graphs;
        return this;
    }

    @JsonProperty(value="graphTraversals")
    public Set<GraphTraversal> getGraphTraversals() {
        return this.graphTraversals;
    }

    @JsonProperty(value="graphTraversals")
    public void setGraphTraversals(Set<GraphTraversal> graphTraversals) {
        this.graphTraversals = graphTraversals;
    }

    public Result withGraphTraversals(Set<GraphTraversal> graphTraversals) {
        this.graphTraversals = graphTraversals;
        return this;
    }

    @JsonProperty(value="relatedLocations")
    public Set<Location> getRelatedLocations() {
        return this.relatedLocations;
    }

    @JsonProperty(value="relatedLocations")
    public void setRelatedLocations(Set<Location> relatedLocations) {
        this.relatedLocations = relatedLocations;
    }

    public Result withRelatedLocations(Set<Location> relatedLocations) {
        this.relatedLocations = relatedLocations;
        return this;
    }

    @JsonProperty(value="suppressions")
    public Set<Suppression> getSuppressions() {
        return this.suppressions;
    }

    @JsonProperty(value="suppressions")
    public void setSuppressions(Set<Suppression> suppressions) {
        this.suppressions = suppressions;
    }

    public Result withSuppressions(Set<Suppression> suppressions) {
        this.suppressions = suppressions;
        return this;
    }

    @JsonProperty(value="baselineState")
    public BaselineState getBaselineState() {
        return this.baselineState;
    }

    @JsonProperty(value="baselineState")
    public void setBaselineState(BaselineState baselineState) {
        this.baselineState = baselineState;
    }

    public Result withBaselineState(BaselineState baselineState) {
        this.baselineState = baselineState;
        return this;
    }

    @JsonProperty(value="rank")
    public Double getRank() {
        return this.rank;
    }

    @JsonProperty(value="rank")
    public void setRank(Double rank) {
        this.rank = rank;
    }

    public Result withRank(Double rank) {
        this.rank = rank;
        return this;
    }

    @JsonProperty(value="attachments")
    public Set<Attachment> getAttachments() {
        return this.attachments;
    }

    @JsonProperty(value="attachments")
    public void setAttachments(Set<Attachment> attachments) {
        this.attachments = attachments;
    }

    public Result withAttachments(Set<Attachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    @JsonProperty(value="hostedViewerUri")
    public URI getHostedViewerUri() {
        return this.hostedViewerUri;
    }

    @JsonProperty(value="hostedViewerUri")
    public void setHostedViewerUri(URI hostedViewerUri) {
        this.hostedViewerUri = hostedViewerUri;
    }

    public Result withHostedViewerUri(URI hostedViewerUri) {
        this.hostedViewerUri = hostedViewerUri;
        return this;
    }

    @JsonProperty(value="workItemUris")
    public Set<URI> getWorkItemUris() {
        return this.workItemUris;
    }

    @JsonProperty(value="workItemUris")
    public void setWorkItemUris(Set<URI> workItemUris) {
        this.workItemUris = workItemUris;
    }

    public Result withWorkItemUris(Set<URI> workItemUris) {
        this.workItemUris = workItemUris;
        return this;
    }

    @JsonProperty(value="provenance")
    public ResultProvenance getProvenance() {
        return this.provenance;
    }

    @JsonProperty(value="provenance")
    public void setProvenance(ResultProvenance provenance) {
        this.provenance = provenance;
    }

    public Result withProvenance(ResultProvenance provenance) {
        this.provenance = provenance;
        return this;
    }

    @JsonProperty(value="fixes")
    public Set<Fix> getFixes() {
        return this.fixes;
    }

    @JsonProperty(value="fixes")
    public void setFixes(Set<Fix> fixes) {
        this.fixes = fixes;
    }

    public Result withFixes(Set<Fix> fixes) {
        this.fixes = fixes;
        return this;
    }

    @JsonProperty(value="taxa")
    public Set<ReportingDescriptorReference> getTaxa() {
        return this.taxa;
    }

    @JsonProperty(value="taxa")
    public void setTaxa(Set<ReportingDescriptorReference> taxa) {
        this.taxa = taxa;
    }

    public Result withTaxa(Set<ReportingDescriptorReference> taxa) {
        this.taxa = taxa;
        return this;
    }

    @JsonProperty(value="webRequest")
    public WebRequest getWebRequest() {
        return this.webRequest;
    }

    @JsonProperty(value="webRequest")
    public void setWebRequest(WebRequest webRequest) {
        this.webRequest = webRequest;
    }

    public Result withWebRequest(WebRequest webRequest) {
        this.webRequest = webRequest;
        return this;
    }

    @JsonProperty(value="webResponse")
    public WebResponse getWebResponse() {
        return this.webResponse;
    }

    @JsonProperty(value="webResponse")
    public void setWebResponse(WebResponse webResponse) {
        this.webResponse = webResponse;
    }

    public Result withWebResponse(WebResponse webResponse) {
        this.webResponse = webResponse;
        return this;
    }

    @JsonProperty(value="properties")
    public PropertyBag getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    public void setProperties(PropertyBag properties) {
        this.properties = properties;
    }

    public Result withProperties(PropertyBag properties) {
        this.properties = properties;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Result.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("ruleId");
        sb.append('=');
        sb.append(this.ruleId == null ? "<null>" : this.ruleId);
        sb.append(',');
        sb.append("ruleIndex");
        sb.append('=');
        sb.append(this.ruleIndex == null ? "<null>" : this.ruleIndex);
        sb.append(',');
        sb.append("rule");
        sb.append('=');
        sb.append(this.rule == null ? "<null>" : this.rule);
        sb.append(',');
        sb.append("kind");
        sb.append('=');
        sb.append(this.kind == null ? "<null>" : this.kind);
        sb.append(',');
        sb.append("level");
        sb.append('=');
        sb.append(this.level == null ? "<null>" : this.level);
        sb.append(',');
        sb.append("message");
        sb.append('=');
        sb.append(this.message == null ? "<null>" : this.message);
        sb.append(',');
        sb.append("analysisTarget");
        sb.append('=');
        sb.append(this.analysisTarget == null ? "<null>" : this.analysisTarget);
        sb.append(',');
        sb.append("locations");
        sb.append('=');
        sb.append(this.locations == null ? "<null>" : this.locations);
        sb.append(',');
        sb.append("guid");
        sb.append('=');
        sb.append(this.guid == null ? "<null>" : this.guid);
        sb.append(',');
        sb.append("correlationGuid");
        sb.append('=');
        sb.append(this.correlationGuid == null ? "<null>" : this.correlationGuid);
        sb.append(',');
        sb.append("occurrenceCount");
        sb.append('=');
        sb.append(this.occurrenceCount == null ? "<null>" : this.occurrenceCount);
        sb.append(',');
        sb.append("partialFingerprints");
        sb.append('=');
        sb.append(this.partialFingerprints == null ? "<null>" : this.partialFingerprints);
        sb.append(',');
        sb.append("fingerprints");
        sb.append('=');
        sb.append(this.fingerprints == null ? "<null>" : this.fingerprints);
        sb.append(',');
        sb.append("stacks");
        sb.append('=');
        sb.append(this.stacks == null ? "<null>" : this.stacks);
        sb.append(',');
        sb.append("codeFlows");
        sb.append('=');
        sb.append(this.codeFlows == null ? "<null>" : this.codeFlows);
        sb.append(',');
        sb.append("graphs");
        sb.append('=');
        sb.append(this.graphs == null ? "<null>" : this.graphs);
        sb.append(',');
        sb.append("graphTraversals");
        sb.append('=');
        sb.append(this.graphTraversals == null ? "<null>" : this.graphTraversals);
        sb.append(',');
        sb.append("relatedLocations");
        sb.append('=');
        sb.append(this.relatedLocations == null ? "<null>" : this.relatedLocations);
        sb.append(',');
        sb.append("suppressions");
        sb.append('=');
        sb.append(this.suppressions == null ? "<null>" : this.suppressions);
        sb.append(',');
        sb.append("baselineState");
        sb.append('=');
        sb.append(this.baselineState == null ? "<null>" : this.baselineState);
        sb.append(',');
        sb.append("rank");
        sb.append('=');
        sb.append(this.rank == null ? "<null>" : this.rank);
        sb.append(',');
        sb.append("attachments");
        sb.append('=');
        sb.append(this.attachments == null ? "<null>" : this.attachments);
        sb.append(',');
        sb.append("hostedViewerUri");
        sb.append('=');
        sb.append(this.hostedViewerUri == null ? "<null>" : this.hostedViewerUri);
        sb.append(',');
        sb.append("workItemUris");
        sb.append('=');
        sb.append(this.workItemUris == null ? "<null>" : this.workItemUris);
        sb.append(',');
        sb.append("provenance");
        sb.append('=');
        sb.append(this.provenance == null ? "<null>" : this.provenance);
        sb.append(',');
        sb.append("fixes");
        sb.append('=');
        sb.append(this.fixes == null ? "<null>" : this.fixes);
        sb.append(',');
        sb.append("taxa");
        sb.append('=');
        sb.append(this.taxa == null ? "<null>" : this.taxa);
        sb.append(',');
        sb.append("webRequest");
        sb.append('=');
        sb.append(this.webRequest == null ? "<null>" : this.webRequest);
        sb.append(',');
        sb.append("webResponse");
        sb.append('=');
        sb.append(this.webResponse == null ? "<null>" : this.webResponse);
        sb.append(',');
        sb.append("properties");
        sb.append('=');
        sb.append(this.properties == null ? "<null>" : this.properties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.attachments == null ? 0 : this.attachments.hashCode());
        result = result * 31 + (this.correlationGuid == null ? 0 : this.correlationGuid.hashCode());
        result = result * 31 + (this.webRequest == null ? 0 : this.webRequest.hashCode());
        result = result * 31 + (this.graphTraversals == null ? 0 : this.graphTraversals.hashCode());
        result = result * 31 + (this.rule == null ? 0 : this.rule.hashCode());
        result = result * 31 + (this.analysisTarget == null ? 0 : this.analysisTarget.hashCode());
        result = result * 31 + (this.fixes == null ? 0 : this.fixes.hashCode());
        result = result * 31 + (this.relatedLocations == null ? 0 : this.relatedLocations.hashCode());
        result = result * 31 + (this.graphs == null ? 0 : this.graphs.hashCode());
        result = result * 31 + (this.provenance == null ? 0 : this.provenance.hashCode());
        result = result * 31 + (this.rank == null ? 0 : this.rank.hashCode());
        result = result * 31 + (this.ruleId == null ? 0 : this.ruleId.hashCode());
        result = result * 31 + (this.taxa == null ? 0 : this.taxa.hashCode());
        result = result * 31 + (this.ruleIndex == null ? 0 : this.ruleIndex.hashCode());
        result = result * 31 + (this.suppressions == null ? 0 : this.suppressions.hashCode());
        result = result * 31 + (this.level == null ? 0 : this.level.hashCode());
        result = result * 31 + (this.hostedViewerUri == null ? 0 : this.hostedViewerUri.hashCode());
        result = result * 31 + (this.kind == null ? 0 : this.kind.hashCode());
        result = result * 31 + (this.stacks == null ? 0 : this.stacks.hashCode());
        result = result * 31 + (this.occurrenceCount == null ? 0 : this.occurrenceCount.hashCode());
        result = result * 31 + (this.message == null ? 0 : this.message.hashCode());
        result = result * 31 + (this.fingerprints == null ? 0 : this.fingerprints.hashCode());
        result = result * 31 + (this.codeFlows == null ? 0 : this.codeFlows.hashCode());
        result = result * 31 + (this.guid == null ? 0 : this.guid.hashCode());
        result = result * 31 + (this.partialFingerprints == null ? 0 : this.partialFingerprints.hashCode());
        result = result * 31 + (this.webResponse == null ? 0 : this.webResponse.hashCode());
        result = result * 31 + (this.locations == null ? 0 : this.locations.hashCode());
        result = result * 31 + (this.baselineState == null ? 0 : this.baselineState.hashCode());
        result = result * 31 + (this.workItemUris == null ? 0 : this.workItemUris.hashCode());
        result = result * 31 + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Result)) {
            return false;
        }
        Result rhs = (Result)other;
        return (this.attachments == rhs.attachments || this.attachments != null && this.attachments.equals(rhs.attachments)) && (this.correlationGuid == rhs.correlationGuid || this.correlationGuid != null && this.correlationGuid.equals(rhs.correlationGuid)) && (this.webRequest == rhs.webRequest || this.webRequest != null && this.webRequest.equals(rhs.webRequest)) && (this.graphTraversals == rhs.graphTraversals || this.graphTraversals != null && this.graphTraversals.equals(rhs.graphTraversals)) && (this.rule == rhs.rule || this.rule != null && this.rule.equals(rhs.rule)) && (this.analysisTarget == rhs.analysisTarget || this.analysisTarget != null && this.analysisTarget.equals(rhs.analysisTarget)) && (this.fixes == rhs.fixes || this.fixes != null && this.fixes.equals(rhs.fixes)) && (this.relatedLocations == rhs.relatedLocations || this.relatedLocations != null && this.relatedLocations.equals(rhs.relatedLocations)) && (this.graphs == rhs.graphs || this.graphs != null && this.graphs.equals(rhs.graphs)) && (this.provenance == rhs.provenance || this.provenance != null && this.provenance.equals(rhs.provenance)) && (this.rank == rhs.rank || this.rank != null && this.rank.equals(rhs.rank)) && (this.ruleId == rhs.ruleId || this.ruleId != null && this.ruleId.equals(rhs.ruleId)) && (this.taxa == rhs.taxa || this.taxa != null && this.taxa.equals(rhs.taxa)) && (this.ruleIndex == rhs.ruleIndex || this.ruleIndex != null && this.ruleIndex.equals(rhs.ruleIndex)) && (this.suppressions == rhs.suppressions || this.suppressions != null && this.suppressions.equals(rhs.suppressions)) && (this.level == rhs.level || this.level != null && this.level.equals((Object)rhs.level)) && (this.hostedViewerUri == rhs.hostedViewerUri || this.hostedViewerUri != null && this.hostedViewerUri.equals(rhs.hostedViewerUri)) && (this.kind == rhs.kind || this.kind != null && this.kind.equals((Object)rhs.kind)) && (this.stacks == rhs.stacks || this.stacks != null && this.stacks.equals(rhs.stacks)) && (this.occurrenceCount == rhs.occurrenceCount || this.occurrenceCount != null && this.occurrenceCount.equals(rhs.occurrenceCount)) && (this.message == rhs.message || this.message != null && this.message.equals(rhs.message)) && (this.fingerprints == rhs.fingerprints || this.fingerprints != null && this.fingerprints.equals(rhs.fingerprints)) && (this.codeFlows == rhs.codeFlows || this.codeFlows != null && this.codeFlows.equals(rhs.codeFlows)) && (this.guid == rhs.guid || this.guid != null && this.guid.equals(rhs.guid)) && (this.partialFingerprints == rhs.partialFingerprints || this.partialFingerprints != null && this.partialFingerprints.equals(rhs.partialFingerprints)) && (this.webResponse == rhs.webResponse || this.webResponse != null && this.webResponse.equals(rhs.webResponse)) && (this.locations == rhs.locations || this.locations != null && this.locations.equals(rhs.locations)) && (this.baselineState == rhs.baselineState || this.baselineState != null && this.baselineState.equals((Object)rhs.baselineState)) && (this.workItemUris == rhs.workItemUris || this.workItemUris != null && this.workItemUris.equals(rhs.workItemUris)) && (this.properties == rhs.properties || this.properties != null && this.properties.equals(rhs.properties));
    }

    public static enum Kind {
        NOT_APPLICABLE("notApplicable"),
        PASS("pass"),
        FAIL("fail"),
        REVIEW("review"),
        OPEN("open"),
        INFORMATIONAL("informational");

        private final String value;
        private static final Map<String, Kind> CONSTANTS;

        private Kind(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Kind fromValue(String value) {
            Kind constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Kind>();
            for (Kind c : Kind.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum Level {
        NONE("none"),
        NOTE("note"),
        WARNING("warning"),
        ERROR("error");

        private final String value;
        private static final Map<String, Level> CONSTANTS;

        private Level(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Level fromValue(String value) {
            Level constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Level>();
            for (Level c : Level.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum BaselineState {
        NEW("new"),
        UNCHANGED("unchanged"),
        UPDATED("updated"),
        ABSENT("absent");

        private final String value;
        private static final Map<String, BaselineState> CONSTANTS;

        private BaselineState(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static BaselineState fromValue(String value) {
            BaselineState constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, BaselineState>();
            for (BaselineState c : BaselineState.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

