/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sarif.pojo;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.sarif.pojo.PropertyBag;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"enabled", "level", "rank", "parameters", "properties"})
public class ReportingConfiguration {
    @Nullable
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Specifies whether the report may be produced during the scan.")
    private Boolean enabled;
    @Nullable
    @JsonProperty(value="level")
    @JsonPropertyDescription(value="Specifies the failure level for the report.")
    private Level level;
    @Nullable
    @JsonProperty(value="rank")
    @JsonPropertyDescription(value="Specifies the relative priority of the report. Used for analysis output only.")
    private Double rank;
    @Nullable
    @JsonProperty(value="parameters")
    @JsonPropertyDescription(value="Key/value pairs that provide additional information about the object.")
    private PropertyBag parameters;
    @Nullable
    @JsonProperty(value="properties")
    @JsonPropertyDescription(value="Key/value pairs that provide additional information about the object.")
    private PropertyBag properties;

    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public ReportingConfiguration withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @JsonProperty(value="level")
    public Level getLevel() {
        return this.level;
    }

    @JsonProperty(value="level")
    public void setLevel(Level level) {
        this.level = level;
    }

    public ReportingConfiguration withLevel(Level level) {
        this.level = level;
        return this;
    }

    @JsonProperty(value="rank")
    public Double getRank() {
        return this.rank;
    }

    @JsonProperty(value="rank")
    public void setRank(Double rank) {
        this.rank = rank;
    }

    public ReportingConfiguration withRank(Double rank) {
        this.rank = rank;
        return this;
    }

    @JsonProperty(value="parameters")
    public PropertyBag getParameters() {
        return this.parameters;
    }

    @JsonProperty(value="parameters")
    public void setParameters(PropertyBag parameters) {
        this.parameters = parameters;
    }

    public ReportingConfiguration withParameters(PropertyBag parameters) {
        this.parameters = parameters;
        return this;
    }

    @JsonProperty(value="properties")
    public PropertyBag getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    public void setProperties(PropertyBag properties) {
        this.properties = properties;
    }

    public ReportingConfiguration withProperties(PropertyBag properties) {
        this.properties = properties;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ReportingConfiguration.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("enabled");
        sb.append('=');
        sb.append(this.enabled == null ? "<null>" : this.enabled);
        sb.append(',');
        sb.append("level");
        sb.append('=');
        sb.append(this.level == null ? "<null>" : this.level);
        sb.append(',');
        sb.append("rank");
        sb.append('=');
        sb.append(this.rank == null ? "<null>" : this.rank);
        sb.append(',');
        sb.append("parameters");
        sb.append('=');
        sb.append(this.parameters == null ? "<null>" : this.parameters);
        sb.append(',');
        sb.append("properties");
        sb.append('=');
        sb.append(this.properties == null ? "<null>" : this.properties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.rank == null ? 0 : this.rank.hashCode());
        result = result * 31 + (this.level == null ? 0 : this.level.hashCode());
        result = result * 31 + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = result * 31 + (this.enabled == null ? 0 : this.enabled.hashCode());
        result = result * 31 + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ReportingConfiguration)) {
            return false;
        }
        ReportingConfiguration rhs = (ReportingConfiguration)other;
        return (this.rank == rhs.rank || this.rank != null && this.rank.equals(rhs.rank)) && (this.level == rhs.level || this.level != null && this.level.equals((Object)rhs.level)) && (this.parameters == rhs.parameters || this.parameters != null && this.parameters.equals(rhs.parameters)) && (this.enabled == rhs.enabled || this.enabled != null && this.enabled.equals(rhs.enabled)) && (this.properties == rhs.properties || this.properties != null && this.properties.equals(rhs.properties));
    }

    public static enum Level {
        NONE("none"),
        NOTE("note"),
        WARNING("warning"),
        ERROR("error");

        private final String value;
        private static final Map<String, Level> CONSTANTS;

        private Level(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Level fromValue(String value) {
            Level constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Level>();
            for (Level c : Level.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

