/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sarif.pojo;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonar.sarif.pojo.Location;
import org.sonar.sarif.pojo.Message;
import org.sonar.sarif.pojo.PropertyBag;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"id", "label", "location", "children", "properties"})
public class Node {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="A string that uniquely identifies the node within its graph.")
    @Nonnull
    private String id;
    @Nullable
    @JsonProperty(value="label")
    @JsonPropertyDescription(value="Encapsulates a message intended to be read by the end user.")
    private Message label;
    @Nullable
    @JsonProperty(value="location")
    @JsonPropertyDescription(value="A location within a programming artifact.")
    private Location location;
    @Nullable
    @JsonProperty(value="children")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="Array of child nodes.")
    private Set<Node> children;
    @Nullable
    @JsonProperty(value="properties")
    @JsonPropertyDescription(value="Key/value pairs that provide additional information about the object.")
    private PropertyBag properties;

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    public Node withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="label")
    public Message getLabel() {
        return this.label;
    }

    @JsonProperty(value="label")
    public void setLabel(Message label) {
        this.label = label;
    }

    public Node withLabel(Message label) {
        this.label = label;
        return this;
    }

    @JsonProperty(value="location")
    public Location getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    public void setLocation(Location location) {
        this.location = location;
    }

    public Node withLocation(Location location) {
        this.location = location;
        return this;
    }

    @JsonProperty(value="children")
    public Set<Node> getChildren() {
        return this.children;
    }

    @JsonProperty(value="children")
    public void setChildren(Set<Node> children) {
        this.children = children;
    }

    public Node withChildren(Set<Node> children) {
        this.children = children;
        return this;
    }

    @JsonProperty(value="properties")
    public PropertyBag getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    public void setProperties(PropertyBag properties) {
        this.properties = properties;
    }

    public Node withProperties(PropertyBag properties) {
        this.properties = properties;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Node.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("label");
        sb.append('=');
        sb.append(this.label == null ? "<null>" : this.label);
        sb.append(',');
        sb.append("location");
        sb.append('=');
        sb.append(this.location == null ? "<null>" : this.location);
        sb.append(',');
        sb.append("children");
        sb.append('=');
        sb.append(this.children == null ? "<null>" : this.children);
        sb.append(',');
        sb.append("properties");
        sb.append('=');
        sb.append(this.properties == null ? "<null>" : this.properties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.location == null ? 0 : this.location.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.label == null ? 0 : this.label.hashCode());
        result = result * 31 + (this.children == null ? 0 : this.children.hashCode());
        result = result * 31 + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Node)) {
            return false;
        }
        Node rhs = (Node)other;
        return (this.location == rhs.location || this.location != null && this.location.equals(rhs.location)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.label == rhs.label || this.label != null && this.label.equals(rhs.label)) && (this.children == rhs.children || this.children != null && this.children.equals(rhs.children)) && (this.properties == rhs.properties || this.properties != null && this.properties.equals(rhs.properties));
    }
}

