/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sarif.pojo;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.sarif.pojo.PropertyBag;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"text", "markdown", "id", "arguments", "properties"})
public class Message {
    @Nullable
    @JsonProperty(value="text")
    @JsonPropertyDescription(value="A plain text message string.")
    private String text;
    @Nullable
    @JsonProperty(value="markdown")
    @JsonPropertyDescription(value="A Markdown message string.")
    private String markdown;
    @Nullable
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="The identifier for this message.")
    private String id;
    @Nullable
    @JsonProperty(value="arguments")
    @JsonPropertyDescription(value="An array of strings to substitute into the message string.")
    private List<String> arguments;
    @Nullable
    @JsonProperty(value="properties")
    @JsonPropertyDescription(value="Key/value pairs that provide additional information about the object.")
    private PropertyBag properties;

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="text")
    public void setText(String text) {
        this.text = text;
    }

    public Message withText(String text) {
        this.text = text;
        return this;
    }

    @JsonProperty(value="markdown")
    public String getMarkdown() {
        return this.markdown;
    }

    @JsonProperty(value="markdown")
    public void setMarkdown(String markdown) {
        this.markdown = markdown;
    }

    public Message withMarkdown(String markdown) {
        this.markdown = markdown;
        return this;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    public Message withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="arguments")
    public List<String> getArguments() {
        return this.arguments;
    }

    @JsonProperty(value="arguments")
    public void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }

    public Message withArguments(List<String> arguments) {
        this.arguments = arguments;
        return this;
    }

    @JsonProperty(value="properties")
    public PropertyBag getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    public void setProperties(PropertyBag properties) {
        this.properties = properties;
    }

    public Message withProperties(PropertyBag properties) {
        this.properties = properties;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Message.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("text");
        sb.append('=');
        sb.append(this.text == null ? "<null>" : this.text);
        sb.append(',');
        sb.append("markdown");
        sb.append('=');
        sb.append(this.markdown == null ? "<null>" : this.markdown);
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("arguments");
        sb.append('=');
        sb.append(this.arguments == null ? "<null>" : this.arguments);
        sb.append(',');
        sb.append("properties");
        sb.append('=');
        sb.append(this.properties == null ? "<null>" : this.properties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.markdown == null ? 0 : this.markdown.hashCode());
        result = result * 31 + (this.arguments == null ? 0 : this.arguments.hashCode());
        result = result * 31 + (this.text == null ? 0 : this.text.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Message)) {
            return false;
        }
        Message rhs = (Message)other;
        return (this.markdown == rhs.markdown || this.markdown != null && this.markdown.equals(rhs.markdown)) && (this.arguments == rhs.arguments || this.arguments != null && this.arguments.equals(rhs.arguments)) && (this.text == rhs.text || this.text != null && this.text.equals(rhs.text)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.properties == rhs.properties || this.properties != null && this.properties.equals(rhs.properties));
    }
}

