/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sarif.pojo;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonar.sarif.pojo.ArtifactLocation;
import org.sonar.sarif.pojo.Invocation;
import org.sonar.sarif.pojo.PropertyBag;
import org.sonar.sarif.pojo.Tool;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"tool", "invocation", "analysisToolLogFiles", "properties"})
public class Conversion {
    @Nullable
    @JsonProperty(value="tool")
    @JsonPropertyDescription(value="The analysis tool that was run.")
    @Nonnull
    private Tool tool;
    @Nullable
    @JsonProperty(value="invocation")
    @JsonPropertyDescription(value="The runtime environment of the analysis tool run.")
    private Invocation invocation;
    @Nullable
    @JsonProperty(value="analysisToolLogFiles")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="The locations of the analysis tool's per-run log files.")
    private Set<ArtifactLocation> analysisToolLogFiles;
    @Nullable
    @JsonProperty(value="properties")
    @JsonPropertyDescription(value="Key/value pairs that provide additional information about the object.")
    private PropertyBag properties;

    @JsonProperty(value="tool")
    public Tool getTool() {
        return this.tool;
    }

    @JsonProperty(value="tool")
    public void setTool(Tool tool) {
        this.tool = tool;
    }

    public Conversion withTool(Tool tool) {
        this.tool = tool;
        return this;
    }

    @JsonProperty(value="invocation")
    public Invocation getInvocation() {
        return this.invocation;
    }

    @JsonProperty(value="invocation")
    public void setInvocation(Invocation invocation) {
        this.invocation = invocation;
    }

    public Conversion withInvocation(Invocation invocation) {
        this.invocation = invocation;
        return this;
    }

    @JsonProperty(value="analysisToolLogFiles")
    public Set<ArtifactLocation> getAnalysisToolLogFiles() {
        return this.analysisToolLogFiles;
    }

    @JsonProperty(value="analysisToolLogFiles")
    public void setAnalysisToolLogFiles(Set<ArtifactLocation> analysisToolLogFiles) {
        this.analysisToolLogFiles = analysisToolLogFiles;
    }

    public Conversion withAnalysisToolLogFiles(Set<ArtifactLocation> analysisToolLogFiles) {
        this.analysisToolLogFiles = analysisToolLogFiles;
        return this;
    }

    @JsonProperty(value="properties")
    public PropertyBag getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    public void setProperties(PropertyBag properties) {
        this.properties = properties;
    }

    public Conversion withProperties(PropertyBag properties) {
        this.properties = properties;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Conversion.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("tool");
        sb.append('=');
        sb.append(this.tool == null ? "<null>" : this.tool);
        sb.append(',');
        sb.append("invocation");
        sb.append('=');
        sb.append(this.invocation == null ? "<null>" : this.invocation);
        sb.append(',');
        sb.append("analysisToolLogFiles");
        sb.append('=');
        sb.append(this.analysisToolLogFiles == null ? "<null>" : this.analysisToolLogFiles);
        sb.append(',');
        sb.append("properties");
        sb.append('=');
        sb.append(this.properties == null ? "<null>" : this.properties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.invocation == null ? 0 : this.invocation.hashCode());
        result = result * 31 + (this.analysisToolLogFiles == null ? 0 : this.analysisToolLogFiles.hashCode());
        result = result * 31 + (this.tool == null ? 0 : this.tool.hashCode());
        result = result * 31 + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Conversion)) {
            return false;
        }
        Conversion rhs = (Conversion)other;
        return (this.invocation == rhs.invocation || this.invocation != null && this.invocation.equals(rhs.invocation)) && (this.analysisToolLogFiles == rhs.analysisToolLogFiles || this.analysisToolLogFiles != null && this.analysisToolLogFiles.equals(rhs.analysisToolLogFiles)) && (this.tool == rhs.tool || this.tool != null && this.tool.equals(rhs.tool)) && (this.properties == rhs.properties || this.properties != null && this.properties.equals(rhs.properties));
    }
}

