/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.statement;

import java.util.List;
import org.sonar.duplications.statement.Statement;
import org.sonar.duplications.statement.StatementChannel;
import org.sonar.duplications.token.Token;
import org.sonar.duplications.token.TokenQueue;

public class StatementChannelDisptacher {
    private final StatementChannel[] channels;

    public StatementChannelDisptacher(List<StatementChannel> channels) {
        this.channels = channels.toArray(new StatementChannel[channels.size()]);
    }

    public boolean consume(TokenQueue tokenQueue, List<Statement> statements) {
        Token nextToken = tokenQueue.peek();
        while (nextToken != null) {
            boolean channelConsumed = false;
            for (StatementChannel channel : this.channels) {
                if (!channel.consume(tokenQueue, statements)) continue;
                channelConsumed = true;
                break;
            }
            if (!channelConsumed) {
                throw new IllegalStateException("None of the statement channel has been able to consume token: " + String.valueOf(nextToken));
            }
            nextToken = tokenQueue.peek();
        }
        return true;
    }
}

